# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CameraWirelessProfilesArgs', 'CameraWirelessProfiles']

@pulumi.input_type
class CameraWirelessProfilesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 identity: Optional[pulumi.Input['CameraWirelessProfilesIdentityArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ssid: Optional[pulumi.Input['CameraWirelessProfilesSsidArgs']] = None,
                 wireless_profile_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CameraWirelessProfiles resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['CameraWirelessProfilesIdentityArgs'] identity: The identity of the wireless profile. Required for creating wireless profiles in 8021x-radius auth mode.
        :param pulumi.Input[builtins.str] name: The name of the camera wireless profile. This parameter is required.
        :param pulumi.Input['CameraWirelessProfilesSsidArgs'] ssid: The details of the SSID config.
        :param pulumi.Input[builtins.str] wireless_profile_id: wirelessProfileId path parameter. Wireless profile ID
        """
        pulumi.set(__self__, "network_id", network_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ssid is not None:
            pulumi.set(__self__, "ssid", ssid)
        if wireless_profile_id is not None:
            pulumi.set(__self__, "wireless_profile_id", wireless_profile_id)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['CameraWirelessProfilesIdentityArgs']]:
        """
        The identity of the wireless profile. Required for creating wireless profiles in 8021x-radius auth mode.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['CameraWirelessProfilesIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the camera wireless profile. This parameter is required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ssid(self) -> Optional[pulumi.Input['CameraWirelessProfilesSsidArgs']]:
        """
        The details of the SSID config.
        """
        return pulumi.get(self, "ssid")

    @ssid.setter
    def ssid(self, value: Optional[pulumi.Input['CameraWirelessProfilesSsidArgs']]):
        pulumi.set(self, "ssid", value)

    @property
    @pulumi.getter(name="wirelessProfileId")
    def wireless_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        wirelessProfileId path parameter. Wireless profile ID
        """
        return pulumi.get(self, "wireless_profile_id")

    @wireless_profile_id.setter
    def wireless_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wireless_profile_id", value)


@pulumi.input_type
class _CameraWirelessProfilesState:
    def __init__(__self__, *,
                 applied_device_count: Optional[pulumi.Input[builtins.int]] = None,
                 identity: Optional[pulumi.Input['CameraWirelessProfilesIdentityArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 ssid: Optional[pulumi.Input['CameraWirelessProfilesSsidArgs']] = None,
                 wireless_profile_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CameraWirelessProfiles resources.
        :param pulumi.Input['CameraWirelessProfilesIdentityArgs'] identity: The identity of the wireless profile. Required for creating wireless profiles in 8021x-radius auth mode.
        :param pulumi.Input[builtins.str] name: The name of the camera wireless profile. This parameter is required.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['CameraWirelessProfilesSsidArgs'] ssid: The details of the SSID config.
        :param pulumi.Input[builtins.str] wireless_profile_id: wirelessProfileId path parameter. Wireless profile ID
        """
        if applied_device_count is not None:
            pulumi.set(__self__, "applied_device_count", applied_device_count)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if ssid is not None:
            pulumi.set(__self__, "ssid", ssid)
        if wireless_profile_id is not None:
            pulumi.set(__self__, "wireless_profile_id", wireless_profile_id)

    @property
    @pulumi.getter(name="appliedDeviceCount")
    def applied_device_count(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "applied_device_count")

    @applied_device_count.setter
    def applied_device_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "applied_device_count", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['CameraWirelessProfilesIdentityArgs']]:
        """
        The identity of the wireless profile. Required for creating wireless profiles in 8021x-radius auth mode.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['CameraWirelessProfilesIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the camera wireless profile. This parameter is required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def ssid(self) -> Optional[pulumi.Input['CameraWirelessProfilesSsidArgs']]:
        """
        The details of the SSID config.
        """
        return pulumi.get(self, "ssid")

    @ssid.setter
    def ssid(self, value: Optional[pulumi.Input['CameraWirelessProfilesSsidArgs']]):
        pulumi.set(self, "ssid", value)

    @property
    @pulumi.getter(name="wirelessProfileId")
    def wireless_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        wirelessProfileId path parameter. Wireless profile ID
        """
        return pulumi.get(self, "wireless_profile_id")

    @wireless_profile_id.setter
    def wireless_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wireless_profile_id", value)


class CameraWirelessProfiles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['CameraWirelessProfilesIdentityArgs', 'CameraWirelessProfilesIdentityArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 ssid: Optional[pulumi.Input[Union['CameraWirelessProfilesSsidArgs', 'CameraWirelessProfilesSsidArgsDict']]] = None,
                 wireless_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/cameraWirelessProfiles:CameraWirelessProfiles example "network_id,wireless_profile_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CameraWirelessProfilesIdentityArgs', 'CameraWirelessProfilesIdentityArgsDict']] identity: The identity of the wireless profile. Required for creating wireless profiles in 8021x-radius auth mode.
        :param pulumi.Input[builtins.str] name: The name of the camera wireless profile. This parameter is required.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['CameraWirelessProfilesSsidArgs', 'CameraWirelessProfilesSsidArgsDict']] ssid: The details of the SSID config.
        :param pulumi.Input[builtins.str] wireless_profile_id: wirelessProfileId path parameter. Wireless profile ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CameraWirelessProfilesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/cameraWirelessProfiles:CameraWirelessProfiles example "network_id,wireless_profile_id"
        ```

        :param str resource_name: The name of the resource.
        :param CameraWirelessProfilesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CameraWirelessProfilesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['CameraWirelessProfilesIdentityArgs', 'CameraWirelessProfilesIdentityArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 ssid: Optional[pulumi.Input[Union['CameraWirelessProfilesSsidArgs', 'CameraWirelessProfilesSsidArgsDict']]] = None,
                 wireless_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CameraWirelessProfilesArgs.__new__(CameraWirelessProfilesArgs)

            __props__.__dict__["identity"] = identity
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["ssid"] = ssid
            __props__.__dict__["wireless_profile_id"] = wireless_profile_id
            __props__.__dict__["applied_device_count"] = None
        super(CameraWirelessProfiles, __self__).__init__(
            'meraki:networks/cameraWirelessProfiles:CameraWirelessProfiles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            applied_device_count: Optional[pulumi.Input[builtins.int]] = None,
            identity: Optional[pulumi.Input[Union['CameraWirelessProfilesIdentityArgs', 'CameraWirelessProfilesIdentityArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            ssid: Optional[pulumi.Input[Union['CameraWirelessProfilesSsidArgs', 'CameraWirelessProfilesSsidArgsDict']]] = None,
            wireless_profile_id: Optional[pulumi.Input[builtins.str]] = None) -> 'CameraWirelessProfiles':
        """
        Get an existing CameraWirelessProfiles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CameraWirelessProfilesIdentityArgs', 'CameraWirelessProfilesIdentityArgsDict']] identity: The identity of the wireless profile. Required for creating wireless profiles in 8021x-radius auth mode.
        :param pulumi.Input[builtins.str] name: The name of the camera wireless profile. This parameter is required.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['CameraWirelessProfilesSsidArgs', 'CameraWirelessProfilesSsidArgsDict']] ssid: The details of the SSID config.
        :param pulumi.Input[builtins.str] wireless_profile_id: wirelessProfileId path parameter. Wireless profile ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CameraWirelessProfilesState.__new__(_CameraWirelessProfilesState)

        __props__.__dict__["applied_device_count"] = applied_device_count
        __props__.__dict__["identity"] = identity
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["ssid"] = ssid
        __props__.__dict__["wireless_profile_id"] = wireless_profile_id
        return CameraWirelessProfiles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appliedDeviceCount")
    def applied_device_count(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "applied_device_count")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.CameraWirelessProfilesIdentity']:
        """
        The identity of the wireless profile. Required for creating wireless profiles in 8021x-radius auth mode.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the camera wireless profile. This parameter is required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def ssid(self) -> pulumi.Output['outputs.CameraWirelessProfilesSsid']:
        """
        The details of the SSID config.
        """
        return pulumi.get(self, "ssid")

    @property
    @pulumi.getter(name="wirelessProfileId")
    def wireless_profile_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        wirelessProfileId path parameter. Wireless profile ID
        """
        return pulumi.get(self, "wireless_profile_id")

