"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
/**
 * Use a S3 as an alias record target
 */
class BucketWebsiteTarget {
    constructor(bucket) {
        this.bucket = bucket;
    }
    bind(_record) {
        const { region } = core_1.Stack.of(this.bucket.stack);
        if (core_1.Token.isUnresolved(region)) {
            throw new Error([
                'Cannot use an S3 record alias in region-agnostic stacks.',
                'You must specify a specific region when you define the stack',
                '(see https://docs.aws.amazon.com/cdk/latest/guide/environments.html)'
            ].join(' '));
        }
        const hostedZoneId = region_info_1.RegionInfo.get(region).s3StaticWebsiteHostedZoneId;
        if (!hostedZoneId) {
            throw new Error(`Bucket website target is not supported for the "${region}" region`);
        }
        return {
            hostedZoneId,
            dnsName: this.bucket.bucketWebsiteUrl,
        };
    }
}
exports.BucketWebsiteTarget = BucketWebsiteTarget;
//# sourceMappingURL=data:application/json;base64,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