/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.OptimizationEngine;
import com.example.SqlQueryProcessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;

public class SqlOptimizer {
    private static final ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: java -jar sql-optimizer.jar \"SQL_QUERY\" [METADATA_JSON] [OPTIMIZATION_RULES_FILE]");
            System.err.println("Examples:");
            System.err.println("  java -jar sql-optimizer.jar \"SELECT * FROM employees\"");
            System.err.println("  java -jar sql-optimizer.jar \"SELECT * FROM employees\" '{\"employees\":{\"columns\":{\"id\":{\"type\":\"INTEGER\"}}}}'");
            System.err.println("  java -jar sql-optimizer.jar \"SELECT * FROM employees\" metadata.json rules.json");
            System.exit(1);
        }
        String sqlQuery = args[0];
        String metadataJson = args.length > 1 ? args[1] : null;
        String optimizationRulesFile = args.length > 2 ? args[2] : null;
        try {
            String optimizedPlan = SqlOptimizer.optimizeQuery(sqlQuery, metadataJson, optimizationRulesFile);
            System.out.println(optimizedPlan);
        }
        catch (Exception e) {
            System.err.println("Error optimizing query: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String optimizeQuery(String sqlQuery, String metadataJson) throws Exception {
        return SqlOptimizer.optimizeQuery(sqlQuery, metadataJson, null);
    }

    public static String optimizeQuery(String sqlQuery, String metadataJson, String optimizationRulesFile) throws Exception {
        try {
            SchemaPlus schema = SqlOptimizer.createSchemaFromMetadata(metadataJson);
            FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(schema).build();
            RelNode relNode = SqlQueryProcessor.processQuery(sqlQuery, config);
            OptimizationEngine optimizationEngine = new OptimizationEngine();
            Map<String, Object> optimizationStats = new HashMap<String, Object>();
            if (optimizationRulesFile != null && !optimizationRulesFile.trim().isEmpty()) {
                try {
                    optimizationEngine.loadRulesFromFile(optimizationRulesFile);
                    relNode = optimizationEngine.optimize(relNode);
                    optimizationStats = optimizationEngine.getOptimizationStats();
                }
                catch (Exception e) {
                    System.err.println("\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u043e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u0438: " + e.getMessage());
                }
            }
            return SqlOptimizer.convertToJson(relNode, sqlQuery, metadataJson, optimizationStats);
        }
        catch (SqlParseException e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 SQL \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + e.getMessage() + "\n\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441 SQL \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + sqlQuery);
        }
        catch (UnsupportedOperationException e) {
            throw new RuntimeException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + e.getMessage() + "\n\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e SELECT \u0437\u0430\u043f\u0440\u043e\u0441\u044b");
        }
        catch (Exception e) {
            throw new RuntimeException("\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + e.getMessage() + "\nSQL \u0437\u0430\u043f\u0440\u043e\u0441: " + sqlQuery);
        }
    }

    private static SchemaPlus createSchemaFromMetadata(String metadataJson) throws Exception {
        CalciteSchema rootSchema = CalciteSchema.createRootSchema(true);
        if (metadataJson != null && !metadataJson.trim().isEmpty()) {
            try {
                Map metadata = objectMapper.readValue(metadataJson, Map.class);
                TestData testData = SqlOptimizer.createTestDataFromMetadata(metadata);
                ReflectiveSchema schema = new ReflectiveSchema(testData);
                return rootSchema.plus().add("TEST", schema);
            }
            catch (Exception e) {
                System.err.println("Warning: Failed to parse metadata JSON, using default data: " + e.getMessage());
                TestData testData = new TestData();
                ReflectiveSchema schema = new ReflectiveSchema(testData);
                return rootSchema.plus().add("TEST", schema);
            }
        }
        TestData testData = new TestData();
        ReflectiveSchema schema = new ReflectiveSchema(testData);
        return rootSchema.plus().add("TEST", schema);
    }

    private static TestData createTestDataFromMetadata(Map<String, Object> metadata) {
        TestData testData = new TestData();
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            String tableName = entry.getKey();
            Map tableInfo = (Map)entry.getValue();
            Object[] tableData = SqlOptimizer.createTableData(tableName, tableInfo);
            try {
                Field field = TestData.class.getField(tableName);
                field.set(testData, tableData);
            }
            catch (Exception e) {
                System.err.println("Warning: Could not set data for table " + tableName + ": " + e.getMessage());
            }
        }
        return testData;
    }

    private static Object[] createTableData(String tableName, Map<String, Object> tableInfo) {
        Map columns = (Map)tableInfo.get("columns");
        if (columns == null) {
            return SqlOptimizer.createDefaultTableData(tableName);
        }
        int rowCount = 5;
        if (tableInfo.containsKey("rowCount")) {
            rowCount = ((Number)tableInfo.get("rowCount")).intValue();
        }
        Object[][] data = new Object[rowCount][];
        for (int i = 0; i < rowCount; ++i) {
            data[i] = SqlOptimizer.createTestRow(columns, i);
        }
        return data;
    }

    private static Object[] createTestRow(Map<String, Object> columns, int rowIndex) {
        Object[] row = new Object[columns.size()];
        int colIndex = 0;
        for (Map.Entry<String, Object> colEntry : columns.entrySet()) {
            Map colInfo = (Map)colEntry.getValue();
            String colType = (String)colInfo.get("type");
            row[colIndex] = SqlOptimizer.createTestValue(colType, rowIndex, colIndex);
            ++colIndex;
        }
        return row;
    }

    private static Object createTestValue(String type, int rowIndex, int colIndex) {
        if (type == null) {
            return "value_" + rowIndex + "_" + colIndex;
        }
        switch (type.toUpperCase()) {
            case "INTEGER": 
            case "INT": {
                return rowIndex + colIndex + 1;
            }
            case "VARCHAR": 
            case "STRING": 
            case "TEXT": {
                return "value_" + rowIndex + "_" + colIndex;
            }
            case "DOUBLE": 
            case "FLOAT": 
            case "DECIMAL": {
                return (double)(rowIndex + colIndex + 1) * 1.5;
            }
            case "BOOLEAN": 
            case "BOOL": {
                return (rowIndex + colIndex) % 2 == 0;
            }
        }
        return "value_" + rowIndex + "_" + colIndex;
    }

    private static Object[] createDefaultTableData(String tableName) {
        switch (tableName.toLowerCase()) {
            case "employees": {
                return new Object[]{new Object[]{1, "John", "IT", 50000}, new Object[]{2, "Jane", "HR", 45000}, new Object[]{3, "Bob", "IT", 55000}, new Object[]{4, "Alice", "Finance", 60000}, new Object[]{5, "Charlie", "IT", 52000}};
            }
            case "departments": {
                return new Object[]{new Object[]{1, "IT", "Building A"}, new Object[]{2, "HR", "Building B"}, new Object[]{3, "Finance", "Building C"}};
            }
            case "projects": {
                return new Object[]{new Object[]{1, "Project Alpha", 1, "Active"}, new Object[]{2, "Project Beta", 2, "Completed"}, new Object[]{3, "Project Gamma", 1, "Active"}, new Object[]{4, "Project Delta", 3, "Planning"}};
            }
            case "users": {
                return new Object[]{new Object[]{1, "John Doe", "john@example.com", "active"}, new Object[]{2, "Jane Smith", "jane@example.com", "active"}, new Object[]{3, "Bob Johnson", "bob@example.com", "inactive"}, new Object[]{4, "Alice Brown", "alice@example.com", "active"}};
            }
            case "posts": {
                return new Object[]{new Object[]{1, "First Post", "Content of first post", 1, "2023-01-01", true}, new Object[]{2, "Second Post", "Content of second post", 1, "2023-01-02", true}, new Object[]{3, "Third Post", "Content of third post", 2, "2023-01-03", false}, new Object[]{4, "Fourth Post", "Content of fourth post", 3, "2023-01-04", true}};
            }
        }
        return new Object[]{new Object[]{"row1_col1", "row1_col2"}, new Object[]{"row2_col1", "row2_col2"}, new Object[]{"row3_col1", "row3_col2"}};
    }

    private static String convertToJson(RelNode relNode, String originalQuery, String metadataJson, Map<String, Object> optimizationStats) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("originalQuery", originalQuery);
        if (metadataJson != null && !metadataJson.trim().isEmpty()) {
            try {
                result.put("metadata", objectMapper.readValue(metadataJson, Object.class));
            }
            catch (Exception e) {
                System.err.println("Warning: Failed to parse metadata for output: " + e.getMessage());
            }
        }
        result.put("optimizedPlan", SqlOptimizer.convertRelNodeToMap(relNode));
        result.put("explanation", RelOptUtil.toString(relNode));
        if (!optimizationStats.isEmpty()) {
            result.put("optimizationStats", optimizationStats);
        }
        return objectMapper.writeValueAsString(result);
    }

    private static Map<String, Object> convertRelNodeToMap(RelNode relNode) {
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        nodeMap.put("relType", relNode.getRelTypeName());
        nodeMap.put("rowType", SqlOptimizer.convertRelDataTypeToMap(relNode.getRowType()));
        try {
            nodeMap.put("cost", relNode.getCluster().getMetadataQuery().getCumulativeCost(relNode));
        }
        catch (Exception e) {
            nodeMap.put("cost", "N/A");
        }
        if (relNode.getInputs().size() > 0) {
            nodeMap.put("inputs", relNode.getInputs().stream().map(SqlOptimizer::convertRelNodeToMap).toArray());
        }
        return nodeMap;
    }

    private static Map<String, Object> convertRelDataTypeToMap(RelDataType relDataType) {
        HashMap<String, Object> typeMap = new HashMap<String, Object>();
        typeMap.put("fieldCount", relDataType.getFieldCount());
        typeMap.put("nullable", relDataType.isNullable());
        HashMap<String, String> fields = new HashMap<String, String>();
        for (int i = 0; i < relDataType.getFieldCount(); ++i) {
            String fieldName = relDataType.getFieldList().get(i).getName();
            String fieldType = relDataType.getFieldList().get(i).getType().getSqlTypeName().toString();
            fields.put(fieldName, fieldType);
        }
        typeMap.put("fields", fields);
        return typeMap;
    }

    public static class TestData {
        public Object[] employees = new Object[]{new Object[]{1, "John", "IT", 50000}, new Object[]{2, "Jane", "HR", 45000}, new Object[]{3, "Bob", "IT", 55000}, new Object[]{4, "Alice", "Finance", 60000}, new Object[]{5, "Charlie", "IT", 52000}};
        public Object[] departments = new Object[]{new Object[]{1, "IT", "Building A"}, new Object[]{2, "HR", "Building B"}, new Object[]{3, "Finance", "Building C"}};
        public Object[] projects = new Object[]{new Object[]{1, "Project Alpha", 1, "Active"}, new Object[]{2, "Project Beta", 2, "Completed"}, new Object[]{3, "Project Gamma", 1, "Active"}, new Object[]{4, "Project Delta", 3, "Planning"}};
        public Object[] users = new Object[0];
        public Object[] posts = new Object[0];
        public Object[] orders = new Object[0];
        public Object[] products = new Object[0];
        public Object[] custom_table = new Object[0];
    }
}

