/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RelBuilder;

public class SqlQueryProcessor {
    public static RelNode processQuery(String sqlQuery, FrameworkConfig config) throws Exception {
        SqlNode sqlNode = SqlQueryProcessor.parseSql(sqlQuery);
        return SqlQueryProcessor.convertToRelNode(sqlNode, config);
    }

    private static SqlNode parseSql(String sqlQuery) throws SqlParseException {
        SqlParser parser = SqlParser.create(sqlQuery);
        return parser.parseQuery();
    }

    private static RelNode convertToRelNode(SqlNode sqlNode, FrameworkConfig config) throws Exception {
        RelBuilder relBuilder = RelBuilder.create(config);
        if (sqlNode instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)sqlNode;
            RelNode fromNode = SqlQueryProcessor.processFromClause(select.getFrom(), relBuilder);
            if (select.getWhere() != null) {
                // empty if block
            }
            if (select.getSelectList() != null) {
                // empty if block
            }
            return fromNode;
        }
        throw new UnsupportedOperationException("\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e SELECT \u0437\u0430\u043f\u0440\u043e\u0441\u044b");
    }

    private static RelNode processFromClause(SqlNode fromNode, RelBuilder relBuilder) throws Exception {
        if (fromNode instanceof SqlIdentifier) {
            String tableName = SqlQueryProcessor.extractTableNameFromIdentifier((SqlIdentifier)fromNode);
            return relBuilder.scan("TEST", tableName).build();
        }
        if (fromNode instanceof SqlJoin) {
            return SqlQueryProcessor.processJoin((SqlJoin)fromNode, relBuilder);
        }
        if (fromNode instanceof SqlCall) {
            throw new UnsupportedOperationException("\u041f\u043e\u0434\u0437\u0430\u043f\u0440\u043e\u0441\u044b \u0432 FROM clause \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f");
        }
        throw new UnsupportedOperationException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f FROM clause: " + fromNode.getClass().getSimpleName());
    }

    private static RelNode processJoin(SqlJoin join, RelBuilder relBuilder) throws Exception {
        RelNode leftNode = SqlQueryProcessor.processFromClause(join.getLeft(), relBuilder);
        RelNode rightNode = SqlQueryProcessor.processFromClause(join.getRight(), relBuilder);
        relBuilder.push(leftNode);
        relBuilder.push(rightNode);
        RexNode joinCondition = SqlQueryProcessor.createSimpleJoinCondition(relBuilder);
        return relBuilder.join(JoinRelType.INNER, joinCondition).build();
    }

    private static RexNode createSimpleJoinCondition(RelBuilder relBuilder) {
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        return rexBuilder.makeLiteral(true);
    }

    private static String extractTableNameFromIdentifier(SqlIdentifier identifier) {
        String tableName = identifier.getSimple();
        if (tableName == null) {
            tableName = identifier.toString().toLowerCase();
            tableName = tableName.replaceAll("[^a-zA-Z0-9_]", "");
        }
        return tableName.toLowerCase();
    }

    private static String extractTableName(SqlSelect select) {
        if (select.getFrom() != null) {
            String fromStr = select.getFrom().toString().toLowerCase();
            if (fromStr.contains("employees")) {
                return "employees";
            }
            if (fromStr.contains("departments")) {
                return "departments";
            }
            if (fromStr.contains("projects")) {
                return "projects";
            }
            if (fromStr.contains("users")) {
                return "users";
            }
            if (fromStr.contains("posts")) {
                return "posts";
            }
        }
        return "employees";
    }
}

