/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.SpatialRelation;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Assessment<T, V> {
    private final SpatialRelation outcome;
    private final V estimate;
    private final T filter;
    private final boolean potentialOverSelectivity;

    private Assessment(V estimate, boolean potentialOverSelectivity, SpatialRelation outcome, T filter) {
        this.estimate = estimate;
        this.potentialOverSelectivity = potentialOverSelectivity;
        this.outcome = outcome;
        this.filter = filter;
    }

    public static <T, V> Assessment<T, V> makeDisjoint(V gapEstimate) {
        return new Assessment<Object, V>(gapEstimate, false, SpatialRelation.DISJOINT, null);
    }

    public static <T, V> Assessment<T, V> makeOverlaps(V zero) {
        return new Assessment<Object, V>(zero, false, SpatialRelation.OVERLAPS, null);
    }

    public static <T, V> Assessment<T, V> makeCovered(T coverFilter, boolean overSelectivityPossible, V zero) {
        return new Assessment<T, V>(zero, overSelectivityPossible, SpatialRelation.COVERED, Preconditions.checkNotNull(coverFilter, "filter"));
    }

    public SpatialRelation getOutcome() {
        return this.outcome;
    }

    public V getEstimate() {
        return this.estimate;
    }

    public T getFilter() {
        return this.filter;
    }

    public boolean isPotentialOverSelectivity() {
        return this.potentialOverSelectivity;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Assessment)) {
            return false;
        }
        Assessment other = (Assessment)o;
        return this.outcome == other.outcome && this.potentialOverSelectivity == other.potentialOverSelectivity && Objects.equal(this.estimate, other.estimate) && Objects.equal(this.filter, other.filter);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.outcome, this.potentialOverSelectivity, this.estimate, this.filter});
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

