/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.MathUtils;
import java.math.BigInteger;

public class BigIntegerMath {
    private BigIntegerMath() {
    }

    public static byte[] nonnegativeBigIntegerToBigEndianByteArrayForBitSize(BigInteger s2, int size) {
        byte[] array;
        int start;
        byte[] b = s2.toByteArray();
        Preconditions.checkArgument(b[0] >= 0, "%s is negative", new Object[]{s2});
        int n = MathUtils.bitCountToByteCount(size);
        Preconditions.checkArgument(b.length <= n + 1, "%s has bits that are two high", new Object[]{s2});
        if (b.length == n + 1) {
            Preconditions.checkArgument(size == n << 3, "A BigInteger's big endian length of %s cannot be copied into size=%s.", new Object[]{b.length, size});
            Preconditions.checkArgument(b[0] == 0, "The first byte is a sign bit, and it must be zero.");
            start = 1;
        } else {
            start = 0;
        }
        if (b.length != n) {
            array = new byte[n];
            int len = b.length - start;
            System.arraycopy(b, start, array, n - len, len);
        } else {
            array = b;
        }
        return array;
    }
}

