/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.primitives.Ints;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.BitVectorFactories;
import com.google.uzaygezen.core.MultiDimensionalSpec;
import java.util.Collections;
import java.util.List;

public class HilbertIndexMasks {
    private final BitVector[] masks;
    private final int[] cardinalities;
    private final int n;

    public HilbertIndexMasks(MultiDimensionalSpec spec) {
        List<Integer> bitsPerDimension = spec.getBitsPerDimension();
        this.n = bitsPerDimension.size();
        int mMax = spec.maxBitsPerDimension();
        this.masks = new BitVector[mMax];
        this.cardinalities = new int[mMax];
        for (int i = 0; i < mMax; ++i) {
            int card;
            this.cardinalities[i] = card = HilbertIndexMasks.computeCardinality(bitsPerDimension, i);
            BitVector mask = (BitVector)BitVectorFactories.OPTIMAL.apply(this.n);
            HilbertIndexMasks.extractMask(bitsPerDimension, i, mask);
            this.masks[i] = mask;
        }
    }

    public int getCardinality(int i) {
        return this.cardinalities[i];
    }

    public List<Integer> cardinalities() {
        return Collections.unmodifiableList(Ints.asList(this.cardinalities));
    }

    public void copyMaskTo(int i, int d, BitVector mu) {
        mu.copyFrom(this.masks[i]);
        mu.rotate(d);
    }

    private static int computeCardinality(List<Integer> bitsPerDimension, int i) {
        int cardinality = 0;
        for (int j = 0; j < bitsPerDimension.size(); ++j) {
            if (bitsPerDimension.get(j) <= i) continue;
            ++cardinality;
        }
        return cardinality;
    }

    private static void extractMask(List<Integer> bitsPerDimension, int i, BitVector mu) {
        for (int j = 0; j < bitsPerDimension.size(); ++j) {
            if (bitsPerDimension.get(bitsPerDimension.size() - j - 1) <= i) continue;
            mu.set(j);
        }
    }
}

