/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.util;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.TimeUnitRange;

public class DateTimeUtils {
    public static final int EPOCH_JULIAN = 2440588;
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd";
    public static final String TIME_FORMAT_STRING = "HH:mm:ss";
    public static final String TIMESTAMP_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    @Deprecated
    public static final TimeZone GMT_ZONE;
    public static final TimeZone UTC_ZONE;
    public static final TimeZone DEFAULT_ZONE;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final Calendar ZERO_CALENDAR;
    private static final OffsetDateTimeHandler OFFSET_DATE_TIME_HANDLER;

    private DateTimeUtils() {
    }

    private static Calendar parseDateFormat(String s2, DateFormat dateFormat, TimeZone tz, ParsePosition pp) {
        if (tz == null) {
            tz = DEFAULT_ZONE;
        }
        Calendar ret = Calendar.getInstance(tz, Locale.ROOT);
        dateFormat.setCalendar(ret);
        dateFormat.setLenient(false);
        Date d = dateFormat.parse(s2, pp);
        if (null == d) {
            return null;
        }
        ret.setTime(d);
        ret.setTimeZone(UTC_ZONE);
        return ret;
    }

    @Deprecated
    public static Calendar parseDateFormat(String s2, String pattern, TimeZone tz) {
        return DateTimeUtils.parseDateFormat(s2, new SimpleDateFormat(pattern, Locale.ROOT), tz);
    }

    public static Calendar parseDateFormat(String s2, DateFormat dateFormat, TimeZone tz) {
        ParsePosition pp = new ParsePosition(0);
        Calendar ret = DateTimeUtils.parseDateFormat(s2, dateFormat, tz, pp);
        if (pp.getIndex() != s2.length()) {
            return null;
        }
        return ret;
    }

    @Deprecated
    public static PrecisionTime parsePrecisionDateTimeLiteral(String s2, String pattern, TimeZone tz) {
        assert (pattern != null);
        return DateTimeUtils.parsePrecisionDateTimeLiteral(s2, new SimpleDateFormat(pattern, Locale.ROOT), tz, 3);
    }

    public static PrecisionTime parsePrecisionDateTimeLiteral(String s2, DateFormat dateFormat, TimeZone tz, int maxPrecision) {
        ParsePosition pp = new ParsePosition(0);
        Calendar cal = DateTimeUtils.parseDateFormat(s2, dateFormat, tz, pp);
        if (cal == null) {
            return null;
        }
        int p = 0;
        String secFraction = "";
        if (pp.getIndex() < s2.length()) {
            if (s2.charAt(pp.getIndex()) != '.') {
                return null;
            }
            pp.setIndex(pp.getIndex() + 1);
            if (pp.getIndex() < s2.length()) {
                String millis;
                secFraction = s2.substring(pp.getIndex());
                if (!secFraction.matches("\\d+")) {
                    return null;
                }
                NumberFormat nf = NumberFormat.getIntegerInstance(Locale.ROOT);
                Number num = nf.parse(s2, pp);
                if (num == null || pp.getIndex() != s2.length()) {
                    return null;
                }
                p = secFraction.length();
                if (maxPrecision >= 0) {
                    p = Math.min(maxPrecision, p);
                    secFraction = secFraction.substring(0, p);
                }
                if ((millis = secFraction).length() > 3) {
                    millis = secFraction.substring(0, 3);
                }
                while (millis.length() < 3) {
                    millis = millis + "0";
                }
                int ms = Integer.parseInt(millis);
                cal.add(14, ms);
            }
        }
        assert (pp.getIndex() == s2.length());
        return new PrecisionTime(cal, secFraction, p);
    }

    public static TimeZone getTimeZone(Calendar cal) {
        if (cal == null) {
            return DEFAULT_ZONE;
        }
        return cal.getTimeZone();
    }

    public static void checkDateFormat(String pattern) {
        new SimpleDateFormat(pattern, Locale.ROOT);
    }

    public static SimpleDateFormat newDateFormat(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.ROOT);
        sdf.setLenient(false);
        return sdf;
    }

    public static String unixTimestampToString(long timestamp) {
        return DateTimeUtils.unixTimestampToString(timestamp, 0);
    }

    public static String unixTimestampToString(long timestamp, int precision) {
        StringBuilder buf = new StringBuilder(17);
        int date = (int)(timestamp / 86400000L);
        int time = (int)(timestamp % 86400000L);
        if (time < 0) {
            --date;
            time = (int)((long)time + 86400000L);
        }
        DateTimeUtils.unixDateToString(buf, date);
        buf.append(' ');
        DateTimeUtils.unixTimeToString(buf, time, precision);
        return buf.toString();
    }

    public static String unixTimeToString(int time) {
        return DateTimeUtils.unixTimeToString(time, 0);
    }

    public static String unixTimeToString(int time, int precision) {
        StringBuilder buf = new StringBuilder(8);
        DateTimeUtils.unixTimeToString(buf, time, precision);
        return buf.toString();
    }

    private static void unixTimeToString(StringBuilder buf, int time, int precision) {
        int h2 = time / 3600000;
        int time2 = time % 3600000;
        int m3 = time2 / 60000;
        int time3 = time2 % 60000;
        int s2 = time3 / 1000;
        int ms = time3 % 1000;
        DateTimeUtils.int2(buf, h2);
        buf.append(':');
        DateTimeUtils.int2(buf, m3);
        buf.append(':');
        DateTimeUtils.int2(buf, s2);
        if (precision > 0) {
            buf.append('.');
            while (precision > 0) {
                buf.append((char)(48 + ms / 100));
                ms %= 100;
                ms *= 10;
                --precision;
            }
        }
    }

    private static void int2(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    private static void int4(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 1000 % 10));
        buf.append((char)(48 + i / 100 % 10));
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    public static String unixDateToString(int date) {
        StringBuilder buf = new StringBuilder(10);
        DateTimeUtils.unixDateToString(buf, date);
        return buf.toString();
    }

    private static void unixDateToString(StringBuilder buf, int date) {
        DateTimeUtils.julianToString(buf, date + 2440588);
    }

    private static void julianToString(StringBuilder buf, int julian) {
        int j = julian + 32044;
        int g2 = j / 146097;
        int dg = j % 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc % 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g2 * 400 + c * 100 + b * 4 + a;
        int m3 = (da * 5 + 308) / 153 - 2;
        int d = da - (m3 + 4) * 153 / 5 + 122;
        int year = y - 4800 + (m3 + 2) / 12;
        int month = (m3 + 2) % 12 + 1;
        int day = d + 1;
        DateTimeUtils.int4(buf, year);
        buf.append('-');
        DateTimeUtils.int2(buf, month);
        buf.append('-');
        DateTimeUtils.int2(buf, day);
    }

    public static String intervalYearMonthToString(int v, TimeUnitRange range) {
        StringBuilder buf = new StringBuilder();
        if (v >= 0) {
            buf.append('+');
        } else {
            buf.append('-');
            v = -v;
        }
        switch (range) {
            case YEAR: {
                v = DateTimeUtils.roundUp(v, 12);
                int y = v / 12;
                buf.append(y);
                break;
            }
            case YEAR_TO_MONTH: {
                int y = v / 12;
                buf.append(y);
                buf.append('-');
                int m3 = v % 12;
                DateTimeUtils.number(buf, m3, 2);
                break;
            }
            case MONTH: {
                int m4 = v;
                buf.append(m4);
                break;
            }
            default: {
                throw new AssertionError((Object)range);
            }
        }
        return buf.toString();
    }

    public static StringBuilder number(StringBuilder buf, int v, int n) {
        for (int k = DateTimeUtils.digitCount(v); k < n; ++k) {
            buf.append('0');
        }
        return buf.append(v);
    }

    public static int digitCount(int v) {
        int n = 1;
        while ((v /= 10) != 0) {
            ++n;
        }
        return n;
    }

    private static int roundUp(int dividend, int divisor) {
        int remainder = dividend % divisor;
        dividend -= remainder;
        if (remainder * 2 > divisor) {
            dividend += divisor;
        }
        return dividend;
    }

    public static long powerX(long a, long b) {
        long x = 1L;
        while (b > 0L) {
            x *= a;
            --b;
        }
        return x;
    }

    public static String intervalDayTimeToString(long v, TimeUnitRange range, int scale) {
        StringBuilder buf = new StringBuilder();
        if (v >= 0L) {
            buf.append('+');
        } else {
            buf.append('-');
            v = -v;
        }
        switch (range) {
            case DAY_TO_SECOND: {
                v = DateTimeUtils.roundUp(v, DateTimeUtils.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s2 = (v /= 1000L) % 60L;
                long m3 = (v /= 60L) % 60L;
                long h2 = (v /= 60L) % 24L;
                long d = v /= 24L;
                buf.append((int)d);
                buf.append(' ');
                DateTimeUtils.number(buf, (int)h2, 2);
                buf.append(':');
                DateTimeUtils.number(buf, (int)m3, 2);
                buf.append(':');
                DateTimeUtils.number(buf, (int)s2, 2);
                DateTimeUtils.fraction(buf, scale, ms);
                break;
            }
            case DAY_TO_MINUTE: {
                v = DateTimeUtils.roundUp(v, 60000L);
                v /= 1000L;
                long m4 = (v /= 60L) % 60L;
                long h3 = (v /= 60L) % 24L;
                long d = v /= 24L;
                buf.append((int)d);
                buf.append(' ');
                DateTimeUtils.number(buf, (int)h3, 2);
                buf.append(':');
                DateTimeUtils.number(buf, (int)m4, 2);
                break;
            }
            case DAY_TO_HOUR: {
                v = DateTimeUtils.roundUp(v, 3600000L);
                v /= 1000L;
                v /= 60L;
                long h4 = (v /= 60L) % 24L;
                long d = v /= 24L;
                buf.append((int)d);
                buf.append(' ');
                DateTimeUtils.number(buf, (int)h4, 2);
                break;
            }
            case DAY: {
                v = DateTimeUtils.roundUp(v, 86400000L);
                long d = v / 86400000L;
                buf.append((int)d);
                break;
            }
            case HOUR: {
                v = DateTimeUtils.roundUp(v, 3600000L);
                v /= 1000L;
                v /= 60L;
                long h5 = v /= 60L;
                buf.append((int)h5);
                break;
            }
            case HOUR_TO_MINUTE: {
                v = DateTimeUtils.roundUp(v, 60000L);
                v /= 1000L;
                long m5 = (v /= 60L) % 60L;
                long h6 = v /= 60L;
                buf.append((int)h6);
                buf.append(':');
                DateTimeUtils.number(buf, (int)m5, 2);
                break;
            }
            case HOUR_TO_SECOND: {
                v = DateTimeUtils.roundUp(v, DateTimeUtils.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s3 = (v /= 1000L) % 60L;
                long m6 = (v /= 60L) % 60L;
                long h7 = v /= 60L;
                buf.append((int)h7);
                buf.append(':');
                DateTimeUtils.number(buf, (int)m6, 2);
                buf.append(':');
                DateTimeUtils.number(buf, (int)s3, 2);
                DateTimeUtils.fraction(buf, scale, ms);
                break;
            }
            case MINUTE_TO_SECOND: {
                v = DateTimeUtils.roundUp(v, DateTimeUtils.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s4 = (v /= 1000L) % 60L;
                long m7 = v /= 60L;
                buf.append((int)m7);
                buf.append(':');
                DateTimeUtils.number(buf, (int)s4, 2);
                DateTimeUtils.fraction(buf, scale, ms);
                break;
            }
            case MINUTE: {
                v = DateTimeUtils.roundUp(v, 60000L);
                v /= 1000L;
                long m8 = v /= 60L;
                buf.append((int)m8);
                break;
            }
            case SECOND: {
                v = DateTimeUtils.roundUp(v, DateTimeUtils.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s5 = v /= 1000L;
                buf.append((int)s5);
                DateTimeUtils.fraction(buf, scale, ms);
                break;
            }
            default: {
                throw new AssertionError((Object)range);
            }
        }
        return buf.toString();
    }

    private static long roundUp(long dividend, long divisor) {
        long remainder = dividend % divisor;
        dividend -= remainder;
        if (remainder * 2L > divisor) {
            dividend += divisor;
        }
        return dividend;
    }

    private static void fraction(StringBuilder buf, int scale, long ms) {
        if (scale > 0) {
            buf.append('.');
            long v1 = scale == 3 ? ms : (scale == 2 ? ms / 10L : (scale == 1 ? ms / 100L : 0L));
            DateTimeUtils.number(buf, (int)v1, scale);
        }
    }

    public static int dateStringToUnixDate(String s2) {
        int d;
        int m3;
        int y;
        int hyphen1 = s2.indexOf(45);
        if (hyphen1 < 0) {
            y = Integer.parseInt(s2.trim());
            m3 = 1;
            d = 1;
        } else {
            y = Integer.parseInt(s2.substring(0, hyphen1).trim());
            int hyphen2 = s2.indexOf(45, hyphen1 + 1);
            if (hyphen2 < 0) {
                m3 = Integer.parseInt(s2.substring(hyphen1 + 1).trim());
                d = 1;
            } else {
                m3 = Integer.parseInt(s2.substring(hyphen1 + 1, hyphen2).trim());
                d = Integer.parseInt(s2.substring(hyphen2 + 1).trim());
            }
        }
        return DateTimeUtils.ymdToUnixDate(y, m3, d);
    }

    public static int timeStringToUnixDate(String v) {
        return DateTimeUtils.timeStringToUnixDate(v, 0);
    }

    public static int timeStringToUnixDate(String v, int start) {
        int milli;
        int second;
        int minute;
        int hour;
        int colon1 = v.indexOf(58, start);
        if (colon1 < 0) {
            hour = Integer.parseInt(v.trim());
            minute = 1;
            second = 1;
            milli = 0;
        } else {
            hour = Integer.parseInt(v.substring(start, colon1).trim());
            int colon2 = v.indexOf(58, colon1 + 1);
            if (colon2 < 0) {
                minute = Integer.parseInt(v.substring(colon1 + 1).trim());
                second = 1;
                milli = 0;
            } else {
                minute = Integer.parseInt(v.substring(colon1 + 1, colon2).trim());
                int dot = v.indexOf(46, colon2);
                if (dot < 0) {
                    second = Integer.parseInt(v.substring(colon2 + 1).trim());
                    milli = 0;
                } else {
                    second = Integer.parseInt(v.substring(colon2 + 1, dot).trim());
                    milli = DateTimeUtils.parseFraction(v.substring(dot + 1).trim(), 100);
                }
            }
        }
        return hour * 3600000 + minute * 60000 + second * 1000 + milli;
    }

    private static int parseFraction(String v, int multiplier) {
        int r = 0;
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            int x = c < '0' || c > '9' ? 0 : c - 48;
            r += multiplier * x;
            if (multiplier < 10) {
                if (i + 1 >= v.length() || v.charAt(i + 1) < '5') break;
                ++r;
                break;
            }
            multiplier /= 10;
        }
        return r;
    }

    public static long timestampStringToUnixDate(String s2) {
        long t;
        long d;
        int space = (s2 = s2.trim()).indexOf(32);
        if (space >= 0) {
            d = DateTimeUtils.dateStringToUnixDate(s2.substring(0, space));
            t = DateTimeUtils.timeStringToUnixDate(s2, space + 1);
        } else {
            d = DateTimeUtils.dateStringToUnixDate(s2);
            t = 0L;
        }
        return d * 86400000L + t;
    }

    public static long unixDateExtract(TimeUnitRange range, long date) {
        switch (range) {
            case EPOCH: {
                return date * 86400L;
            }
        }
        return DateTimeUtils.julianExtract(range, (int)date + 2440588);
    }

    private static int julianExtract(TimeUnitRange range, int julian) {
        int j = julian + 32044;
        int g2 = j / 146097;
        int dg = j % 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc % 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g2 * 400 + c * 100 + b * 4 + a;
        int m3 = (da * 5 + 308) / 153 - 2;
        int d = da - (m3 + 4) * 153 / 5 + 122;
        int year = y - 4800 + (m3 + 2) / 12;
        int month = (m3 + 2) % 12 + 1;
        int day = d + 1;
        switch (range) {
            case YEAR: {
                return year;
            }
            case ISOYEAR: {
                int weekNumber = DateTimeUtils.getIso8601WeekNumber(julian, year, month, day);
                if (weekNumber == 1 && month == 12) {
                    return year + 1;
                }
                if (month == 1 && weekNumber > 50) {
                    return year - 1;
                }
                return year;
            }
            case QUARTER: {
                return (month + 2) / 3;
            }
            case MONTH: {
                return month;
            }
            case DAY: {
                return day;
            }
            case DOW: {
                return (int)DateTimeUtils.floorMod(julian + 1, 7L) + 1;
            }
            case ISODOW: {
                return (int)DateTimeUtils.floorMod(julian, 7L) + 1;
            }
            case WEEK: {
                return DateTimeUtils.getIso8601WeekNumber(julian, year, month, day);
            }
            case DOY: {
                long janFirst = DateTimeUtils.ymdToJulian(year, 1, 1);
                return (int)((long)julian - janFirst) + 1;
            }
            case DECADE: {
                return year / 10;
            }
            case CENTURY: {
                return year > 0 ? (year + 99) / 100 : (year - 99) / 100;
            }
            case MILLENNIUM: {
                return year > 0 ? (year + 999) / 1000 : (year - 999) / 1000;
            }
        }
        throw new AssertionError((Object)range);
    }

    private static long firstMondayOfFirstWeek(int year) {
        long janFirst = DateTimeUtils.ymdToJulian(year, 1, 1);
        long janFirstDow = DateTimeUtils.floorMod(janFirst + 1L, 7L);
        return janFirst + (11L - janFirstDow) % 7L - 3L;
    }

    private static int getIso8601WeekNumber(int julian, int year, int month, int day) {
        long fmofw = DateTimeUtils.firstMondayOfFirstWeek(year);
        if (month == 12 && day > 28) {
            if (31 - day + 4 > 7 - ((int)DateTimeUtils.floorMod(julian, 7L) + 1) && 31 - day + (int)(DateTimeUtils.floorMod(julian, 7L) + 1L) >= 4) {
                return (int)((long)julian - fmofw) / 7 + 1;
            }
            return 1;
        }
        if (month == 1 && day < 5) {
            if (4 - day <= 7 - ((int)DateTimeUtils.floorMod(julian, 7L) + 1) && day - (int)(DateTimeUtils.floorMod(julian, 7L) + 1L) >= -3) {
                return 1;
            }
            return (int)((long)julian - DateTimeUtils.firstMondayOfFirstWeek(year - 1)) / 7 + 1;
        }
        return (int)((long)julian - fmofw) / 7 + 1;
    }

    public static int unixTimestampExtract(TimeUnitRange range, long timestamp) {
        return DateTimeUtils.unixTimeExtract(range, (int)DateTimeUtils.floorMod(timestamp, 86400000L));
    }

    public static int unixTimeExtract(TimeUnitRange range, int time) {
        assert (time >= 0);
        assert ((long)time < 86400000L);
        switch (range) {
            case HOUR: {
                return time / 3600000;
            }
            case MINUTE: {
                int minutes = time / 60000;
                return minutes % 60;
            }
            case SECOND: {
                int seconds = time / 1000;
                return seconds % 60;
            }
        }
        throw new AssertionError((Object)range);
    }

    public static long resetTime(long timestamp) {
        int date = (int)(timestamp / 86400000L);
        return (long)date * 86400000L;
    }

    public static long resetDate(long timestamp) {
        return DateTimeUtils.floorMod(timestamp, 86400000L);
    }

    public static long unixTimestampFloor(TimeUnitRange range, long timestamp) {
        int date = (int)(timestamp / 86400000L);
        int f = DateTimeUtils.julianDateFloor(range, date + 2440588, true);
        return (long)f * 86400000L;
    }

    public static long unixDateFloor(TimeUnitRange range, long date) {
        return DateTimeUtils.julianDateFloor(range, (int)date + 2440588, true);
    }

    public static long unixTimestampCeil(TimeUnitRange range, long timestamp) {
        int date = (int)(timestamp / 86400000L);
        int f = DateTimeUtils.julianDateFloor(range, date + 2440588, false);
        return (long)f * 86400000L;
    }

    public static long unixDateCeil(TimeUnitRange range, long date) {
        return DateTimeUtils.julianDateFloor(range, (int)date + 2440588, false);
    }

    private static int julianDateFloor(TimeUnitRange range, int julian, boolean floor) {
        int j = julian + 32044;
        int g2 = j / 146097;
        int dg = j % 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc % 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g2 * 400 + c * 100 + b * 4 + a;
        int m3 = (da * 5 + 308) / 153 - 2;
        int d = da - (m3 + 4) * 153 / 5 + 122;
        int year = y - 4800 + (m3 + 2) / 12;
        int month = (m3 + 2) % 12 + 1;
        int day = d + 1;
        switch (range) {
            case YEAR: {
                if (!(floor || month <= 1 && day <= 1)) {
                    ++year;
                }
                return DateTimeUtils.ymdToUnixDate(year, 1, 1);
            }
            case QUARTER: {
                int q = (month - 1) / 3;
                if (!floor) {
                    if (month - 1 > q * 3 || day > 1) {
                        if (q == 3) {
                            ++year;
                            month = 1;
                        } else {
                            month = q * 3 + 4;
                        }
                    }
                } else {
                    month = q * 3 + 1;
                }
                return DateTimeUtils.ymdToUnixDate(year, month, 1);
            }
            case MONTH: {
                if (!floor && day > 1) {
                    ++month;
                }
                return DateTimeUtils.ymdToUnixDate(year, month, 1);
            }
            case WEEK: {
                int dow;
                int offset = dow = (int)DateTimeUtils.floorMod(julian + 1, 7L);
                if (!floor && offset > 0) {
                    offset -= 7;
                }
                return DateTimeUtils.ymdToUnixDate(year, month, day) - offset;
            }
            case DAY: {
                return DateTimeUtils.ymdToUnixDate(year, month, day);
            }
        }
        throw new AssertionError((Object)range);
    }

    public static int ymdToUnixDate(int year, int month, int day) {
        int julian = DateTimeUtils.ymdToJulian(year, month, day);
        return julian - 2440588;
    }

    public static int ymdToJulian(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m3 = month + 12 * a - 3;
        return day + (153 * m3 + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
    }

    public static long unixTimestamp(int year, int month, int day, int hour, int minute, int second) {
        int date = DateTimeUtils.ymdToUnixDate(year, month, day);
        return (long)date * 86400000L + (long)hour * 3600000L + (long)minute * 60000L + (long)second * 1000L;
    }

    public static long addMonths(long timestamp, int m3) {
        long millis = DateTimeUtils.floorMod(timestamp, 86400000L);
        long x = DateTimeUtils.addMonths((int)((timestamp -= millis) / 86400000L), m3);
        return x * 86400000L + millis;
    }

    public static int addMonths(int date, int m3) {
        int y;
        int last;
        int y0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.YEAR, date);
        int m0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.MONTH, date);
        int d0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.DAY, date);
        if (d0 > (last = DateTimeUtils.lastDay(y0 += (y = m3 / 12), m0 += m3 - y * 12))) {
            d0 = 1;
            if (++m0 > 12) {
                m0 = 1;
                ++y0;
            }
        }
        return DateTimeUtils.ymdToUnixDate(y0, m0, d0);
    }

    private static int lastDay(int y, int m3) {
        switch (m3) {
            case 2: {
                return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static int subtractMonths(int date0, int date1) {
        if (date0 < date1) {
            return -DateTimeUtils.subtractMonths(date1, date0);
        }
        int m3 = (date0 - date1) / 31;
        int date2;
        while ((date2 = DateTimeUtils.addMonths(date1, m3)) < date0) {
            int date3 = DateTimeUtils.addMonths(date1, m3 + 1);
            if (date3 > date0) {
                return m3;
            }
            ++m3;
        }
        return m3;
    }

    public static int subtractMonths(long t0, long t1) {
        int x;
        long millis0 = DateTimeUtils.floorMod(t0, 86400000L);
        int d0 = (int)DateTimeUtils.floorDiv(t0 - millis0, 86400000L);
        long millis1 = DateTimeUtils.floorMod(t1, 86400000L);
        int d1 = (int)DateTimeUtils.floorDiv(t1 - millis1, 86400000L);
        long d2 = DateTimeUtils.addMonths(d1, x = DateTimeUtils.subtractMonths(d0, d1));
        if (d2 == (long)d0 && millis0 < millis1) {
            --x;
        }
        return x;
    }

    public static long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }

    public static long floorMod(long x, long y) {
        return x - DateTimeUtils.floorDiv(x, y) * y;
    }

    public static Calendar calendar() {
        return Calendar.getInstance(UTC_ZONE, Locale.ROOT);
    }

    public static boolean isOffsetDateTime(Object o) {
        return OFFSET_DATE_TIME_HANDLER.isOffsetDateTime(o);
    }

    public static String offsetDateTimeValue(Object o) {
        return OFFSET_DATE_TIME_HANDLER.stringValue(o);
    }

    static {
        OffsetDateTimeHandler h2;
        GMT_ZONE = TimeZone.getTimeZone("GMT");
        UTC_ZONE = TimeZone.getTimeZone("UTC");
        DEFAULT_ZONE = TimeZone.getDefault();
        ZERO_CALENDAR = Calendar.getInstance(UTC_ZONE, Locale.ROOT);
        ZERO_CALENDAR.setTimeInMillis(0L);
        try {
            h2 = new ReflectiveOffsetDateTimeHandler();
        }
        catch (ClassNotFoundException e) {
            h2 = new NoopOffsetDateTimeHandler();
        }
        OFFSET_DATE_TIME_HANDLER = h2;
    }

    private static class ReflectiveOffsetDateTimeHandler
    implements OffsetDateTimeHandler {
        final Class offsetDateTimeClass = Class.forName("java.time.OffsetDateTime");

        private ReflectiveOffsetDateTimeHandler() throws ClassNotFoundException {
        }

        @Override
        public boolean isOffsetDateTime(Object o) {
            return o != null && o.getClass() == this.offsetDateTimeClass;
        }

        @Override
        public String stringValue(Object o) {
            return o.toString();
        }
    }

    private static class NoopOffsetDateTimeHandler
    implements OffsetDateTimeHandler {
        private NoopOffsetDateTimeHandler() {
        }

        @Override
        public boolean isOffsetDateTime(Object o) {
            return false;
        }

        @Override
        public String stringValue(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private static interface OffsetDateTimeHandler {
        public boolean isOffsetDateTime(Object var1);

        public String stringValue(Object var1);
    }

    public static class PrecisionTime {
        private final Calendar cal;
        private final String fraction;
        private final int precision;

        public PrecisionTime(Calendar cal, String fraction, int precision) {
            this.cal = cal;
            this.fraction = fraction;
            this.precision = precision;
        }

        public Calendar getCalendar() {
            return this.cal;
        }

        public int getPrecision() {
            return this.precision;
        }

        public String getFraction() {
            return this.fraction;
        }
    }
}

