/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;

public abstract class PruneEmptyRules {
    public static final RelOptRule UNION_INSTANCE = UnionEmptyPruneRuleConfig.EMPTY.withOperandSupplier(b0 -> b0.operand(LogicalUnion.class).unorderedInputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("Union").as(UnionEmptyPruneRuleConfig.class).toRule();
    public static final RelOptRule MINUS_INSTANCE = MinusEmptyPruneRuleConfig.EMPTY.withOperandSupplier(b0 -> b0.operand(LogicalMinus.class).unorderedInputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("Minus").as(MinusEmptyPruneRuleConfig.class).toRule();
    public static final RelOptRule INTERSECT_INSTANCE = IntersectEmptyPruneRuleConfig.EMPTY.withOperandSupplier(b0 -> b0.operand(LogicalIntersect.class).unorderedInputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("Intersect").as(IntersectEmptyPruneRuleConfig.class).toRule();
    public static final RelOptRule PROJECT_INSTANCE = RemoveEmptySingleRule.Config.EMPTY.withDescription("PruneEmptyProject").as(RemoveEmptySingleRule.Config.class).withOperandFor(Project.class, project -> true).toRule();
    public static final RelOptRule FILTER_INSTANCE = RemoveEmptySingleRule.Config.EMPTY.withDescription("PruneEmptyFilter").as(RemoveEmptySingleRule.Config.class).withOperandFor(Filter.class, singleRel -> true).toRule();
    public static final RelOptRule SORT_INSTANCE = RemoveEmptySingleRule.Config.EMPTY.withDescription("PruneEmptySort").as(RemoveEmptySingleRule.Config.class).withOperandFor(Sort.class, singleRel -> true).toRule();
    public static final RelOptRule SORT_FETCH_ZERO_INSTANCE = SortFetchZeroRuleConfig.EMPTY.withOperandSupplier(b -> b.operand(Sort.class).anyInputs()).withDescription("PruneSortLimit0").as(SortFetchZeroRuleConfig.class).toRule();
    public static final RelOptRule AGGREGATE_INSTANCE = RemoveEmptySingleRule.Config.EMPTY.withDescription("PruneEmptyAggregate").as(RemoveEmptySingleRule.Config.class).withOperandFor(Aggregate.class, Aggregate::isNotGrandTotal).toRule();
    public static final RelOptRule JOIN_LEFT_INSTANCE = JoinLeftEmptyRuleConfig.EMPTY.withOperandSupplier(b0 -> b0.operand(Join.class).inputs(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs(), b2 -> b2.operand(RelNode.class).anyInputs())).withDescription("PruneEmptyJoin(left)").as(JoinLeftEmptyRuleConfig.class).toRule();
    public static final RelOptRule JOIN_RIGHT_INSTANCE = JoinRightEmptyRuleConfig.EMPTY.withOperandSupplier(b0 -> b0.operand(Join.class).inputs(b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(Values.class).predicate(Values::isEmpty).noInputs())).withDescription("PruneEmptyJoin(right)").as(JoinRightEmptyRuleConfig.class).toRule();

    private static boolean isEmpty(RelNode node) {
        if (node instanceof Values) {
            return ((Values)node).getTuples().isEmpty();
        }
        if (node instanceof HepRelVertex) {
            return PruneEmptyRules.isEmpty(((HepRelVertex)node).getCurrentRel());
        }
        if (!(node instanceof RelSubset)) {
            return false;
        }
        RelSubset subset = (RelSubset)node;
        for (RelNode rel : subset.getRels()) {
            if (!PruneEmptyRules.isEmpty(rel)) continue;
            return true;
        }
        return false;
    }

    public static interface JoinRightEmptyRuleConfig
    extends PruneEmptyRule.Config {
        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Join join = (Join)call.rel(0);
                    if (join.getJoinType().generatesNullsOnRight()) {
                        return;
                    }
                    if (join.getJoinType() == JoinRelType.ANTI) {
                        call.transformTo(join.getLeft());
                        return;
                    }
                    call.transformTo(call.builder().push(join).empty().build());
                }
            };
        }
    }

    public static interface JoinLeftEmptyRuleConfig
    extends PruneEmptyRule.Config {
        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Join join = (Join)call.rel(0);
                    if (join.getJoinType().generatesNullsOnLeft()) {
                        return;
                    }
                    call.transformTo(call.builder().push(join).empty().build());
                }
            };
        }
    }

    public static interface SortFetchZeroRuleConfig
    extends PruneEmptyRule.Config {
        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    Sort sort = (Sort)call.rel(0);
                    if (sort.fetch != null && !(sort.fetch instanceof RexDynamicParam) && RexLiteral.intValue(sort.fetch) == 0) {
                        RelNode emptyValues = call.builder().push(sort).empty().build();
                        RelTraitSet traits = sort.getTraitSet();
                        if (emptyValues.getConvention() != null) {
                            traits = traits.replace(emptyValues.getConvention());
                        }
                        emptyValues = emptyValues.copy(traits, Collections.emptyList());
                        call.transformTo(emptyValues);
                    }
                }
            };
        }
    }

    public static interface IntersectEmptyPruneRuleConfig
    extends PruneEmptyRule.Config {
        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    LogicalIntersect intersect = (LogicalIntersect)call.rel(0);
                    RelBuilder builder = call.builder();
                    builder.push(intersect).empty();
                    call.transformTo(builder.build());
                }
            };
        }
    }

    public static interface MinusEmptyPruneRuleConfig
    extends PruneEmptyRule.Config {
        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    LogicalMinus minus = (LogicalMinus)call.rel(0);
                    List<RelNode> inputs = minus.getInputs();
                    assert (inputs != null);
                    int nonEmptyInputs = 0;
                    RelBuilder builder = call.builder();
                    for (RelNode input : inputs) {
                        if (!PruneEmptyRules.isEmpty(input)) {
                            builder.push(input);
                            ++nonEmptyInputs;
                            continue;
                        }
                        if (nonEmptyInputs != 0) continue;
                        break;
                    }
                    assert (nonEmptyInputs < inputs.size()) : "planner promised us at least one Empty child: " + RelOptUtil.toString(minus);
                    if (nonEmptyInputs == 0) {
                        builder.push(minus).empty();
                    } else {
                        builder.minus(minus.all, nonEmptyInputs);
                        builder.convert(minus.getRowType(), true);
                    }
                    call.transformTo(builder.build());
                }
            };
        }
    }

    public static interface UnionEmptyPruneRuleConfig
    extends PruneEmptyRule.Config {
        @Override
        default public PruneEmptyRule toRule() {
            return new PruneEmptyRule(this){

                @Override
                public void onMatch(RelOptRuleCall call) {
                    LogicalUnion union = (LogicalUnion)call.rel(0);
                    List<RelNode> inputs = union.getInputs();
                    assert (inputs != null);
                    RelBuilder builder = call.builder();
                    int nonEmptyInputs = 0;
                    for (RelNode input : inputs) {
                        if (PruneEmptyRules.isEmpty(input)) continue;
                        builder.push(input);
                        ++nonEmptyInputs;
                    }
                    assert (nonEmptyInputs < inputs.size()) : "planner promised us at least one Empty child: " + RelOptUtil.toString(union);
                    if (nonEmptyInputs == 0) {
                        builder.push(union).empty();
                    } else {
                        builder.union(union.all, nonEmptyInputs);
                        builder.convert(union.getRowType(), true);
                    }
                    call.transformTo(builder.build());
                }
            };
        }
    }

    public static class RemoveEmptySingleRule
    extends PruneEmptyRule {
        RemoveEmptySingleRule(Config config) {
            super(config);
        }

        @Deprecated
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, String description) {
            this(Config.EMPTY.withDescription(description).as(Config.class).withOperandFor(clazz, singleRel -> true));
        }

        @Deprecated
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, Predicate<R> predicate, RelBuilderFactory relBuilderFactory, String description) {
            this(Config.EMPTY.withRelBuilderFactory(relBuilderFactory).withDescription(description).as(Config.class).withOperandFor(clazz, predicate));
        }

        @Deprecated
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, com.google.common.base.Predicate<R> predicate, RelBuilderFactory relBuilderFactory, String description) {
            this(Config.EMPTY.withRelBuilderFactory(relBuilderFactory).withDescription(description).as(Config.class).withOperandFor(clazz, predicate::apply));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            SingleRel singleRel = (SingleRel)call.rel(0);
            RelNode emptyValues = call.builder().push(singleRel).empty().build();
            RelTraitSet traits = singleRel.getTraitSet();
            if (emptyValues.getConvention() != null) {
                traits = traits.replace(emptyValues.getConvention());
            }
            emptyValues = emptyValues.copy(traits, Collections.emptyList());
            call.transformTo(emptyValues);
        }

        public static interface Config
        extends PruneEmptyRule.Config {
            @Override
            default public RemoveEmptySingleRule toRule() {
                return new RemoveEmptySingleRule(this);
            }

            default public <R extends RelNode> Config withOperandFor(Class<R> relClass, Predicate<R> predicate) {
                return this.withOperandSupplier(b0 -> b0.operand(relClass).predicate(predicate).oneInput(b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs())).as(Config.class);
            }
        }
    }

    protected static abstract class PruneEmptyRule
    extends RelRule<Config>
    implements SubstitutionRule {
        protected PruneEmptyRule(Config config) {
            super(config);
        }

        @Override
        public boolean autoPruneOld() {
            return true;
        }

        public static interface Config
        extends RelRule.Config {
            @Override
            public PruneEmptyRule toRule();
        }
    }
}

