/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.base.Preconditions;
import org.apache.calcite.sql.SqlOperandCountRange;

public abstract class SqlOperandCountRanges {
    public static SqlOperandCountRange of(int length) {
        return new RangeImpl(length, length);
    }

    public static SqlOperandCountRange between(int min2, int max) {
        return new RangeImpl(min2, max);
    }

    public static SqlOperandCountRange from(int min2) {
        return new RangeImpl(min2, -1);
    }

    public static SqlOperandCountRange any() {
        return new RangeImpl(0, -1);
    }

    private static class RangeImpl
    implements SqlOperandCountRange {
        private final int min;
        private final int max;

        RangeImpl(int min2, int max) {
            this.min = min2;
            this.max = max;
            Preconditions.checkArgument(min2 <= max || max == -1);
            Preconditions.checkArgument(min2 >= 0);
        }

        @Override
        public boolean isValidCount(int count) {
            return count >= this.min && (this.max == -1 || count <= this.max);
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public int getMax() {
            return this.max;
        }
    }
}

