/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ChunkList<E>
extends AbstractSequentialList<E> {
    private static final int HEADER_SIZE = 3;
    private static final int CHUNK_SIZE = 64;
    private static final Integer[] INTEGERS = new Integer[67];
    private int size;
    private Object[] first;
    private Object[] last;

    public ChunkList() {
    }

    public ChunkList(Collection<E> collection) {
        this.addAll(collection);
    }

    boolean isValid(boolean fail) {
        if (this.first == null != (this.last == null)) {
            assert (!fail);
            return false;
        }
        if (this.first == null != (this.size == 0)) {
            assert (!fail);
            return false;
        }
        int n = 0;
        for (Object e : this) {
            if (n++ <= this.size) continue;
            assert (!fail);
            return false;
        }
        if (n != this.size) {
            assert (!fail);
            return false;
        }
        Object[] prev = null;
        Object[] chunk = this.first;
        while (chunk != null) {
            if (ChunkList.prev(chunk) != prev) {
                assert (!fail);
                return false;
            }
            prev = chunk;
            if (ChunkList.occupied(chunk) == 0) {
                assert (!fail);
                return false;
            }
            chunk = ChunkList.next(chunk);
        }
        return true;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.locate(index);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.last = null;
        this.first = null;
    }

    @Override
    public boolean add(E element) {
        int occupied;
        Object[] chunk = this.last;
        if (chunk == null) {
            this.last = new Object[67];
            this.first = this.last;
            chunk = this.last;
            occupied = 0;
        } else {
            occupied = ChunkList.occupied(chunk);
            if (occupied == 64) {
                chunk = new Object[67];
                ChunkList.setNext(this.last, chunk);
                ChunkList.setPrev(chunk, this.last);
                occupied = 0;
                this.last = chunk;
            }
        }
        ChunkList.setOccupied(chunk, occupied + 1);
        ChunkList.setElement(chunk, 3 + occupied, element);
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index == this.size) {
            this.add(element);
        } else {
            super.add(index, element);
        }
    }

    private static Object[] prev(Object[] chunk) {
        return (Object[])chunk[0];
    }

    private static void setPrev(Object[] chunk, Object[] prev) {
        chunk[0] = prev;
    }

    private static Object[] next(Object[] chunk) {
        return (Object[])chunk[1];
    }

    private static void setNext(Object[] chunk, Object[] next) {
        assert (chunk != next);
        chunk[1] = next;
    }

    private static int occupied(Object[] chunk) {
        return (Integer)chunk[2];
    }

    private static void setOccupied(Object[] chunk, int size) {
        chunk[2] = INTEGERS[size];
    }

    private static Object element(Object[] chunk, int index) {
        return chunk[index];
    }

    private static void setElement(Object[] chunk, int index, Object element) {
        chunk[index] = element;
    }

    private ChunkListIterator locate(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (this.first == null) {
            return new ChunkListIterator(null, 0, 0, -1, 0);
        }
        int n = 0;
        Object[] chunk = this.first;
        while (true) {
            int occupied = ChunkList.occupied(chunk);
            int nextN = n + occupied;
            Object[] next = ChunkList.next(chunk);
            if (nextN >= index || next == null) {
                return new ChunkListIterator(chunk, n, index, -1, n + occupied);
            }
            n = nextN;
            chunk = next;
        }
    }

    static /* synthetic */ Object[] access$502(ChunkList x0, Object[] x1) {
        x0.last = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$102(ChunkList x0, Object[] x1) {
        x0.first = x1;
        return x1;
    }

    static {
        for (int i = 0; i < INTEGERS.length; ++i) {
            ChunkList.INTEGERS[i] = i;
        }
    }

    private class ChunkListIterator
    implements ListIterator<E> {
        private Object[] chunk;
        private int start;
        private int cursor;
        private int lastRet;
        private int end;

        ChunkListIterator(Object[] chunk, int start, int cursor, int lastRet, int end) {
            this.chunk = chunk;
            this.start = start;
            this.cursor = cursor;
            this.lastRet = lastRet;
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ChunkList.this.size;
        }

        @Override
        public E next() {
            if (this.cursor >= ChunkList.this.size) {
                throw new NoSuchElementException();
            }
            if (this.cursor == this.end) {
                this.chunk = this.chunk == null ? ChunkList.this.first : ChunkList.next(this.chunk);
                this.start = this.end;
                this.end = this.chunk == null ? this.start : this.start + ChunkList.occupied(this.chunk);
            }
            this.lastRet = this.cursor++;
            Object element = ChunkList.element(this.chunk, 3 + this.lastRet - this.start);
            return element;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E previous() {
            this.lastRet = this.cursor--;
            if (this.cursor < this.start) {
                Object[] objectArray = this.chunk = this.chunk == null ? ChunkList.this.last : ChunkList.prev(this.chunk);
                if (this.chunk == null) {
                    throw new NoSuchElementException();
                }
                int o = ChunkList.occupied(this.chunk);
                this.end = this.start;
                this.start -= o;
                assert (this.cursor == this.end - 1);
            }
            return ChunkList.element(this.chunk, this.cursor - this.start);
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            --ChunkList.this.size;
            --this.cursor;
            if (this.end == this.start + 1) {
                Object[] prev = ChunkList.prev(this.chunk);
                Object[] next = ChunkList.next(this.chunk);
                if (next == null) {
                    ChunkList.access$502(ChunkList.this, prev);
                    if (prev == null) {
                        ChunkList.access$102(ChunkList.this, null);
                    } else {
                        ChunkList.setNext(prev, null);
                    }
                    this.chunk = null;
                    this.end = 3;
                } else if (prev == null) {
                    this.chunk = ChunkList.access$102(ChunkList.this, next);
                    ChunkList.setPrev(next, null);
                    this.end = ChunkList.occupied(this.chunk);
                } else {
                    ChunkList.setNext(prev, next);
                    ChunkList.setPrev(next, prev);
                    this.chunk = prev;
                    this.end = this.start;
                    this.start -= ChunkList.occupied(this.chunk);
                }
                this.lastRet = -1;
                return;
            }
            int r = this.lastRet;
            this.lastRet = -1;
            if (r < this.start) {
                int o;
                Object[] c = this.chunk;
                if (c == null) {
                    c = ChunkList.this.last;
                }
                if ((o = ChunkList.occupied(c)) == 1) {
                    Object[] prev = ChunkList.prev(c);
                    if (prev == null) {
                        if (this.chunk == null) {
                            ChunkList.access$102(ChunkList.this, ChunkList.access$502(ChunkList.this, null));
                        } else {
                            ChunkList.access$102(ChunkList.this, this.chunk);
                            ChunkList.setPrev(this.chunk, null);
                        }
                    } else {
                        ChunkList.setNext(prev, this.chunk);
                        ChunkList.setPrev(this.chunk, prev);
                    }
                } else {
                    ChunkList.setElement(c, 3 + --o, null);
                    ChunkList.setOccupied(c, o);
                }
            } else {
                System.arraycopy(this.chunk, 3 + r - this.start + 1, this.chunk, 3 + r - this.start, this.end - r - 1);
                --this.end;
                int o = this.end - this.start;
                ChunkList.setElement(this.chunk, 3 + o, null);
                ChunkList.setOccupied(this.chunk, o);
            }
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object[] c = this.chunk;
            int p = this.lastRet;
            int s2 = this.start;
            if (p < this.start) {
                c = ChunkList.prev(c);
                s2 -= ChunkList.occupied(c);
            }
            ChunkList.setElement(c, 3 + p - s2, e);
        }

        @Override
        public void add(E e) {
            if (this.chunk == null) {
                Object[] newChunk = new Object[67];
                if (ChunkList.this.first != null) {
                    ChunkList.setNext(newChunk, ChunkList.this.first);
                    ChunkList.setPrev(ChunkList.this.first, newChunk);
                }
                ChunkList.access$102(ChunkList.this, newChunk);
                if (ChunkList.this.last == null) {
                    ChunkList.access$502(ChunkList.this, newChunk);
                }
                this.chunk = newChunk;
                this.end = this.start;
            } else if (this.end == this.start + 64) {
                Object[] newChunk = new Object[67];
                Object[] next = ChunkList.next(this.chunk);
                ChunkList.setPrev(newChunk, this.chunk);
                ChunkList.setNext(this.chunk, newChunk);
                if (next == null) {
                    ChunkList.access$502(ChunkList.this, newChunk);
                } else {
                    ChunkList.setPrev(next, newChunk);
                    ChunkList.setNext(newChunk, next);
                }
                ChunkList.setOccupied(this.chunk, 32);
                ChunkList.setOccupied(newChunk, 32);
                System.arraycopy(this.chunk, 35, newChunk, 3, 32);
                Arrays.fill(this.chunk, 35, 67, null);
                if (this.cursor - this.start < 32) {
                    this.end -= 32;
                } else {
                    this.start += 32;
                    this.chunk = newChunk;
                }
            }
            System.arraycopy(this.chunk, 3 + this.cursor - this.start, this.chunk, 3 + this.cursor - this.start + 1, this.end - this.cursor);
            ++this.end;
            ChunkList.setElement(this.chunk, 3 + this.cursor - this.start, e);
            ChunkList.setOccupied(this.chunk, this.end - this.start);
            ++ChunkList.this.size;
        }
    }
}

