/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.util.Compatible;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.ImmutableNullableMap;
import org.apache.calcite.util.ImmutableNullableSet;
import org.apache.calcite.util.ReflectUtil;

public class ImmutableBeans {
    private static final LoadingCache<Class, Def> CACHE = CacheBuilder.newBuilder().weakKeys().softValues().build(new CacheLoader<Class, Def>(){

        @Override
        public Def load(@Nonnull Class key) {
            return ImmutableBeans.makeDef(key);
        }
    });

    private ImmutableBeans() {
    }

    public static <T> T create(Class<T> beanClass) {
        return ImmutableBeans.create_(beanClass, ImmutableMap.of());
    }

    public static <T> T copy(Class<T> beanClass, @Nonnull Object o) {
        BeanImpl bean = (BeanImpl)Proxy.getInvocationHandler(o);
        return ImmutableBeans.create_(beanClass, bean.map);
    }

    private static <T> T create_(Class<T> beanClass, ImmutableMap<String, Object> valueMap) {
        if (!beanClass.isInterface()) {
            throw new IllegalArgumentException("must be interface");
        }
        try {
            Def def = CACHE.get(beanClass);
            return (T)def.makeBean(valueMap);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static <T> Def<T> makeDef(Class<T> beanClass) {
        boolean copy;
        boolean required;
        Class propertyType;
        Mode mode;
        String methodName;
        ImmutableSortedMap.Builder propertyNameBuilder = ImmutableSortedMap.naturalOrder();
        ImmutableMap.Builder handlers = ImmutableMap.builder();
        HashSet<String> requiredPropertyNames = new HashSet<String>();
        HashSet<String> copyPropertyNames = new HashSet<String>();
        for (Method method : beanClass.getMethods()) {
            String propertyName;
            Property property;
            if (!Modifier.isPublic(method.getModifiers()) || (property = method.getAnnotation(Property.class)) == null) continue;
            boolean hasNonnull = ImmutableBeans.hasAnnotation(method, "javax.annotation.Nonnull");
            Object defaultValue = ImmutableBeans.getDefault(method);
            methodName = method.getName();
            if (methodName.startsWith("get")) {
                propertyName = methodName.substring("get".length());
                mode = Mode.GET;
            } else if (methodName.startsWith("is")) {
                propertyName = methodName.substring("is".length());
                mode = Mode.GET;
            } else {
                if (methodName.startsWith("with")) continue;
                propertyName = methodName.substring(0, 1).toUpperCase(Locale.ROOT) + methodName.substring(1);
                mode = Mode.GET;
            }
            propertyType = method.getReturnType();
            if (method.getParameterCount() > 0) {
                throw new IllegalArgumentException("method '" + methodName + "' has too many parameters");
            }
            boolean bl = required = property.required() || propertyType.isPrimitive() || hasNonnull;
            if (required) {
                requiredPropertyNames.add(propertyName);
            }
            boolean bl2 = copy = property.makeImmutable() && (ReflectUtil.mightBeAssignableFrom(propertyType, Collection.class) || ReflectUtil.mightBeAssignableFrom(propertyType, Map.class));
            if (copy) {
                copyPropertyNames.add(propertyName);
            }
            propertyNameBuilder.put(propertyName, propertyType);
            Object defaultValue2 = ImmutableBeans.convertDefault(defaultValue, propertyName, propertyType);
            handlers.put(method, (bean, args) -> {
                switch (mode) {
                    case GET: {
                        Object v = bean.map.get(propertyName);
                        if (v != null) {
                            return v;
                        }
                        if (required && defaultValue == null) {
                            throw new IllegalArgumentException("property '" + propertyName + "' is required and has no default value");
                        }
                        return defaultValue2;
                    }
                }
                throw new AssertionError();
            });
        }
        ImmutableMap propertyNames = propertyNameBuilder.build();
        for (Method method : beanClass.getMethods()) {
            String propertyName;
            if (!Modifier.isPublic(method.getModifiers()) || method.isDefault()) continue;
            Property property = method.getAnnotation(Property.class);
            methodName = method.getName();
            if (methodName.startsWith("get") || methodName.startsWith("is") || property != null) continue;
            if (methodName.startsWith("with")) {
                propertyName = methodName.substring("with".length());
                mode = Mode.WITH;
            } else {
                if (!methodName.startsWith("set")) continue;
                propertyName = methodName.substring("set".length());
                mode = Mode.SET;
            }
            Class propertyClass = (Class)propertyNames.get(propertyName);
            if (propertyClass == null) {
                throw new IllegalArgumentException("cannot find property '" + propertyName + "' for method '" + methodName + "'; maybe add a method 'get" + propertyName + "'?'");
            }
            switch (mode) {
                case WITH: {
                    if (method.getReturnType() == beanClass || method.getReturnType() == method.getDeclaringClass()) break;
                    throw new IllegalArgumentException("method '" + methodName + "' should return the bean class '" + beanClass + "', actually returns '" + method.getReturnType() + "'");
                }
                case SET: {
                    if (method.getReturnType() == Void.TYPE) break;
                    throw new IllegalArgumentException("method '" + methodName + "' should return void, actually returns '" + method.getReturnType() + "'");
                }
            }
            if (method.getParameterCount() != 1) {
                throw new IllegalArgumentException("method '" + methodName + "' should have one parameter, actually has " + method.getParameterCount());
            }
            propertyType = (Class)propertyNames.get(propertyName);
            if (!method.getParameterTypes()[0].equals(propertyType)) {
                throw new IllegalArgumentException("method '" + methodName + "' should have parameter of type " + propertyType + ", actually has " + method.getParameterTypes()[0]);
            }
            required = requiredPropertyNames.contains(propertyName);
            copy = copyPropertyNames.contains(propertyName);
            handlers.put(method, (bean, args) -> {
                switch (mode) {
                    case WITH: {
                        ImmutableMap.Builder<String, Object> mapBuilder;
                        Object v = bean.map.get(propertyName);
                        if (v != null) {
                            if (v.equals(args[0])) {
                                return bean.asBean();
                            }
                            mapBuilder = ImmutableMap.builder();
                            bean.map.forEach((key, value) -> {
                                if (!key.equals(propertyName)) {
                                    mapBuilder.put((String)key, value);
                                }
                            });
                        } else {
                            mapBuilder = ImmutableMap.builder().putAll(bean.map);
                        }
                        if (args[0] != null) {
                            mapBuilder.put(propertyName, ImmutableBeans.value(copy, args[0]));
                        } else if (required) {
                            throw new IllegalArgumentException("cannot set required property '" + propertyName + "' to null");
                        }
                        ImmutableMap<String, Object> map = mapBuilder.build();
                        return bean.withMap(map).asBean();
                    }
                }
                throw new AssertionError();
            });
        }
        for (Method method : beanClass.getMethods()) {
            MethodHandle methodHandle;
            if (!method.isDefault()) continue;
            try {
                methodHandle = Compatible.INSTANCE.lookupPrivate(beanClass).unreflectSpecial(method, beanClass);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("while binding method " + method, throwable);
            }
            handlers.put(method, (bean, args) -> {
                try {
                    return methodHandle.bindTo(bean.asBean()).invokeWithArguments(args);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("while invoking method " + method, throwable);
                }
            });
        }
        handlers.put(ImmutableBeans.getMethod(Object.class, "toString", new Class[0]), (bean, args) -> new TreeMap(bean.map).toString());
        handlers.put(ImmutableBeans.getMethod(Object.class, "hashCode", new Class[0]), (bean, args) -> new TreeMap(bean.map).hashCode());
        handlers.put(ImmutableBeans.getMethod(Object.class, "equals", Object.class), (bean, args) -> bean == args[0] || beanClass.isInstance(args[0]) && args[0].equals(bean.map) || args[0] instanceof Map && bean.map.equals(args[0]));
        return new Def<T>(beanClass, handlers.build());
    }

    private static Object value(boolean copy, Object o) {
        if (copy) {
            if (o instanceof List) {
                return ImmutableNullableList.copyOf((List)o);
            }
            if (o instanceof Set) {
                return ImmutableNullableSet.copyOf((Set)o);
            }
            if (o instanceof Map) {
                return ImmutableNullableMap.copyOf((Map)o);
            }
        }
        return o;
    }

    private static boolean hasAnnotation(Method method, String className) {
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            if (!annotation.annotationType().getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    private static Object getDefault(Method method) {
        EnumDefault enumDefault;
        StringDefault stringDefault;
        BooleanDefault booleanDefault;
        Object defaultValue = null;
        IntDefault intDefault = method.getAnnotation(IntDefault.class);
        if (intDefault != null) {
            defaultValue = intDefault.value();
        }
        if ((booleanDefault = method.getAnnotation(BooleanDefault.class)) != null) {
            defaultValue = booleanDefault.value();
        }
        if ((stringDefault = method.getAnnotation(StringDefault.class)) != null) {
            defaultValue = stringDefault.value();
        }
        if ((enumDefault = method.getAnnotation(EnumDefault.class)) != null) {
            defaultValue = enumDefault.value();
        }
        return defaultValue;
    }

    private static Object convertDefault(Object defaultValue, String propertyName, Class<?> propertyType) {
        if (propertyType.equals(SqlConformance.class)) {
            propertyType = SqlConformanceEnum.class;
        }
        if (defaultValue == null || !propertyType.isEnum()) {
            return defaultValue;
        }
        for (Object enumConstant : propertyType.getEnumConstants()) {
            if (!((Enum)enumConstant).name().equals(defaultValue)) continue;
            return enumConstant;
        }
        throw new IllegalArgumentException("property '" + propertyName + "' is an enum but its default value " + defaultValue + " is not a valid enum constant");
    }

    private static Method getMethod(Class<Object> aClass, String methodName, Class ... parameterTypes) {
        try {
            return aClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError();
        }
    }

    private static class Def<T> {
        private final Class<T> beanClass;
        private final ImmutableMap<Method, Handler<T>> handlers;

        Def(Class<T> beanClass, ImmutableMap<Method, Handler<T>> handlers) {
            this.beanClass = Objects.requireNonNull(beanClass);
            this.handlers = Objects.requireNonNull(handlers);
        }

        private T makeBean(ImmutableMap<String, Object> map) {
            return new BeanImpl(this, map).asBean();
        }
    }

    private static class BeanImpl<T>
    implements InvocationHandler {
        private final Def<T> def;
        private final ImmutableMap<String, Object> map;

        BeanImpl(Def<T> def, ImmutableMap<String, Object> map) {
            this.def = Objects.requireNonNull(def);
            this.map = Objects.requireNonNull(map);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Handler handler = (Handler)((Def)this.def).handlers.get(method);
            if (handler == null) {
                throw new IllegalArgumentException("no handler for method " + method);
            }
            return handler.apply(this, args);
        }

        BeanImpl<T> withMap(ImmutableMap<String, Object> map) {
            return new BeanImpl<T>(this.def, map);
        }

        T asBean() {
            return ((Def)this.def).beanClass.cast(Proxy.newProxyInstance(((Def)this.def).beanClass.getClassLoader(), new Class[]{((Def)this.def).beanClass}, (InvocationHandler)this));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface NullDefault {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface EnumDefault {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface StringDefault {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface BooleanDefault {
        public boolean value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface IntDefault {
        public int value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Property {
        public boolean required() default false;

        public boolean makeImmutable() default true;
    }

    private static interface Handler<T> {
        public Object apply(BeanImpl<T> var1, Object[] var2);
    }

    private static enum Mode {
        GET,
        SET,
        WITH;

    }
}

