/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.util;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class TextUtils {
    public static final Pattern kuuPohineFormaat = Pattern.compile("\\d\\d\\d\\d-\\d\\d?-\\d\\d?T\\d\\d:\\d\\d");
    public static final Pattern timeMLDocumentCreationTime = Pattern.compile("<[^>]*(([0-9X]{4}-[0-9X]{2}-[0-9X]{2}(T[0-9X]{2}:[0-9X]{2})?)[^>]*functionInDocument=\"CREATION_TIME\")[^>]*>");
    public static final Pattern customRuleFile = Pattern.compile("<rules file=\"([^\"]+)\"\\s*/>", 2);
    private static final Pattern removePunctationFromBeginning = Pattern.compile("^(\\p{Punct}|\u00ab)+");
    private static final Pattern removePunctationFromEnding = Pattern.compile("(\\p{Punct}|\u00bb)+$");
    private static final Pattern endsWithNumbersAndSpecificPunctation = Pattern.compile(".*[0-9]+(\\.|:|/|%|-|'|\\))+$");
    public static final Pattern beginningOfQuote = Pattern.compile("^(\u00ab|\")+");
    public static final Pattern endOfQuote = Pattern.compile("(\u00bb|\")+$");
    public static final Pattern musterMurdArv = Pattern.compile("^[0-9]+\\.[0-9]+$");
    public static final Pattern validTimeMLtid = Pattern.compile("^t[0-9]+$");

    public static String trim(String sone) {
        return TextUtils.ltrim(sone).replaceAll("\\s+$", "");
    }

    public static String ltrim(String source) {
        return source.replaceAll("^\\s+", "");
    }

    public static String trimSurroundingPunctation(String source) {
        if (endsWithNumbersAndSpecificPunctation.matcher(source).matches()) {
            return removePunctationFromBeginning.matcher(source).replaceAll("");
        }
        return removePunctationFromEnding.matcher(removePunctationFromBeginning.matcher(source).replaceAll("")).replaceAll("");
    }

    public static String normalizeSpecialSymbols(String input) {
        input = input.replaceAll("-{2,}", "-");
        input = input.replaceAll("(\u2212|\uff0d|\u02d7|\ufe63|-)", "-");
        input = input.replaceAll("(\u2010|\u2011|\u2012|\u2013|\u2014|\u2015)", "-");
        input = input.replaceAll("&(quot|#34);", "\"");
        input = input.replaceAll("&(apos|#39);", "'");
        input = input.replaceAll("&(amp|#38);", "&");
        input = input.replaceAll("&(lt|#60);", "<");
        input = input.replaceAll("&(gt|#62);", ">");
        return input;
    }

    public static String resizeString(String str, int expectedLength, boolean modifyEnd) {
        if (str.length() == expectedLength) {
            return str;
        }
        if (str.length() > expectedLength) {
            if (modifyEnd) {
                return str.substring(0, expectedLength);
            }
            return str.substring(str.length() - expectedLength, str.length());
        }
        StringBuilder sb = new StringBuilder(str);
        for (int missingLength = expectedLength - str.length(); missingLength > 0; --missingLength) {
            if (modifyEnd) {
                sb.append(" ");
                continue;
            }
            sb.insert(0, " ");
        }
        return sb.toString();
    }

    public static boolean containsLetters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            String subStr = s.substring(i, i + 1);
            if (!subStr.matches("[A-Za-z]")) continue;
            return true;
        }
        return false;
    }

    public static String looMustriTahisteVoti(List<String> mustriTahised, boolean sorteeri) {
        if (sorteeri) {
            Collections.sort(mustriTahised);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mustriTahised.size(); ++i) {
            sb.append(mustriTahised.get(i));
            if (i >= mustriTahised.size() - 1) continue;
            sb.append("+");
        }
        return sb.toString();
    }
}

