# Generated by Django 4.1.6 on 2023-02-20 18:31

import uuid

import django.core.validators
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models

import kmuhelper.external.multi_email_field.fields
import kmuhelper.modules.emails.models
import kmuhelper.modules.main.models

""" Important note!

This migration is a squashed migration. It technically contains all the migrations from 0001 to 0100.

This file has only partially been generated by squashing the migrations with the `manage.py squashmigrations 100` command.
It has been mainly generated by removing all the old migrations and then running `manage.py makemigrations`.

Reason for this "fake squashing" is that squashmigrations did not work properly and still left some
CreateModel, DeleteModel and RenameField operations in the squashed migration.

I am aware that this is not the proper way to squash migrations, but it is the only way I could get it to work.

- Rafael, 2023-02-20
"""


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Attachment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("filename", models.CharField(max_length=50, verbose_name="Dateiname")),
                (
                    "file",
                    models.FileField(
                        upload_to=kmuhelper.modules.emails.models.getfilepath,
                        verbose_name="Datei",
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, default="", verbose_name="Beschreibung"
                    ),
                ),
                (
                    "autocreated",
                    models.BooleanField(
                        default=False, verbose_name="Automatisch generiert"
                    ),
                ),
                (
                    "token",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, verbose_name="Token"
                    ),
                ),
                (
                    "time_created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Erstellt um"),
                ),
            ],
            options={
                "verbose_name": "Anhang",
                "verbose_name_plural": "Anhänge",
                "default_permissions": ("add", "change", "view", "delete", "download"),
            },
        ),
        migrations.CreateModel(
            name="ContactPerson",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Auf Rechnung ersichtlich!",
                        max_length=50,
                        verbose_name="Name",
                    ),
                ),
                (
                    "phone",
                    models.CharField(
                        help_text="Auf Rechnung ersichtlich!",
                        max_length=50,
                        verbose_name="Telefon",
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        help_text="Auf Rechnung ersichtlich!",
                        max_length=254,
                        verbose_name="E-Mail",
                    ),
                ),
            ],
            options={
                "verbose_name": "Ansprechpartner",
                "verbose_name_plural": "Ansprechpartner",
            },
        ),
        migrations.CreateModel(
            name="Customer",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "woocommerceid",
                    models.IntegerField(default=0, verbose_name="WooCommerce ID"),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True, max_length=254, verbose_name="E-Mail Adresse"
                    ),
                ),
                (
                    "first_name",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Vorname"
                    ),
                ),
                (
                    "last_name",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Nachname"
                    ),
                ),
                (
                    "company",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Firma"
                    ),
                ),
                (
                    "username",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=50,
                        verbose_name="Benutzername",
                    ),
                ),
                (
                    "avatar_url",
                    models.URLField(
                        blank=True, editable=False, verbose_name="Avatar URL"
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        choices=[
                            ("de", "Deutsch [DE]"),
                            ("fr", "Französisch [FR]"),
                            ("it", "Italienisch [IT]"),
                            ("en", "Englisch [EN]"),
                        ],
                        default="de",
                        max_length=2,
                        verbose_name="Sprache",
                    ),
                ),
                (
                    "addr_billing_first_name",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Vorname"
                    ),
                ),
                (
                    "addr_billing_last_name",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Nachname"
                    ),
                ),
                (
                    "addr_billing_company",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Firma"
                    ),
                ),
                (
                    "addr_billing_address_1",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text='Strasse und Hausnummer oder "Postfach"',
                        max_length=250,
                        verbose_name="Adresszeile 1",
                    ),
                ),
                (
                    "addr_billing_address_2",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Wird in QR-Rechnung NICHT verwendet!",
                        max_length=250,
                        verbose_name="Adresszeile 2",
                    ),
                ),
                (
                    "addr_billing_city",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Ort"
                    ),
                ),
                (
                    "addr_billing_state",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="Kanton"
                    ),
                ),
                (
                    "addr_billing_postcode",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=50,
                        verbose_name="Postleitzahl",
                    ),
                ),
                (
                    "addr_billing_country",
                    models.CharField(
                        choices=[("CH", "Schweiz"), ("LI", "Liechtenstein")],
                        default="CH",
                        max_length=2,
                        verbose_name="Land",
                    ),
                ),
                (
                    "addr_billing_email",
                    models.EmailField(
                        blank=True, max_length=254, verbose_name="E-Mail-Adresse"
                    ),
                ),
                (
                    "addr_billing_phone",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="Telefon"
                    ),
                ),
                (
                    "addr_shipping_first_name",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Vorname"
                    ),
                ),
                (
                    "addr_shipping_last_name",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Nachname"
                    ),
                ),
                (
                    "addr_shipping_company",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Firma"
                    ),
                ),
                (
                    "addr_shipping_address_1",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=250,
                        verbose_name="Adresszeile 1",
                    ),
                ),
                (
                    "addr_shipping_address_2",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=250,
                        verbose_name="Adresszeile 2",
                    ),
                ),
                (
                    "addr_shipping_city",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Ort"
                    ),
                ),
                (
                    "addr_shipping_state",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="Kanton"
                    ),
                ),
                (
                    "addr_shipping_postcode",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=50,
                        verbose_name="Postleitzahl",
                    ),
                ),
                (
                    "addr_shipping_country",
                    models.CharField(
                        choices=[("CH", "Schweiz"), ("LI", "Liechtenstein")],
                        default="CH",
                        max_length=2,
                        verbose_name="Land",
                    ),
                ),
                (
                    "addr_shipping_email",
                    models.EmailField(
                        blank=True, max_length=254, verbose_name="E-Mail-Adresse"
                    ),
                ),
                (
                    "addr_shipping_phone",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="Telefon"
                    ),
                ),
                (
                    "website",
                    models.URLField(blank=True, default="", verbose_name="Webseite"),
                ),
                (
                    "note",
                    models.TextField(blank=True, default="", verbose_name="Bemerkung"),
                ),
                (
                    "combine_with",
                    models.ForeignKey(
                        blank=True,
                        help_text="Dies kann nicht widerrufen werden! Werte im aktuellen Kunden werden bevorzugt.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="kmuhelper.customer",
                        verbose_name="Zusammenfügen mit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Kunde",
                "verbose_name_plural": "Kunden",
            },
        ),
        migrations.CreateModel(
            name="EMail",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "subject",
                    models.CharField(
                        help_text="Wird Standardmässig auch als Untertitel verwendet.",
                        max_length=50,
                        verbose_name="Betreff",
                    ),
                ),
                (
                    "to",
                    kmuhelper.external.multi_email_field.fields.MultiEmailField(
                        default=[],
                        help_text="Direkte Empfänger",
                        verbose_name="Empfänger",
                    ),
                ),
                (
                    "cc",
                    kmuhelper.external.multi_email_field.fields.MultiEmailField(
                        blank=True, default="", help_text="Kopie", verbose_name="CC"
                    ),
                ),
                (
                    "bcc",
                    kmuhelper.external.multi_email_field.fields.MultiEmailField(
                        blank=True,
                        default="",
                        help_text="Blindkopie",
                        verbose_name="BCC",
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        choices=[
                            ("de", "Deutsch [DE]"),
                            ("fr", "Französisch [FR]"),
                            ("it", "Italienisch [IT]"),
                            ("en", "Englisch [EN]"),
                        ],
                        default="de",
                        max_length=2,
                        verbose_name="Sprache",
                    ),
                ),
                (
                    "html_template",
                    models.CharField(
                        default="default.html",
                        help_text="Dateiname der Designvorlage unter 'kmuhelper/emails/'.",
                        max_length=50,
                        verbose_name="Designvorlage",
                    ),
                ),
                (
                    "text",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Hauptinhalt - wird nicht von allen Designvorlagen verwendet. Links und E-Mail Adressen werden automatisch verlinkt.",
                        verbose_name="Text",
                    ),
                ),
                (
                    "html_context",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Daten im JSON-Format, mit welchen die Designvorlage befüllt wird.",
                        null=True,
                        verbose_name="Daten",
                    ),
                ),
                (
                    "token",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, verbose_name="Token"
                    ),
                ),
                (
                    "time_created",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Datum und Zeit der Erstellung dieser E-Mail.",
                        verbose_name="Erstellt am",
                    ),
                ),
                (
                    "time_sent",
                    models.DateTimeField(
                        blank=True,
                        default=None,
                        help_text="Datum und Zeit des letzten erfolgreichen Sendeversuches.",
                        null=True,
                        verbose_name="Gesendet um",
                    ),
                ),
                ("sent", models.BooleanField(default=False, verbose_name="Gesendet?")),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Diese Notizen haben keine Einwirkung auf die E-Mail selbst.",
                        verbose_name="Notizen",
                    ),
                ),
            ],
            options={
                "verbose_name": "E-Mail",
                "verbose_name_plural": "E-Mails",
                "default_permissions": ("add", "change", "view", "delete", "send"),
            },
        ),
        migrations.CreateModel(
            name="EMailTemplate",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=50, verbose_name="Titel")),
                (
                    "description",
                    models.TextField(
                        blank=True, default="", verbose_name="Beschreibung"
                    ),
                ),
                (
                    "mail_to",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="Empfänger"
                    ),
                ),
                (
                    "mail_subject",
                    models.CharField(max_length=50, verbose_name="Betreff"),
                ),
                ("mail_text", models.TextField(verbose_name="Text")),
                (
                    "mail_template",
                    models.CharField(
                        default="default.html",
                        max_length=50,
                        verbose_name="Designvorlage",
                    ),
                ),
                (
                    "mail_context",
                    models.JSONField(
                        blank=True, default=dict, null=True, verbose_name="Daten"
                    ),
                ),
            ],
            options={
                "verbose_name": "E-Mail-Vorlage",
                "verbose_name_plural": "E-Mail-Vorlagen",
            },
        ),
        migrations.CreateModel(
            name="Fee",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        default="Zusätzliche Kosten",
                        help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'",
                        max_length=500,
                        verbose_name="Bezeichnung",
                    ),
                ),
                (
                    "price",
                    models.FloatField(default=0.0, verbose_name="Preis (exkl. MwSt)"),
                ),
                (
                    "vat_rate",
                    models.FloatField(
                        choices=[
                            (0.0, "0.0% (Mehrwertsteuerfrei)"),
                            (2.5, "2.5% (Bis 2023: Reduzierter Satz)"),
                            (2.6, "2.6% (Ab 2024: Reduzierter Satz)"),
                            (3.7, "3.7% (Bis 2023: Sondersatz für Beherbergung)"),
                            (3.8, "3.8% (Ab 2024: Sondersatz für Beherbergung)"),
                            (7.7, "7.7% (Bis 2023: Normalsatz)"),
                            (8.1, "8.1% (Ab 2024: Normalsatz)"),
                        ],
                        default=7.7,
                        verbose_name="MwSt-Satz",
                    ),
                ),
            ],
            options={
                "verbose_name": "Kosten",
                "verbose_name_plural": "Kosten",
            },
        ),
        migrations.CreateModel(
            name="Order",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "woocommerceid",
                    models.IntegerField(default=0, verbose_name="WooCommerce ID"),
                ),
                (
                    "date",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="Datum"
                    ),
                ),
                (
                    "invoice_date",
                    models.DateField(
                        blank=True,
                        default=None,
                        help_text="Wird auch als Startpunkt für die Zahlungskonditionen verwendet. Wird beim Erstellen eines PDF automatisch mit dem aktuellen Datum befüllt.",
                        null=True,
                        verbose_name="Rechnungsdatum",
                    ),
                ),
                (
                    "payment_conditions",
                    models.CharField(
                        default=kmuhelper.modules.main.models.default_payment_conditions,
                        help_text='Skonto und Zahlungsfrist -> <a target="_blank" href="https://rafaelurben.github.io/django-kmuhelper/manual/faq#wie-funktionieren-zahlungskonditionen">FAQ</a>',
                        max_length=16,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]+(\\.[0-9]+)?:[0-9]+;)*0:[0-9]+$",
                                "Bitte benutze folgendes Format: 'p:d;p:d' - p = Skonto in %; d = Tage",
                            )
                        ],
                        verbose_name="Zahlungskonditionen",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pending", "Zahlung ausstehend"),
                            ("processing", "In Bearbeitung"),
                            ("on-hold", "In Wartestellung"),
                            ("completed", "Abgeschlossen"),
                            ("cancelled", "Storniert/Abgebrochen"),
                            ("refunded", "Rückerstattet"),
                            ("failed", "Fehlgeschlagen"),
                            ("trash", "Gelöscht"),
                        ],
                        default="processing",
                        max_length=11,
                        verbose_name="Status",
                    ),
                ),
                (
                    "is_shipped",
                    models.BooleanField(
                        default=False,
                        help_text='Mehr Infos -> <a target="_blank" href="https://rafaelurben.github.io/django-kmuhelper/manual/faq#was-passiert-wenn-ich-eine-bestellung-als-bezahltversendet-markiere">FAQ</a>',
                        verbose_name="Versendet?",
                    ),
                ),
                (
                    "shipped_on",
                    models.DateField(
                        blank=True, default=None, null=True, verbose_name="Versendet am"
                    ),
                ),
                (
                    "tracking_number",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Bitte gib hier eine Trackingnummer der Schweizer Post ein. (optional)",
                        max_length=25,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^99\\.[0-9]{2}\\.[0-9]{6}\\.[0-9]{8}$",
                                "Bite benutze folgendes Format: 99.xx.xxxxxx.xxxxxxxx",
                            )
                        ],
                        verbose_name="Trackingnummer",
                    ),
                ),
                (
                    "is_removed_from_stock",
                    models.BooleanField(default=False, verbose_name="Ausgelagert?"),
                ),
                (
                    "payment_method",
                    models.CharField(
                        choices=[
                            ("bacs", "Überweisung"),
                            ("cheque", "Scheck"),
                            ("cod", "Rechnung / Nachnahme"),
                            ("paypal", "PayPal"),
                        ],
                        default="cod",
                        max_length=7,
                        verbose_name="Zahlungsmethode",
                    ),
                ),
                (
                    "is_paid",
                    models.BooleanField(
                        default=False,
                        help_text='Mehr Infos -> <a target="_blank" href="https://rafaelurben.github.io/django-kmuhelper/manual/faq#was-passiert-wenn-ich-eine-bestellung-als-bezahltversendet-markiere">FAQ</a>',
                        verbose_name="Bezahlt?",
                    ),
                ),
                (
                    "paid_on",
                    models.DateField(
                        blank=True, default=None, null=True, verbose_name="Bezahlt am"
                    ),
                ),
                (
                    "customer_note",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Vom Kunden erfasste Notiz.",
                        verbose_name="Kundennotiz",
                    ),
                ),
                (
                    "order_key",
                    models.CharField(
                        blank=True,
                        default=kmuhelper.modules.main.models.default_order_key,
                        max_length=50,
                        verbose_name="Bestellungs-Schlüssel",
                    ),
                ),
                (
                    "addr_billing_first_name",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Vorname"
                    ),
                ),
                (
                    "addr_billing_last_name",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Nachname"
                    ),
                ),
                (
                    "addr_billing_company",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Firma"
                    ),
                ),
                (
                    "addr_billing_address_1",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text='Strasse und Hausnummer oder "Postfach"',
                        max_length=250,
                        verbose_name="Adresszeile 1",
                    ),
                ),
                (
                    "addr_billing_address_2",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Wird in QR-Rechnung NICHT verwendet!",
                        max_length=250,
                        verbose_name="Adresszeile 2",
                    ),
                ),
                (
                    "addr_billing_city",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Ort"
                    ),
                ),
                (
                    "addr_billing_state",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="Kanton"
                    ),
                ),
                (
                    "addr_billing_postcode",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=50,
                        verbose_name="Postleitzahl",
                    ),
                ),
                (
                    "addr_billing_country",
                    models.CharField(
                        choices=[("CH", "Schweiz"), ("LI", "Liechtenstein")],
                        default="CH",
                        max_length=2,
                        verbose_name="Land",
                    ),
                ),
                (
                    "addr_billing_email",
                    models.EmailField(
                        blank=True, max_length=254, verbose_name="E-Mail-Adresse"
                    ),
                ),
                (
                    "addr_billing_phone",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="Telefon"
                    ),
                ),
                (
                    "addr_shipping_first_name",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Vorname"
                    ),
                ),
                (
                    "addr_shipping_last_name",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Nachname"
                    ),
                ),
                (
                    "addr_shipping_company",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Firma"
                    ),
                ),
                (
                    "addr_shipping_address_1",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=250,
                        verbose_name="Adresszeile 1",
                    ),
                ),
                (
                    "addr_shipping_address_2",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=250,
                        verbose_name="Adresszeile 2",
                    ),
                ),
                (
                    "addr_shipping_city",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Ort"
                    ),
                ),
                (
                    "addr_shipping_state",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="Kanton"
                    ),
                ),
                (
                    "addr_shipping_postcode",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=50,
                        verbose_name="Postleitzahl",
                    ),
                ),
                (
                    "addr_shipping_country",
                    models.CharField(
                        choices=[("CH", "Schweiz"), ("LI", "Liechtenstein")],
                        default="CH",
                        max_length=2,
                        verbose_name="Land",
                    ),
                ),
                (
                    "addr_shipping_email",
                    models.EmailField(
                        blank=True, max_length=254, verbose_name="E-Mail-Adresse"
                    ),
                ),
                (
                    "addr_shipping_phone",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="Telefon"
                    ),
                ),
                (
                    "cached_sum",
                    models.FloatField(default=0.0, verbose_name="Total in CHF"),
                ),
                (
                    "pdf_title",
                    models.CharField(
                        blank=True, default="", editable=False, max_length=32
                    ),
                ),
                ("pdf_text", models.TextField(blank=True, default="", editable=False)),
                (
                    "contact_person",
                    models.ForeignKey(
                        default=kmuhelper.modules.main.models.default_contact_person,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="kmuhelper.contactperson",
                        verbose_name="Ansprechpartner",
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="orders",
                        to="kmuhelper.customer",
                        verbose_name="Kunde",
                    ),
                ),
                (
                    "email_link_invoice",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="kmuhelper.email",
                    ),
                ),
                (
                    "email_link_shipped",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="kmuhelper.email",
                    ),
                ),
            ],
            options={
                "verbose_name": "Bestellung",
                "verbose_name_plural": "Bestellungen",
            },
        ),
        migrations.CreateModel(
            name="PaymentImport",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "time_imported",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="Importiert am"
                    ),
                ),
                (
                    "is_processed",
                    models.BooleanField(default=False, verbose_name="Verarbeitet?"),
                ),
                (
                    "data_msgid",
                    models.CharField(max_length=50, verbose_name="Nachrichtenid"),
                ),
                ("data_creationdate", models.DateTimeField(verbose_name="Erstellt am")),
            ],
            options={
                "verbose_name": "Zahlungsimport",
                "verbose_name_plural": "Zahlungsimporte",
            },
        ),
        migrations.CreateModel(
            name="PaymentReceiver",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "mode",
                    models.CharField(
                        choices=[("QRR", "QR-Referenz"), ("NON", "Ohne Referenz")],
                        default="QRR",
                        max_length=15,
                        verbose_name="Modus",
                    ),
                ),
                (
                    "qriban",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="QR-IBAN mit Leerzeichen (Nur verwendet im Modus 'QR-Referenz')",
                        max_length=26,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^(CH|LI)[0-9]{2}\\s3[0-9]{3}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{1}$",
                                "Bite benutze folgendes Format: (CH|LI)pp 3xxx xxxx xxxx xxxx x",
                            )
                        ],
                        verbose_name="QR-IBAN",
                    ),
                ),
                (
                    "iban",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="IBAN mit Leerzeichen (Nur verwendet im Modus 'Ohne Referenz')",
                        max_length=26,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^(CH|LI)[0-9]{2}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{4}\\s[0-9]{1}$",
                                "Bite benutze folgendes Format: (CH|LI)pp 3xxx xxxx xxxx xxxx x",
                            )
                        ],
                        verbose_name="IBAN",
                    ),
                ),
                (
                    "logourl",
                    models.URLField(
                        blank=True,
                        default="",
                        help_text="URL eines Bildes (.jpg/.png) - Wird auf die Rechnung gedruckt.",
                        validators=[
                            django.core.validators.RegexValidator(
                                "^[0-9a-zA-Z\\-\\.\\|\\?\\(\\)\\*\\+&\"'_:;/]+\\.(png|jpg)$",
                                "Nur folgende Zeichen gestattet: 0-9a-zA-Z-_.:;/|?&()\"'*+ - Muss auf .jpg/.png enden.",
                            )
                        ],
                        verbose_name="Logo (URL)",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name der Firma oder des Empfängers",
                        max_length=70,
                        verbose_name="Name",
                    ),
                ),
                (
                    "swiss_uid",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="UID der Firma - Format: CHE-123.456.789 (Mehrwertsteuernummer)",
                        max_length=15,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^CHE-[0-9]{3}\\.[0-9]{3}\\.[0-9]{3}$",
                                "Bite benutze folgendes Format: CHE-123.456.789",
                            )
                        ],
                        verbose_name="Firmen-UID",
                    ),
                ),
                (
                    "address_1",
                    models.CharField(
                        max_length=70,
                        verbose_name="Strasse und Hausnummer oder 'Postfach'",
                    ),
                ),
                (
                    "address_2",
                    models.CharField(max_length=70, verbose_name="PLZ und Ort"),
                ),
                (
                    "country",
                    models.CharField(
                        choices=[("CH", "Schweiz"), ("LI", "Liechtenstein")],
                        default="CH",
                        max_length=2,
                        verbose_name="Land",
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True,
                        default="",
                        help_text="Nicht auf der Rechnung ersichtlich",
                        max_length=254,
                        verbose_name="E-Mail",
                    ),
                ),
                (
                    "phone",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Nicht auf der Rechnung ersichtlich",
                        max_length=70,
                        verbose_name="Telefon",
                    ),
                ),
                (
                    "website",
                    models.URLField(
                        blank=True,
                        default="",
                        help_text="Auf der Rechnung ersichtlich, sofern vorhanden!",
                        verbose_name="Webseite",
                    ),
                ),
            ],
            options={
                "verbose_name": "Zahlungsempfänger",
                "verbose_name_plural": "Zahlungsempfänger",
            },
        ),
        migrations.CreateModel(
            name="Product",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "article_number",
                    models.CharField(max_length=25, verbose_name="Artikelnummer"),
                ),
                (
                    "woocommerceid",
                    models.IntegerField(default=0, verbose_name="WooCommerce ID"),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'",
                        max_length=500,
                        verbose_name="Name",
                    ),
                ),
                (
                    "short_description",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'",
                        verbose_name="Kurzbeschrieb",
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'",
                        verbose_name="Beschrieb",
                    ),
                ),
                (
                    "quantity_description",
                    models.CharField(
                        blank=True,
                        default="Stück",
                        help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'",
                        max_length=100,
                        verbose_name="Mengenbezeichnung",
                    ),
                ),
                (
                    "selling_price",
                    models.FloatField(
                        default=0, verbose_name="Normalpreis in CHF (exkl. MwSt)"
                    ),
                ),
                (
                    "vat_rate",
                    models.FloatField(
                        choices=[
                            (0.0, "0.0% (Mehrwertsteuerfrei)"),
                            (2.5, "2.5% (Bis 2023: Reduzierter Satz)"),
                            (2.6, "2.6% (Ab 2024: Reduzierter Satz)"),
                            (3.7, "3.7% (Bis 2023: Sondersatz für Beherbergung)"),
                            (3.8, "3.8% (Ab 2024: Sondersatz für Beherbergung)"),
                            (7.7, "7.7% (Bis 2023: Normalsatz)"),
                            (8.1, "8.1% (Ab 2024: Normalsatz)"),
                        ],
                        default=7.7,
                        verbose_name="MwSt-Satz",
                    ),
                ),
                (
                    "stock_current",
                    models.IntegerField(default=0, verbose_name="Lagerbestand"),
                ),
                (
                    "stock_target",
                    models.IntegerField(default=1, verbose_name="Soll-Lagerbestand"),
                ),
                (
                    "note",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Wird nicht gedruckt oder angezeigt; nur für eigene Zwecke.",
                        verbose_name="Bemerkung",
                    ),
                ),
                (
                    "sale_from",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="In Aktion von"
                    ),
                ),
                (
                    "sale_to",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="In Aktion bis"
                    ),
                ),
                (
                    "sale_price",
                    models.FloatField(
                        blank=True,
                        null=True,
                        verbose_name="Aktionspreis in CHF (exkl. MwSt)",
                    ),
                ),
                (
                    "datasheet_url",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=500,
                        verbose_name="Datenblattlink",
                    ),
                ),
                (
                    "image_url",
                    models.URLField(blank=True, default="", verbose_name="Bildlink"),
                ),
                (
                    "supplier_price",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=20,
                        verbose_name="Einkaufspreis",
                    ),
                ),
                (
                    "supplier_article_number",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=25,
                        verbose_name="Lieferantenartikelnummer",
                    ),
                ),
                (
                    "supplier_url",
                    models.URLField(
                        blank=True,
                        default="",
                        verbose_name="Lieferantenurl (Für Nachbestellungen)",
                    ),
                ),
            ],
            options={
                "verbose_name": "Produkt",
                "verbose_name_plural": "Produkte",
            },
        ),
        migrations.CreateModel(
            name="ProductCategory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "woocommerceid",
                    models.IntegerField(default=0, verbose_name="WooCommerce ID"),
                ),
                (
                    "name",
                    models.CharField(
                        default="", max_length=250, verbose_name="Bezeichnung"
                    ),
                ),
                (
                    "description",
                    models.TextField(blank=True, default="", verbose_name="Beschrieb"),
                ),
                ("image_url", models.URLField(blank=True, verbose_name="Bildlink")),
                (
                    "parent_category",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="kmuhelper.productcategory",
                        verbose_name="Übergeordnete Kategorie",
                    ),
                ),
            ],
            options={
                "verbose_name": "Produktkategorie",
                "verbose_name_plural": "Produktkategorien",
            },
        ),
        migrations.CreateModel(
            name="Setting",
            fields=[
                (
                    "id",
                    models.CharField(
                        max_length=50,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "typ",
                    models.CharField(
                        choices=[
                            ("char", "Text"),
                            ("text", "Mehrzeiliger Text"),
                            ("bool", "Wahrheitswert"),
                            ("int", "Zahl"),
                            ("float", "Fliesskommazahl"),
                            ("url", "Url"),
                            ("email", "E-Mail"),
                            ("json", "JSON Daten"),
                        ],
                        default="char",
                        max_length=5,
                        verbose_name="Typ",
                    ),
                ),
                (
                    "content_char",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=250,
                        verbose_name="Inhalt (Text)",
                    ),
                ),
                (
                    "content_text",
                    models.TextField(
                        blank=True,
                        default="",
                        verbose_name="Inhalt (Mehrzeiliger Text)",
                    ),
                ),
                (
                    "content_bool",
                    models.BooleanField(
                        blank=True, default=False, verbose_name="Inhalt (Wahrheitswert)"
                    ),
                ),
                (
                    "content_int",
                    models.IntegerField(
                        blank=True, default=0, verbose_name="Inhalt (Zahl)"
                    ),
                ),
                (
                    "content_float",
                    models.FloatField(
                        blank=True, default=0.0, verbose_name="Inhalt (Fliesskommazahl)"
                    ),
                ),
                (
                    "content_url",
                    models.URLField(
                        blank=True, default="", verbose_name="Inhalt (Url)"
                    ),
                ),
                (
                    "content_email",
                    models.EmailField(
                        blank=True,
                        default="",
                        max_length=254,
                        verbose_name="Inhalt (E-Mail)",
                    ),
                ),
                (
                    "content_json",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        null=True,
                        verbose_name="Inhalt (JSON)",
                    ),
                ),
            ],
            options={
                "verbose_name": "Einstellung",
                "verbose_name_plural": "Einstellungen",
            },
        ),
        migrations.CreateModel(
            name="SettingHidden",
            fields=[
                (
                    "id",
                    models.CharField(
                        max_length=50,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "typ",
                    models.CharField(
                        choices=[
                            ("char", "Text"),
                            ("text", "Mehrzeiliger Text"),
                            ("bool", "Wahrheitswert"),
                            ("int", "Zahl"),
                            ("float", "Fliesskommazahl"),
                            ("url", "Url"),
                            ("email", "E-Mail"),
                            ("json", "JSON Daten"),
                        ],
                        default="char",
                        max_length=5,
                        verbose_name="Typ",
                    ),
                ),
                (
                    "content_char",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=250,
                        verbose_name="Inhalt (Text)",
                    ),
                ),
                (
                    "content_text",
                    models.TextField(
                        blank=True,
                        default="",
                        verbose_name="Inhalt (Mehrzeiliger Text)",
                    ),
                ),
                (
                    "content_bool",
                    models.BooleanField(
                        blank=True, default=False, verbose_name="Inhalt (Wahrheitswert)"
                    ),
                ),
                (
                    "content_int",
                    models.IntegerField(
                        blank=True, default=0, verbose_name="Inhalt (Zahl)"
                    ),
                ),
                (
                    "content_float",
                    models.FloatField(
                        blank=True, default=0.0, verbose_name="Inhalt (Fliesskommazahl)"
                    ),
                ),
                (
                    "content_url",
                    models.URLField(
                        blank=True, default="", verbose_name="Inhalt (Url)"
                    ),
                ),
                (
                    "content_email",
                    models.EmailField(
                        blank=True,
                        default="",
                        max_length=254,
                        verbose_name="Inhalt (E-Mail)",
                    ),
                ),
                (
                    "content_json",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        null=True,
                        verbose_name="Inhalt (JSON)",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Supplier",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("abbreviation", models.CharField(max_length=5, verbose_name="Kürzel")),
                ("name", models.CharField(max_length=50, verbose_name="Name")),
                ("website", models.URLField(blank=True, verbose_name="Webseite")),
                (
                    "phone",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="Telefon"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True, max_length=254, null=True, verbose_name="E-Mail"
                    ),
                ),
                (
                    "address",
                    models.TextField(blank=True, default="", verbose_name="Adresse"),
                ),
                (
                    "note",
                    models.TextField(blank=True, default="", verbose_name="Notiz"),
                ),
                (
                    "contact_person_name",
                    models.CharField(
                        blank=True, default="", max_length=250, verbose_name="Name"
                    ),
                ),
                (
                    "contact_person_phone",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="Telefon"
                    ),
                ),
                (
                    "contact_person_email",
                    models.EmailField(
                        blank=True,
                        default="",
                        max_length=254,
                        null=True,
                        verbose_name="E-Mail",
                    ),
                ),
            ],
            options={
                "verbose_name": "Lieferant",
                "verbose_name_plural": "Lieferanten",
            },
        ),
        migrations.CreateModel(
            name="Supply",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        default=kmuhelper.modules.main.models.default_delivery_title,
                        max_length=50,
                        verbose_name="Name",
                    ),
                ),
                (
                    "date",
                    models.DateField(auto_now_add=True, verbose_name="Erfasst am"),
                ),
                (
                    "is_added_to_stock",
                    models.BooleanField(default=False, verbose_name="Eingelagert?"),
                ),
            ],
            options={
                "verbose_name": "Lieferung",
                "verbose_name_plural": "Lieferungen",
            },
        ),
        migrations.CreateModel(
            name="SupplyItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("quantity", models.IntegerField(default=1, verbose_name="Menge")),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="kmuhelper.product",
                        verbose_name="Produkt",
                    ),
                ),
                (
                    "supply",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="kmuhelper.supply",
                    ),
                ),
            ],
            options={
                "verbose_name": "Lieferungsposten",
                "verbose_name_plural": "Lieferungsposten",
            },
        ),
        migrations.AddField(
            model_name="supply",
            name="products",
            field=models.ManyToManyField(
                through="kmuhelper.SupplyItem", to="kmuhelper.product"
            ),
        ),
        migrations.AddField(
            model_name="supply",
            name="supplier",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="kmuhelper.supplier",
                verbose_name="Lieferant",
            ),
        ),
        migrations.CreateModel(
            name="ProductProductCategoryConnection",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "category",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="kmuhelper.productcategory",
                        verbose_name="Produktkategorie",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="kmuhelper.product",
                        verbose_name="Produkt",
                    ),
                ),
            ],
            options={
                "verbose_name": "Produkt-Kategorie-Verknüpfung",
                "verbose_name_plural": "Produkt-Kategorie-Verknüpfungen",
            },
        ),
        migrations.AddField(
            model_name="product",
            name="categories",
            field=models.ManyToManyField(
                related_name="products",
                through="kmuhelper.ProductProductCategoryConnection",
                to="kmuhelper.productcategory",
                verbose_name="Kategorien",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="supplier",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="kmuhelper.supplier",
                verbose_name="Lieferant",
            ),
        ),
        migrations.CreateModel(
            name="PaymentImportEntry",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "ref",
                    models.CharField(
                        default="", max_length=50, verbose_name="Referenznummer"
                    ),
                ),
                (
                    "additionalref",
                    models.CharField(
                        default="", max_length=250, verbose_name="Zusätzliche Referenz"
                    ),
                ),
                (
                    "iban",
                    models.CharField(default="", max_length=22, verbose_name="IBAN"),
                ),
                (
                    "name",
                    models.CharField(default="", max_length=250, verbose_name="Name"),
                ),
                ("valuedate", models.DateField(null=True, verbose_name="Valuta")),
                ("amount", models.FloatField(verbose_name="Betrag")),
                ("currency", models.CharField(max_length=10, verbose_name="Währung")),
                (
                    "parent",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="entries",
                        to="kmuhelper.paymentimport",
                    ),
                ),
            ],
            options={
                "verbose_name": "Zahlungsimport-Eintrag",
                "verbose_name_plural": "Zahlungsimport-Einträge",
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="OrderItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Wird auf die Rechnung gedruckt.",
                        max_length=250,
                        verbose_name="Bemerkung",
                    ),
                ),
                ("quantity", models.IntegerField(default=1, verbose_name="Menge")),
                (
                    "discount",
                    models.FloatField(
                        default=0,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="Rabatt in %",
                    ),
                ),
                (
                    "product_price",
                    models.FloatField(
                        default=0.0, verbose_name="Produktpreis (exkl. MwSt)"
                    ),
                ),
                (
                    "order",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="kmuhelper.order",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="kmuhelper.product",
                        verbose_name="Produkt",
                    ),
                ),
            ],
            options={
                "verbose_name": "Bestellungsposten",
                "verbose_name_plural": "Bestellungsposten",
            },
        ),
        migrations.CreateModel(
            name="OrderFee",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Wird auf die Rechnung gedruckt.",
                        max_length=250,
                        verbose_name="Bemerkung",
                    ),
                ),
                (
                    "discount",
                    models.FloatField(
                        default=0.0,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="Rabatt in %",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        default="Zusätzliche Kosten",
                        help_text="Unterstützt i18n: '[:de]Deutsch[:fr]Français[:it]Italiano[:en]English[:]'",
                        max_length=500,
                        verbose_name="Name",
                    ),
                ),
                (
                    "price",
                    models.FloatField(default=0.0, verbose_name="Preis (exkl. MwSt)"),
                ),
                (
                    "vat_rate",
                    models.FloatField(
                        choices=[
                            (0.0, "0.0% (Mehrwertsteuerfrei)"),
                            (2.5, "2.5% (Bis 2023: Reduzierter Satz)"),
                            (2.6, "2.6% (Ab 2024: Reduzierter Satz)"),
                            (3.7, "3.7% (Bis 2023: Sondersatz für Beherbergung)"),
                            (3.8, "3.8% (Ab 2024: Sondersatz für Beherbergung)"),
                            (7.7, "7.7% (Bis 2023: Normalsatz)"),
                            (8.1, "8.1% (Ab 2024: Normalsatz)"),
                        ],
                        default=7.7,
                        verbose_name="MwSt-Satz",
                    ),
                ),
                (
                    "linked_fee",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="kmuhelper.fee",
                        verbose_name="Verknüpfte Kosten",
                    ),
                ),
                (
                    "order",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="kmuhelper.order",
                    ),
                ),
            ],
            options={
                "verbose_name": "Bestellungskosten",
                "verbose_name_plural": "Bestellungskosten",
            },
        ),
        migrations.AddField(
            model_name="order",
            name="fees",
            field=models.ManyToManyField(
                through="kmuhelper.OrderFee", to="kmuhelper.fee"
            ),
        ),
        migrations.AddField(
            model_name="order",
            name="payment_receiver",
            field=models.ForeignKey(
                default=kmuhelper.modules.main.models.default_payment_recipient,
                on_delete=django.db.models.deletion.PROTECT,
                to="kmuhelper.paymentreceiver",
                verbose_name="Zahlungsempfänger",
            ),
        ),
        migrations.AddField(
            model_name="order",
            name="products",
            field=models.ManyToManyField(
                through="kmuhelper.OrderItem", to="kmuhelper.product"
            ),
        ),
        migrations.CreateModel(
            name="Note",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, verbose_name="Name")),
                (
                    "description",
                    models.TextField(blank=True, default="", verbose_name="Beschrieb"),
                ),
                ("done", models.BooleanField(default=False, verbose_name="Erledigt?")),
                (
                    "priority",
                    models.IntegerField(
                        blank=True, default=0, verbose_name="Priorität"
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Erstellt am"),
                ),
                (
                    "linked_customer",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="linked_note",
                        to="kmuhelper.customer",
                    ),
                ),
                (
                    "linked_order",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="linked_note",
                        to="kmuhelper.order",
                    ),
                ),
                (
                    "linked_product",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="linked_note",
                        to="kmuhelper.product",
                    ),
                ),
                (
                    "linked_supply",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="linked_note",
                        to="kmuhelper.supply",
                    ),
                ),
            ],
            options={
                "verbose_name": "Notiz",
                "verbose_name_plural": "Notizen",
            },
        ),
        migrations.CreateModel(
            name="EMailAttachment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "attachment",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="emails",
                        to="kmuhelper.attachment",
                    ),
                ),
                (
                    "email",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="kmuhelper.email",
                    ),
                ),
            ],
            options={
                "verbose_name": "E-Mail-Anhang",
                "verbose_name_plural": "E-Mail-Anhänge",
            },
        ),
        migrations.AddField(
            model_name="email",
            name="attachments",
            field=models.ManyToManyField(
                through="kmuhelper.EMailAttachment", to="kmuhelper.attachment"
            ),
        ),
        migrations.AddField(
            model_name="customer",
            name="email_link_registered",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="kmuhelper.email",
            ),
        ),
        migrations.CreateModel(
            name="ApiKey",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "key",
                    models.UUIDField(
                        default=uuid.uuid4, unique=True, verbose_name="Key"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, default="", max_length=100, verbose_name="Name"
                    ),
                ),
                (
                    "read",
                    models.BooleanField(default=True, verbose_name="Read permission?"),
                ),
                (
                    "write",
                    models.BooleanField(
                        default=False, verbose_name="Write permission?"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Api key",
                "verbose_name_plural": "Api keys",
            },
        ),
        migrations.CreateModel(
            name="App_Arrival",
            fields=[],
            options={
                "verbose_name": "Lieferung",
                "verbose_name_plural": "Lieferungen",
                "proxy": True,
                "default_permissions": ("add", "change", "view"),
                "indexes": [],
                "constraints": [],
            },
            bases=("kmuhelper.supply",),
        ),
        migrations.CreateModel(
            name="App_IncomingPayments",
            fields=[],
            options={
                "verbose_name": "Bestellung",
                "verbose_name_plural": "Bestellungen",
                "proxy": True,
                "default_permissions": ("add", "change", "view"),
                "indexes": [],
                "constraints": [],
            },
            bases=("kmuhelper.order",),
        ),
        migrations.CreateModel(
            name="App_Shipping",
            fields=[],
            options={
                "verbose_name": "Bestellung",
                "verbose_name_plural": "Bestellungen",
                "proxy": True,
                "default_permissions": ("add", "change", "view"),
                "indexes": [],
                "constraints": [],
            },
            bases=("kmuhelper.order",),
        ),
        migrations.CreateModel(
            name="App_Stock",
            fields=[],
            options={
                "verbose_name": "Produkt",
                "verbose_name_plural": "Produkte",
                "proxy": True,
                "default_permissions": ("add", "change", "view"),
                "indexes": [],
                "constraints": [],
            },
            bases=("kmuhelper.product",),
        ),
        migrations.CreateModel(
            name="App_ToDo",
            fields=[],
            options={
                "verbose_name": "Notiz",
                "verbose_name_plural": "Notizen",
                "proxy": True,
                "default_permissions": ("add", "change", "view"),
                "indexes": [],
                "constraints": [],
            },
            bases=("kmuhelper.note",),
        ),
    ]
