# Generated by Django 5.0 on 2023-12-19 13:57

from django.db import migrations, models

# Context of this migration:
# Swiss VAT rates change on 2024/01/01.
# More information: https://www.estv.admin.ch/estv/en/home/value-added-tax/vat-rates-switzerland.html


MIGRATED_VAT_RATES = ((2.5, 2.6), (3.7, 3.8), (7.7, 8.1))


def migrate_vat_rates(apps, schema_editor, reverse=False):
    db_alias = schema_editor.connection.alias
    Fee = apps.get_model("kmuhelper", "Fee")
    Product = apps.get_model("kmuhelper", "Product")

    for before, after in MIGRATED_VAT_RATES:
        if reverse:
            before, after = after, before
        Fee.objects.using(db_alias).filter(vat_rate=before).update(vat_rate=after)
        Product.objects.using(db_alias).filter(vat_rate=before).update(vat_rate=after)


def migrate_vat_rates_forward(apps, schema_editor):
    migrate_vat_rates(apps, schema_editor, reverse=False)


def migrate_vat_rates_reverse(apps, schema_editor):
    migrate_vat_rates(apps, schema_editor, reverse=True)


class Migration(migrations.Migration):
    dependencies = [
        ("kmuhelper", "0107_alter_emailtemplate_mail_subject_and_more"),
    ]

    operations = [
        migrations.RunPython(
            migrate_vat_rates_forward, migrate_vat_rates_reverse, elidable=True
        ),
        migrations.AlterField(
            model_name="fee",
            name="vat_rate",
            field=models.FloatField(
                choices=[
                    (0.0, "0.0% (Mehrwertsteuerfrei)"),
                    (2.6, "2.6% (Reduzierter Satz)"),
                    (3.8, "3.8% (Sondersatz für Beherbergung)"),
                    (8.1, "8.1% (Normalsatz)"),
                    (2.5, "2.5% (Bis 2023: Reduzierter Satz)"),
                    (3.7, "3.7% (Bis 2023: Sondersatz für Beherbergung)"),
                    (7.7, "7.7% (Bis 2023: Normalsatz)"),
                ],
                default=8.1,
                verbose_name="MwSt-Satz",
            ),
        ),
        migrations.AlterField(
            model_name="orderfee",
            name="vat_rate",
            field=models.FloatField(
                choices=[
                    (0.0, "0.0% (Mehrwertsteuerfrei)"),
                    (2.6, "2.6% (Reduzierter Satz)"),
                    (3.8, "3.8% (Sondersatz für Beherbergung)"),
                    (8.1, "8.1% (Normalsatz)"),
                    (2.5, "2.5% (Bis 2023: Reduzierter Satz)"),
                    (3.7, "3.7% (Bis 2023: Sondersatz für Beherbergung)"),
                    (7.7, "7.7% (Bis 2023: Normalsatz)"),
                ],
                default=8.1,
                verbose_name="MwSt-Satz",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="vat_rate",
            field=models.FloatField(
                choices=[
                    (0.0, "0.0% (Mehrwertsteuerfrei)"),
                    (2.6, "2.6% (Reduzierter Satz)"),
                    (3.8, "3.8% (Sondersatz für Beherbergung)"),
                    (8.1, "8.1% (Normalsatz)"),
                    (2.5, "2.5% (Bis 2023: Reduzierter Satz)"),
                    (3.7, "3.7% (Bis 2023: Sondersatz für Beherbergung)"),
                    (7.7, "7.7% (Bis 2023: Normalsatz)"),
                ],
                default=8.1,
                verbose_name="MwSt-Satz",
            ),
        ),
    ]
