# Generated by Django 5.0 on 2023-12-19 15:24

from django.db import migrations, models


def set_initial_defaults(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    ContactPerson = apps.get_model("kmuhelper", "ContactPerson")
    PaymentReceiver = apps.get_model("kmuhelper", "PaymentReceiver")
    Order = apps.get_model("kmuhelper", "Order")

    contact_person = None
    payment_receiver = None

    if Order.objects.using(db_alias).exists():
        newest_order = Order.objects.using(db_alias).order_by("-date").first()
        contact_person = newest_order.contact_person
        payment_receiver = newest_order.payment_receiver
    else:
        if ContactPerson.objects.using(db_alias).exists():
            contact_person = ContactPerson.objects.using(db_alias).first()
        if PaymentReceiver.objects.using(db_alias).exists():
            payment_receiver = PaymentReceiver.objects.using(db_alias).first()

    if contact_person:
        contact_person.is_default = True
        contact_person.save()
    if payment_receiver:
        payment_receiver.is_default = True
        payment_receiver.save()


class Migration(migrations.Migration):
    dependencies = [
        ("kmuhelper", "0108_migrate_vat_rates_for_2024"),
    ]

    operations = [
        migrations.AddField(
            model_name="contactperson",
            name="is_default",
            field=models.BooleanField(
                default=False,
                help_text="Aktivieren, um diese Kontaktperson als Standard zu setzen. Die Standard-Kontaktperson wird bei der Erstellung einer neuen Bestellung sowie beim Import einer Bestellung von WooCommerce verwendet.",
                verbose_name="Standard?",
            ),
        ),
        migrations.AddField(
            model_name="paymentreceiver",
            name="is_default",
            field=models.BooleanField(
                default=False,
                help_text="Aktivieren, um diesen Zahlungsempfänger als Standard zu setzen. Der Standard-Zahlungsempfänger wird bei der Erstellung einer neuen Bestellung sowie beim Import einer Bestellung von WooCommerce verwendet.",
                verbose_name="Standard?",
            ),
        ),
        migrations.RunPython(
            set_initial_defaults, migrations.RunPython.noop, elidable=True
        ),
    ]
