# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""`OpenQL` is a C++/Python framework for high-level quantum programming. The framework provides a compiler for compiling and optimizing quantum code. The compiler produces the intermediate quantum assembly language in cQASM (Common QASM) and the compiled eQASM (executable QASM) for various target platforms. While the eQASM is platform-specific, the quantum assembly code (QASM) is hardware-agnostic and can be simulated on the QX simulator."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_openql')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_openql')
    _openql = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_openql', [dirname(__file__)])
        except ImportError:
            import _openql
            return _openql
        try:
            _mod = imp.load_module('_openql', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _openql = swig_import_helper()
    del swig_import_helper
else:
    import _openql
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class SwigPyIterator(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _openql.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _openql.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _openql.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _openql.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _openql.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _openql.SwigPyIterator_equal(self, x)

    def copy(self):
        return _openql.SwigPyIterator_copy(self)

    def next(self):
        return _openql.SwigPyIterator_next(self)

    def __next__(self):
        return _openql.SwigPyIterator___next__(self)

    def previous(self):
        return _openql.SwigPyIterator_previous(self)

    def advance(self, n):
        return _openql.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _openql.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _openql.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _openql.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _openql.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _openql.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _openql.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _openql.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

class vectori(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def iterator(self):
        return _openql.vectori_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _openql.vectori___nonzero__(self)

    def __bool__(self):
        return _openql.vectori___bool__(self)

    def __len__(self):
        return _openql.vectori___len__(self)

    def __getslice__(self, i, j):
        return _openql.vectori___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _openql.vectori___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _openql.vectori___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _openql.vectori___delitem__(self, *args)

    def __getitem__(self, *args):
        return _openql.vectori___getitem__(self, *args)

    def __setitem__(self, *args):
        return _openql.vectori___setitem__(self, *args)

    def pop(self):
        return _openql.vectori_pop(self)

    def append(self, x):
        return _openql.vectori_append(self, x)

    def empty(self):
        return _openql.vectori_empty(self)

    def size(self):
        return _openql.vectori_size(self)

    def swap(self, v):
        return _openql.vectori_swap(self, v)

    def begin(self):
        return _openql.vectori_begin(self)

    def end(self):
        return _openql.vectori_end(self)

    def rbegin(self):
        return _openql.vectori_rbegin(self)

    def rend(self):
        return _openql.vectori_rend(self)

    def clear(self):
        return _openql.vectori_clear(self)

    def get_allocator(self):
        return _openql.vectori_get_allocator(self)

    def pop_back(self):
        return _openql.vectori_pop_back(self)

    def erase(self, *args):
        return _openql.vectori_erase(self, *args)

    def __init__(self, *args):
        this = _openql.new_vectori(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _openql.vectori_push_back(self, x)

    def front(self):
        return _openql.vectori_front(self)

    def back(self):
        return _openql.vectori_back(self)

    def assign(self, n, x):
        return _openql.vectori_assign(self, n, x)

    def resize(self, *args):
        return _openql.vectori_resize(self, *args)

    def insert(self, *args):
        return _openql.vectori_insert(self, *args)

    def reserve(self, n):
        return _openql.vectori_reserve(self, n)

    def capacity(self):
        return _openql.vectori_capacity(self)
    __swig_destroy__ = _openql.delete_vectori
    __del__ = lambda self: None
vectori_swigregister = _openql.vectori_swigregister
vectori_swigregister(vectori)

class vectorui(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def iterator(self):
        return _openql.vectorui_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _openql.vectorui___nonzero__(self)

    def __bool__(self):
        return _openql.vectorui___bool__(self)

    def __len__(self):
        return _openql.vectorui___len__(self)

    def __getslice__(self, i, j):
        return _openql.vectorui___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _openql.vectorui___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _openql.vectorui___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _openql.vectorui___delitem__(self, *args)

    def __getitem__(self, *args):
        return _openql.vectorui___getitem__(self, *args)

    def __setitem__(self, *args):
        return _openql.vectorui___setitem__(self, *args)

    def pop(self):
        return _openql.vectorui_pop(self)

    def append(self, x):
        return _openql.vectorui_append(self, x)

    def empty(self):
        return _openql.vectorui_empty(self)

    def size(self):
        return _openql.vectorui_size(self)

    def swap(self, v):
        return _openql.vectorui_swap(self, v)

    def begin(self):
        return _openql.vectorui_begin(self)

    def end(self):
        return _openql.vectorui_end(self)

    def rbegin(self):
        return _openql.vectorui_rbegin(self)

    def rend(self):
        return _openql.vectorui_rend(self)

    def clear(self):
        return _openql.vectorui_clear(self)

    def get_allocator(self):
        return _openql.vectorui_get_allocator(self)

    def pop_back(self):
        return _openql.vectorui_pop_back(self)

    def erase(self, *args):
        return _openql.vectorui_erase(self, *args)

    def __init__(self, *args):
        this = _openql.new_vectorui(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _openql.vectorui_push_back(self, x)

    def front(self):
        return _openql.vectorui_front(self)

    def back(self):
        return _openql.vectorui_back(self)

    def assign(self, n, x):
        return _openql.vectorui_assign(self, n, x)

    def resize(self, *args):
        return _openql.vectorui_resize(self, *args)

    def insert(self, *args):
        return _openql.vectorui_insert(self, *args)

    def reserve(self, n):
        return _openql.vectorui_reserve(self, n)

    def capacity(self):
        return _openql.vectorui_capacity(self)
    __swig_destroy__ = _openql.delete_vectorui
    __del__ = lambda self: None
vectorui_swigregister = _openql.vectorui_swigregister
vectorui_swigregister(vectorui)

class vectorf(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def iterator(self):
        return _openql.vectorf_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _openql.vectorf___nonzero__(self)

    def __bool__(self):
        return _openql.vectorf___bool__(self)

    def __len__(self):
        return _openql.vectorf___len__(self)

    def __getslice__(self, i, j):
        return _openql.vectorf___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _openql.vectorf___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _openql.vectorf___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _openql.vectorf___delitem__(self, *args)

    def __getitem__(self, *args):
        return _openql.vectorf___getitem__(self, *args)

    def __setitem__(self, *args):
        return _openql.vectorf___setitem__(self, *args)

    def pop(self):
        return _openql.vectorf_pop(self)

    def append(self, x):
        return _openql.vectorf_append(self, x)

    def empty(self):
        return _openql.vectorf_empty(self)

    def size(self):
        return _openql.vectorf_size(self)

    def swap(self, v):
        return _openql.vectorf_swap(self, v)

    def begin(self):
        return _openql.vectorf_begin(self)

    def end(self):
        return _openql.vectorf_end(self)

    def rbegin(self):
        return _openql.vectorf_rbegin(self)

    def rend(self):
        return _openql.vectorf_rend(self)

    def clear(self):
        return _openql.vectorf_clear(self)

    def get_allocator(self):
        return _openql.vectorf_get_allocator(self)

    def pop_back(self):
        return _openql.vectorf_pop_back(self)

    def erase(self, *args):
        return _openql.vectorf_erase(self, *args)

    def __init__(self, *args):
        this = _openql.new_vectorf(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _openql.vectorf_push_back(self, x)

    def front(self):
        return _openql.vectorf_front(self)

    def back(self):
        return _openql.vectorf_back(self)

    def assign(self, n, x):
        return _openql.vectorf_assign(self, n, x)

    def resize(self, *args):
        return _openql.vectorf_resize(self, *args)

    def insert(self, *args):
        return _openql.vectorf_insert(self, *args)

    def reserve(self, n):
        return _openql.vectorf_reserve(self, n)

    def capacity(self):
        return _openql.vectorf_capacity(self)
    __swig_destroy__ = _openql.delete_vectorf
    __del__ = lambda self: None
vectorf_swigregister = _openql.vectorf_swigregister
vectorf_swigregister(vectorf)

class vectord(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def iterator(self):
        return _openql.vectord_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _openql.vectord___nonzero__(self)

    def __bool__(self):
        return _openql.vectord___bool__(self)

    def __len__(self):
        return _openql.vectord___len__(self)

    def __getslice__(self, i, j):
        return _openql.vectord___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _openql.vectord___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _openql.vectord___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _openql.vectord___delitem__(self, *args)

    def __getitem__(self, *args):
        return _openql.vectord___getitem__(self, *args)

    def __setitem__(self, *args):
        return _openql.vectord___setitem__(self, *args)

    def pop(self):
        return _openql.vectord_pop(self)

    def append(self, x):
        return _openql.vectord_append(self, x)

    def empty(self):
        return _openql.vectord_empty(self)

    def size(self):
        return _openql.vectord_size(self)

    def swap(self, v):
        return _openql.vectord_swap(self, v)

    def begin(self):
        return _openql.vectord_begin(self)

    def end(self):
        return _openql.vectord_end(self)

    def rbegin(self):
        return _openql.vectord_rbegin(self)

    def rend(self):
        return _openql.vectord_rend(self)

    def clear(self):
        return _openql.vectord_clear(self)

    def get_allocator(self):
        return _openql.vectord_get_allocator(self)

    def pop_back(self):
        return _openql.vectord_pop_back(self)

    def erase(self, *args):
        return _openql.vectord_erase(self, *args)

    def __init__(self, *args):
        this = _openql.new_vectord(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _openql.vectord_push_back(self, x)

    def front(self):
        return _openql.vectord_front(self)

    def back(self):
        return _openql.vectord_back(self)

    def assign(self, n, x):
        return _openql.vectord_assign(self, n, x)

    def resize(self, *args):
        return _openql.vectord_resize(self, *args)

    def insert(self, *args):
        return _openql.vectord_insert(self, *args)

    def reserve(self, n):
        return _openql.vectord_reserve(self, n)

    def capacity(self):
        return _openql.vectord_capacity(self)
    __swig_destroy__ = _openql.delete_vectord
    __del__ = lambda self: None
vectord_swigregister = _openql.vectord_swigregister
vectord_swigregister(vectord)


def get_version():
    """
     Returns OpenQL version

    Parameters
    ----------
    None

    Returns
    -------
    str
        version number as a string

    """
    return _openql.get_version()

def set_option(option_name, option_value):
    """
     Sets any of the following OpenQL options:
         Opt. Name   :   Default     : Possible values
        'log_level'  : LOG_NOTHING   : 'LOG_{NOTHING/CRITICAL/ERROR/WARNING/INFO/DEBUG}'
        'output_dir' : 'test_output' : <output directory>
        'optimize'   :   'no'        : 'yes/no'
        'use_default_gates' : 'yes'  : 'yes/no'
        'decompose_toffoli' :  'no'  : 'yes/no'
        'scheduler'  : 'ASAP'        : 'ASAP/ALAP'
        'scheduler_uniform' : 'no'   : 'yes/no'
        'scheduler_commute' : 'no'   : 'yes/no'
        'scheduler_post179' : 'yes'  : 'yes/no'
        'cz_mode' : 'manual'         : 'auto/manual'

    Parameters
    ----------
    arg1 : str
        Option name
    arg2 : str
        Option value

    """
    return _openql.set_option(option_name, option_value)

def get_option(option_name):
    """
     Returns value of any of the following OpenQL options:
         Opt. Name   :   Default     : Possible values
        'log_level'  : LOG_NOTHING   : 'LOG_{NOTHING/CRITICAL/ERROR/WARNING/INFO/DEBUG}'
        'output_dir' : 'test_output' : <output directory>
        'optimize'   :   'no'        : 'yes/no'
        'use_default_gates' : 'yes'  : 'yes/no'
        'decompose_toffoli' :  'no'  : 'yes/no'
        'scheduler'  : 'ASAP'        : 'ASAP/ALAP'
        'scheduler_uniform' : 'no'   : 'yes/no'
        'scheduler_commute' : 'no'   : 'yes/no'
        'scheduler_post179' : 'yes'  : 'yes/no'
        'cz_mode' : 'manual'         : 'auto/manual'

    Parameters
    ----------
    arg1 : str
        Option name

    Returns
    -------
    str
        Option value

    """
    return _openql.get_option(option_name)

def print_options():
    """
    Prints a list of available OpenQL options with their values.


    """
    return _openql.print_options()
class Platform(object):
    """ Platform class specifying the target platform to be used for compilation."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    name = _swig_property(_openql.Platform_name_get, _openql.Platform_name_set)
    config_file = _swig_property(_openql.Platform_config_file_get, _openql.Platform_config_file_set)
    platform = _swig_property(_openql.Platform_platform_get, _openql.Platform_platform_set)

    def __init__(self, *args):
        """
         Constructs a Platform object.

        Parameters
        ----------
        arg1 : str
            name of the Platform
        arg2 : str
            name of the configuration file specifying the platform

        """
        this = _openql.new_Platform(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def get_qubit_number(self):
        """
         returns number of qubits in the platform.

        Parameters
        ----------
        None

        Returns
        -------
        int
            number of qubits

        """
        return _openql.Platform_get_qubit_number(self)

    __swig_destroy__ = _openql.delete_Platform
    __del__ = lambda self: None
Platform_swigregister = _openql.Platform_swigregister
Platform_swigregister(Platform)

class CReg(object):
    """ Classical register class."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    creg = _swig_property(_openql.CReg_creg_get, _openql.CReg_creg_set)

    def __init__(self):
        """
         Constructs a classical register which can be source/destination for classical operations.

        Parameters
        ----------
        None

        Returns
        -------
        CReg
            classical register object


        """
        this = _openql.new_CReg()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _openql.delete_CReg
    __del__ = lambda self: None
CReg_swigregister = _openql.CReg_swigregister
CReg_swigregister(CReg)

class Operation(object):
    """ Operation class representing classical operations."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    operation = _swig_property(_openql.Operation_operation_get, _openql.Operation_operation_set)

    def __init__(self, *args):
        """
         Constructs an Operation object (used for initializing with immediate values).

        Parameters
        ----------
        arg1 : int
            immediate value

        """
        this = _openql.new_Operation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _openql.delete_Operation
    __del__ = lambda self: None
Operation_swigregister = _openql.Operation_swigregister
Operation_swigregister(Operation)

class Kernel(object):
    """ Kernel class which contains various quantum instructions."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    name = _swig_property(_openql.Kernel_name_get, _openql.Kernel_name_set)
    platform = _swig_property(_openql.Kernel_platform_get, _openql.Kernel_platform_set)
    qubit_count = _swig_property(_openql.Kernel_qubit_count_get, _openql.Kernel_qubit_count_set)
    creg_count = _swig_property(_openql.Kernel_creg_count_get, _openql.Kernel_creg_count_set)
    kernel = _swig_property(_openql.Kernel_kernel_get, _openql.Kernel_kernel_set)

    def __init__(self, name, platform, qubit_count, creg_count=0):
        """
         Constructs a Kernel object.

        Parameters
        ----------
        arg1 : str
            name of the Kernel
        arg2 : Platform
            target platform for which the kernel will be compiled
        arg3 : int
            qubit count
        arg4 : int
            classical register count

        """
        this = _openql.new_Kernel(name, platform, qubit_count, creg_count)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def identity(self, q0):
        """
         Applies identity on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_identity(self, q0)


    def hadamard(self, q0):
        """
         Applies hadamard on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_hadamard(self, q0)


    def s(self, q0):
        """
         Applies x on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_s(self, q0)


    def sdag(self, q0):
        """
         Applies sdag on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_sdag(self, q0)


    def t(self, q0):
        return _openql.Kernel_t(self, q0)

    def tdag(self, q0):
        return _openql.Kernel_tdag(self, q0)

    def x(self, q0):
        return _openql.Kernel_x(self, q0)

    def y(self, q0):
        """
         Applies y on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_y(self, q0)


    def z(self, q0):
        """
         Applies z on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_z(self, q0)


    def rx90(self, q0):
        """
         Applies rx90 on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_rx90(self, q0)


    def mrx90(self, q0):
        """
         Applies mrx90 on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_mrx90(self, q0)


    def rx180(self, q0):
        """
         Applies rx180 on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_rx180(self, q0)


    def ry90(self, q0):
        return _openql.Kernel_ry90(self, q0)

    def mry90(self, q0):
        return _openql.Kernel_mry90(self, q0)

    def ry180(self, q0):
        """
         Applies ry180 on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_ry180(self, q0)


    def rx(self, q0, angle):
        return _openql.Kernel_rx(self, q0, angle)

    def ry(self, q0, angle):
        return _openql.Kernel_ry(self, q0, angle)

    def rz(self, q0, angle):
        return _openql.Kernel_rz(self, q0, angle)

    def measure(self, q0):
        """
         measures input qubit.

        Parameters
        ----------
        arg1 : int
            input qubit

        """
        return _openql.Kernel_measure(self, q0)


    def prepz(self, q0):
        return _openql.Kernel_prepz(self, q0)

    def cnot(self, q0, q1):
        """
         Applies controlled-not operation.

        Parameters
        ----------
        arg1 : int
            control qubit
        arg2 : int
            target qubit

        """
        return _openql.Kernel_cnot(self, q0, q1)


    def cphase(self, q0, q1):
        """
         Applies controlled-phase operation.

        Parameters
        ----------
        arg1 : int
            control qubit
        arg2 : int
            target qubit

        """
        return _openql.Kernel_cphase(self, q0, q1)


    def cz(self, q0, q1):
        return _openql.Kernel_cz(self, q0, q1)

    def toffoli(self, q0, q1, q2):
        """
         Applies controlled-controlled-not operation.

        Parameters
        ----------
        arg1 : int
            control qubit
        arg2 : int
            control qubit
        arg3 : int
            target qubit

        """
        return _openql.Kernel_toffoli(self, q0, q1, q2)


    def clifford(self, id, q0):
        """
         Applies clifford operation of the specified id on the qubit.

        Parameters
        ----------
        arg1 : int
            clifford operation id
        arg2 : int
            target qubit

        The ids and the corresponding operations are:
        0 : ['I']
        1 : ['Y90', 'X90']
        2 : ['mX90', 'mY90']
        3 : ['X180']
        4 : ['mY90', 'mX90']
        5 : ['X90', 'mY90']
        6 : ['Y180']
        7 : ['mY90', 'X90']
        8 : ['X90', 'Y90']
        9 : ['X180', 'Y180']
        10: ['Y90', 'mX90']
        11: ['mX90', 'Y90']
        12: ['Y90', 'X180']
        13: ['mX90']
        14: ['X90', 'mY90', 'mX90']
        15: ['mY90']
        16: ['X90']
        17: ['X90', 'Y90', 'X90']
        18: ['mY90', 'X180']
        19: ['X90', 'Y180']
        20: ['X90', 'mY90', 'X90']
        21: ['Y90']
        22: ['mX90', 'Y180']
        23: ['X90', 'Y90', 'mX90']

        """
        return _openql.Kernel_clifford(self, id, q0)


    def wait(self, qubits, duration):
        """
         inserts explicit wait on specified qubits. wait with duration '0'
            is equivalent to barrier on specified list of qubits. If no qubits
            are specified, then wait/barrier is applied on all the qubits.


        Parameters
        ----------
        arg1 : []
            list of qubits
        arg2 : int
            duration in ns

        """
        return _openql.Kernel_wait(self, qubits, duration)


    def barrier(self, *args, **kwargs):
        """
         inserts explicit barrier on specified qubits. wait with duration '0'
            is also equivalent to applying barrier on specified list of qubits.
            If no qubits are specified, then barrier is applied on all the qubits.

        Parameters
        ----------
        arg1 : []
            list of qubits

        """
        return _openql.Kernel_barrier(self, *args, **kwargs)


    def get_custom_instructions(self):
        """
         Returns list of available custom instructions.

        Parameters
        ----------
        None

        Returns
        -------
        []
            List of available custom instructions

        """
        return _openql.Kernel_get_custom_instructions(self)


    def display(self):
        """
         inserts QX display instruction (so QX specific).

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Kernel_display(self)


    def gate(self, *args):
        """
         adds custom/default gates to kernel.

        Parameters
        ----------
        arg1 : str
            name of gate
        arg2 : []
            list of qubits
        arg3 : CReg
            classical destination register for measure operation.

        """
        return _openql.Kernel_gate(self, *args)


    def classical(self, *args):
        """
         adds classical operation kernel.

        Parameters
        ----------
        arg1 : CReg
            destination register for classical operation.
        arg2 : Operation
            classical operation.

        """
        return _openql.Kernel_classical(self, *args)


    def controlled(self, k, control_qubits, ancilla_qubits):
        """
         generates controlled version of the kernel from the input kernel.

        Parameters
        ----------

        arg1 : ql::Kernel
            input kernel. Except measure, Kernel to be controlled may contain any of the default gates as well custom gates which are not specialized for a specific qubits.

        arg2 : []
            list of control qubits.

        arg3 : []
            list of ancilla qubits. Number of ancilla qubits should be equal to number of control qubits.


        Returns
        -------
        None

        """
        return _openql.Kernel_controlled(self, k, control_qubits, ancilla_qubits)


    def conjugate(self, k):
        """
         generates conjugate version of the kernel from the input kernel.

        Parameters
        ----------

        arg1 : ql::Kernel
            input kernel. Except measure, Kernel to be conjugated.


        Returns
        -------
        None

        """
        return _openql.Kernel_conjugate(self, k)

    __swig_destroy__ = _openql.delete_Kernel
    __del__ = lambda self: None
Kernel_swigregister = _openql.Kernel_swigregister
Kernel_swigregister(Kernel)

class Program(object):
    """ Program class which contains one or more kernels."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    name = _swig_property(_openql.Program_name_get, _openql.Program_name_set)
    platform = _swig_property(_openql.Program_platform_get, _openql.Program_platform_set)
    qubit_count = _swig_property(_openql.Program_qubit_count_get, _openql.Program_qubit_count_set)
    creg_count = _swig_property(_openql.Program_creg_count_get, _openql.Program_creg_count_set)
    program = _swig_property(_openql.Program_program_get, _openql.Program_program_set)

    def __init__(self, *args):
        """
         Constructs a program object.

        Parameters
        ----------
        arg1 : str
            name of the program
        arg2 : Platform
            instance of an OpenQL Platform
        arg3 : int
            number of qubits the program will use
        arg4 : int
            number of classical registers the program will use (default: 0)

        """
        this = _openql.new_Program(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def set_sweep_points(self, sweep_points):
        """
         Sets sweep points for an experiment.

        Parameters
        ----------
        arg1 : []
            list of sweep points

        """
        return _openql.Program_set_sweep_points(self, sweep_points)


    def get_sweep_points(self):
        """
         Returns sweep points for an experiment.

        Parameters
        ----------
        None

        Returns
        -------
        []
            list of sweep points 
        """
        return _openql.Program_get_sweep_points(self)


    def add_kernel(self, k):
        """
         Adds specified kernel to program.

        Parameters
        ----------
        arg1 : kernel
            kernel to be added

        """
        return _openql.Program_add_kernel(self, k)


    def add_program(self, p):
        return _openql.Program_add_program(self, p)

    def add_if(self, *args):
        """
         Adds specified sub-program to a program which will be executed if specified condition is true. This allows nesting of operations.

        Parameters
        ----------
        arg1 : Program
            program to be executed
        arg2: Operation
            classical relational operation (<, >, <=, >=, ==, !=)

        """
        return _openql.Program_add_if(self, *args)


    def add_if_else(self, *args):
        """
         Adds specified sub-programs to a program. First sub-program will be executed if specified condition is true. Second sub-program will be executed if specified condition is false.

        Parameters
        ----------
        arg1 : Program
            program to be executed when specified condition is true (if part).
        arg2 : Program
            program to be executed when specified condition is false (else part).
        arg3: Operation
            classical relational operation (<, >, <=, >=, ==, !=)

        """
        return _openql.Program_add_if_else(self, *args)


    def add_do_while(self, *args):
        """
         Adds specified sub-program to a program which will be repeatedly executed while specified condition is true.

        Parameters
        ----------
        arg1 : Program
            program to be executed repeatedly
        arg2: Operation
            classical relational operation (<, >, <=, >=, ==, !=)

        """
        return _openql.Program_add_do_while(self, *args)


    def add_for(self, *args):
        """
         Adds specified sub-program to a program which will be executed for specified iterations.

        Parameters
        ----------
        arg1 : Program
            sub-program to be executed repeatedly
        arg2: int
            iteration count

        """
        return _openql.Program_add_for(self, *args)


    def compile(self):
        """
         Compiles the program.

        Parameters
        ----------
        None

        """
        return _openql.Program_compile(self)


    def qasm(self):
        """
         Returns program QASM
        Parameters
        ----------
        None

        Returns
        -------
        str
            qasm 
        """
        return _openql.Program_qasm(self)


    def microcode(self):
        """
         Returns program microcode
        Parameters
        ----------
        None

        Returns
        -------
        str
            microcode 
        """
        return _openql.Program_microcode(self)


    def print_interaction_matrix(self):
        return _openql.Program_print_interaction_matrix(self)

    def write_interaction_matrix(self):
        return _openql.Program_write_interaction_matrix(self)
    __swig_destroy__ = _openql.delete_Program
    __del__ = lambda self: None
Program_swigregister = _openql.Program_swigregister
Program_swigregister(Program)



