from tgpromo.exceptions import TGPromoException
from .models import PartnerAPIError


class PartnerException(TGPromoException):
    pass


class PartnerAPIException(PartnerException):
    def __init__(self, error: PartnerAPIError):
        self.code = error.code
        self.message = error.message
        super().__init__(f'[{self.code}] {self.message}')

    def __str__(self):
        return f'PartnerAPIException: [{self.code}] {self.message}'
