from typing import Generic, Optional, TypeVar
from pydantic import BaseModel, model_validator


T = TypeVar('T')


class PartnerAPIError(BaseModel):
    code: str
    message: str


class PartnerAPIResponse(BaseModel, Generic[T]):
    success: bool
    result: Optional[T] = None
    error: Optional[PartnerAPIError] = None

    @model_validator(mode='after')
    def validate_response(self) -> 'PartnerAPIResponse':
        if self.success:
            if self.error is not None:
                raise ValueError('error must be None if success is True')
        else:
            if self.error is None:
                raise ValueError('error must be present if success is False')
            if self.result is not None:
                raise ValueError('result must be None if success is False')
        return self

