# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2024-05-15T16:52:02+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import Field, constr

from kelvin.api.client.base_model import BaseModelRoot
from kelvin.api.client.data_model import DataModelBase


class ErrorObject(DataModelBase):
    """
    ErrorObject object.

    Parameters
    ----------
    name: Optional[constr(min_length=1, max_length=64)]
    title: Optional[constr(min_length=1, max_length=64)]
    description: Optional[str]
    solution: Optional[str]
    payload: Optional[List[Dict[str, Any]]]

    """

    name: Optional[constr(min_length=1, max_length=64)] = Field(None, description="ID of the error.")
    title: Optional[constr(min_length=1, max_length=64)] = Field(None, description="Title of the error.")
    description: Optional[str] = Field(None, description="A description of what the problem may be.")
    solution: Optional[str] = Field(None, description="A possible solution to the problem.")
    payload: Optional[List[Dict[str, Any]]] = Field(
        None,
        description="Optional additional information. For example an array of objects listing all the errors that triggered the 4XX response.",
    )


class Error(BaseModelRoot[Union[ErrorObject, List[ErrorObject]]]):
    """
    Error object.

    Parameters
    ----------
    __root__: Union[ErrorObject, List[ErrorObject]]

    """

    __root__: Union[ErrorObject, List[ErrorObject]]


class Type(Enum):
    system = "system"


class ErrorLegacy(DataModelBase):
    """
    ErrorLegacy object.

    Parameters
    ----------
    description: Optional[str]
    name: Optional[constr(min_length=1, max_length=64)]
    payload: Optional[List[Dict[str, Any]]]
    solution: Optional[str]
    title: Optional[constr(min_length=1, max_length=64)]
    type: Optional[Type]

    """

    description: Optional[str] = Field(None, description="Description of what the error is about.")
    name: Optional[constr(min_length=1, max_length=64)] = Field(
        None, description="Unique identifier name of the error."
    )
    payload: Optional[List[Dict[str, Any]]] = Field(
        None,
        description="A dictionary of all the individual error names, error titles, descriptions and solutions within the submitted information.",
    )
    solution: Optional[str] = Field(None, description="Possible solutions to resolve the error.")
    title: Optional[constr(min_length=1, max_length=64)] = Field(
        None, description="The Display name (title) of the error."
    )
    type: Optional[Type] = Field(None, description="The type of error that has occured, e.g. `system`.")
