#!/usr/bin/env python
# Authors: Maurizio Lupo <maurizio.lupo@redomino.com> and contributors (see docs/CONTRIBUTORS.txt)
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

title = u"Ploomcake out of the oven"

desc = u"Congratulations! Your Ploomcake is finally baked and out of the oven."

text = u"""
<h2>Serve your Ploomcake</h2>
<p>Now that you've complete the installation here you have some basic settings we suggest you to do before getting started:</p>
<ol>
<li>make sure you're logged as site administrator/manager</li>
<li>you can get to the site setup menu by clicking on the dropdown menu that you can find on the  top-right corner</li>
<li>set a title and a description for your Ploomcake for a better indexation on search engines ("Site menu")</li>
<li>set the default language and the languages in which the site should be translatable ("Language menu")</li>
<li>check the mail settings ("Email menu")</li>
<li>create and manage authorized users and groups ("Users and groups menu")</li>
<li>check the security setting ("Security menu")</li>
</ol>
<h2>Fill your Ploomcake</h2>
<blockquote class="pullquote"><p>Remember: most of the actions you can do in Ploomcake concern the content you're viewing.</p></blockquote>
<p>Now you're ready to add contents to your portal. Here are some hints:</p>
<ol>
<li><strong>structure</strong>: start by adding some folders in order to give your portal a structure;</li>
<li><strong>contents</strong>: see all the new contents you can create by checking the "Add..." drop-down menu on the green toolbar;.</li>
<li><strong>teamwork</strong>: you can let other people cooperate with you in working at the website: assign global roles or local roles (by the "Sharing" tab) to users and groups.</li>
</ol>
<h2>Become a real Chef</h2>
<p>You can find documentation on our official website <a class="external-link" href="http://www.ploomcake.org" target="_blank">Ploomcake.org</a>, and on <a class="external-link" href="http://plone.org/documentation/manual/plone-4-user-manual" target="_blank"> Plone's official website</a> </p>
<h2>Get involved!</h2>
<div>Got any doubt, question, remark, suggestion, or you'd simply like to make your contribution to Ploomcake? <a class="external-link" href="http://www.ploomcake.org/en/suggest-us" target="_blank">Share your thoughts with us!</a></div>
<p></p>
<p></p>
<p>- The Ploomcake Team hope you enjoy it!</p>
"""


