__all__ = [
    "AlertSeverity",
    "AlertsIncidentPreference",
    "AlertsNrqlConditionsType",
    "EntityType",
]


from ..core.base import BaseEnum


class AlertSeverity(BaseEnum):
    CRITICAL = "CRITICAL"
    NOT_ALERTING = "NOT_ALERTING"
    WARNING = "WARNING"


class AlertsIncidentPreference(BaseEnum):
    PER_CONDITION = "PER_CONDITION"
    PER_CONDITION_AND_TARGET = "PER_CONDITION_AND_TARGET"
    PER_POLICY = "PER_POLICY"


class AlertsNrqlConditionsType(BaseEnum):
    BASELINE = "BASELINE"
    STATIC = "STATIC"


class EntityType(BaseEnum):
    APM_APPLICATION_ENTITY = "APM_APPLICATION_ENTITY"
    APM_DATABASE_INSTANCE_ENTITY = "APM_DATABASE_INSTANCE_ENTITY"
    APM_EXTERNAL_SERVICE_ENTITY = "APM_EXTERNAL_SERVICE_ENTITY"
    BROWSER_APPLICATION_ENTITY = "BROWSER_APPLICATION_ENTITY"
    DASHBOARD_ENTITY = "DASHBOARD_ENTITY"
    EXTERNAL_ENTITY = "EXTERNAL_ENTITY"
    GENERIC_ENTITY = "GENERIC_ENTITY"
    GENERIC_INFRASTRUCTURE_ENTITY = "GENERIC_INFRASTRUCTURE_ENTITY"
    INFRASTRUCTURE_AWS_LAMBDA_FUNCTION_ENTITY = (
        "INFRASTRUCTURE_AWS_LAMBDA_FUNCTION_ENTITY"
    )
    INFRASTRUCTURE_HOST_ENTITY = "INFRASTRUCTURE_HOST_ENTITY"
    KEY_TRANSACTION_ENTITY = "KEY_TRANSACTION_ENTITY"
    MOBILE_APPLICATION_ENTITY = "MOBILE_APPLICATION_ENTITY"
    SECURE_CREDENTIAL_ENTITY = "SECURE_CREDENTIAL_ENTITY"
    SYNTHETIC_MONITOR_ENTITY = "SYNTHETIC_MONITOR_ENTITY"
    THIRD_PARTY_SERVICE_ENTITY = "THIRD_PARTY_SERVICE_ENTITY"
    UNAVAILABLE_ENTITY = "UNAVAILABLE_ENTITY"
    WORKLOAD_ENTITY = "WORKLOAD_ENTITY"
