# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ApprovalRuleArgs', 'ApprovalRule']

@pulumi.input_type
class ApprovalRuleArgs:
    def __init__(__self__, *,
                 approval_rule_config: pulumi.Input['ApprovalRuleConfigArgs'],
                 enabled: pulumi.Input[bool],
                 environment_identifier: pulumi.Input['EnvironmentIdentifierArgs'],
                 name: pulumi.Input[str],
                 target_action_type: pulumi.Input['TargetActionType']):
        """
        The set of arguments for constructing a ApprovalRule resource.
        :param pulumi.Input['ApprovalRuleConfigArgs'] approval_rule_config: The approval rule configuration.
        :param pulumi.Input[bool] enabled: Whether the approval rule is enabled.
        :param pulumi.Input['EnvironmentIdentifierArgs'] environment_identifier: The environment this rule applies to.
        :param pulumi.Input[str] name: The name of the approval rule.
        :param pulumi.Input['TargetActionType'] target_action_type: The type of action this rule applies to.
        """
        pulumi.set(__self__, "approval_rule_config", approval_rule_config)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "environment_identifier", environment_identifier)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target_action_type", target_action_type)

    @property
    @pulumi.getter(name="approvalRuleConfig")
    def approval_rule_config(self) -> pulumi.Input['ApprovalRuleConfigArgs']:
        """
        The approval rule configuration.
        """
        return pulumi.get(self, "approval_rule_config")

    @approval_rule_config.setter
    def approval_rule_config(self, value: pulumi.Input['ApprovalRuleConfigArgs']):
        pulumi.set(self, "approval_rule_config", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether the approval rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> pulumi.Input['EnvironmentIdentifierArgs']:
        """
        The environment this rule applies to.
        """
        return pulumi.get(self, "environment_identifier")

    @environment_identifier.setter
    def environment_identifier(self, value: pulumi.Input['EnvironmentIdentifierArgs']):
        pulumi.set(self, "environment_identifier", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the approval rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetActionType")
    def target_action_type(self) -> pulumi.Input['TargetActionType']:
        """
        The type of action this rule applies to.
        """
        return pulumi.get(self, "target_action_type")

    @target_action_type.setter
    def target_action_type(self, value: pulumi.Input['TargetActionType']):
        pulumi.set(self, "target_action_type", value)


class ApprovalRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rule_config: Optional[pulumi.Input[Union['ApprovalRuleConfigArgs', 'ApprovalRuleConfigArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 environment_identifier: Optional[pulumi.Input[Union['EnvironmentIdentifierArgs', 'EnvironmentIdentifierArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 target_action_type: Optional[pulumi.Input['TargetActionType']] = None,
                 __props__=None):
        """
        An approval rule for environment deployments.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApprovalRuleConfigArgs', 'ApprovalRuleConfigArgsDict']] approval_rule_config: The approval rule configuration.
        :param pulumi.Input[bool] enabled: Whether the approval rule is enabled.
        :param pulumi.Input[Union['EnvironmentIdentifierArgs', 'EnvironmentIdentifierArgsDict']] environment_identifier: The environment this rule applies to.
        :param pulumi.Input[str] name: The name of the approval rule.
        :param pulumi.Input['TargetActionType'] target_action_type: The type of action this rule applies to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApprovalRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An approval rule for environment deployments.

        :param str resource_name: The name of the resource.
        :param ApprovalRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApprovalRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rule_config: Optional[pulumi.Input[Union['ApprovalRuleConfigArgs', 'ApprovalRuleConfigArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 environment_identifier: Optional[pulumi.Input[Union['EnvironmentIdentifierArgs', 'EnvironmentIdentifierArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 target_action_type: Optional[pulumi.Input['TargetActionType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApprovalRuleArgs.__new__(ApprovalRuleArgs)

            if approval_rule_config is None and not opts.urn:
                raise TypeError("Missing required property 'approval_rule_config'")
            __props__.__dict__["approval_rule_config"] = approval_rule_config
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if environment_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'environment_identifier'")
            __props__.__dict__["environment_identifier"] = environment_identifier
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if target_action_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_action_type'")
            __props__.__dict__["target_action_type"] = target_action_type
        super(ApprovalRule, __self__).__init__(
            'pulumiservice:index:ApprovalRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ApprovalRule':
        """
        Get an existing ApprovalRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApprovalRuleArgs.__new__(ApprovalRuleArgs)

        __props__.__dict__["approval_rule_config"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["environment_identifier"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["target_action_type"] = None
        return ApprovalRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approvalRuleConfig")
    def approval_rule_config(self) -> pulumi.Output['outputs.ApprovalRuleConfig']:
        """
        The approval rule configuration.
        """
        return pulumi.get(self, "approval_rule_config")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Whether the approval rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> pulumi.Output['outputs.EnvironmentIdentifier']:
        """
        The environment this rule applies to.
        """
        return pulumi.get(self, "environment_identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the approval rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetActionType")
    def target_action_type(self) -> pulumi.Output['TargetActionType']:
        """
        The type of action this rule applies to.
        """
        return pulumi.get(self, "target_action_type")

