/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.ShapeItemInstance;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import org.apache.commons.lang3.ArrayUtils;

public class ShapeItem
extends Item {
    public static final String TYPE = "Box";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String SHAPE = "shape";
    protected static final String BEVEL = "bevel";
    protected static final String RECT = "Rectangle";
    protected static final String RRECT = "Rounded Rectangle";
    protected static final String OVAL = "Oval";
    protected int height = 30;
    protected int width = 40;
    protected int bevel = 5;
    protected String shape = "Rectangle";
    private final VisibilityCondition falseCond = () -> false;
    private final VisibilityCondition bevelCond = () -> this.shape.equals(RRECT);

    public ShapeItem() {
    }

    public ShapeItem(GamePieceLayout l) {
        super(l);
    }

    public ShapeItem(GamePieceLayout l, String n) {
        this(l);
        this.setConfigureName(n);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.insert((int)2, (Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.width"), Resources.getString("Editor.height"), Resources.getString("Editor.ShapeItem.shape"), Resources.getString("Editor.ShapeItem.bevel")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.insert((int)2, (Object[])super.getAttributeTypes(), (Object[])new Class[]{Integer.class, Integer.class, ShapeConfig.class, Integer.class});
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.insert((int)2, (Object[])super.getAttributeNames(), (Object[])new String[]{WIDTH, HEIGHT, SHAPE, BEVEL});
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (WIDTH.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.width = (Integer)o;
            if (this.width < 1) {
                this.width = 1;
            }
        } else if (HEIGHT.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.height = (Integer)o;
            if (this.height < 1) {
                this.height = 1;
            }
        } else if (SHAPE.equals(key)) {
            this.shape = (String)o;
        } else if (BEVEL.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.bevel = (Integer)o;
            if (this.bevel < 0) {
                this.bevel = 0;
            }
        } else {
            super.setAttribute(key, o);
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (WIDTH.equals(key)) {
            return String.valueOf(this.width);
        }
        if (HEIGHT.equals(key)) {
            return String.valueOf(this.height);
        }
        if (SHAPE.equals(key)) {
            return this.shape;
        }
        if (BEVEL.equals(key)) {
            return String.valueOf(this.bevel);
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if ("rotation".equals(name)) {
            return this.falseCond;
        }
        if (BEVEL.equals(name)) {
            return this.bevelCond;
        }
        return super.getAttributeVisibility(name);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(Graphics g, GamePieceImage defn) {
        ItemInstance si = null;
        if (defn != null) {
            si = defn.getShapeInstance(this.getConfigureName());
        }
        if (si == null) {
            si = new ShapeItemInstance();
        }
        Color fg = si.getFgColor().getColor();
        Color bg = ((ShapeItemInstance)si).getBorderColor().getColor();
        Point origin = this.layout.getPosition(this);
        Rectangle r = new Rectangle(origin.x, origin.y, this.getWidth(), this.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        Object aa = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isAntialias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        if (fg != null) {
            g.setColor(fg);
            if (this.shape.equals(RECT)) {
                g.fillRect(r.x, r.y, r.width, r.height);
            } else if (this.shape.equals(RRECT)) {
                g.fillRoundRect(r.x, r.y, r.width, r.height, this.bevel * 2, this.bevel * 2);
            } else if (this.shape.equals(OVAL)) {
                g.fillOval(r.x, r.y, r.width, r.height);
            }
        }
        if (bg != null) {
            g.setColor(bg);
            if (this.shape.equals(RECT)) {
                g.drawRect(r.x, r.y, r.width, r.height);
            } else if (this.shape.equals(RRECT)) {
                g.drawRoundRect(r.x, r.y, r.width, r.height, this.bevel * 2, this.bevel * 2);
            } else if (this.shape.equals(OVAL)) {
                g.drawOval(r.x, r.y, r.width, r.height);
            }
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getDisplayName() {
        return Resources.getString("Editor.ShapeItem.component_type");
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public static Item decode(GamePieceLayout l, String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
        ShapeItem item = new ShapeItem(l);
        sd.nextToken();
        item.width = sd.nextInt(30);
        item.height = sd.nextInt(40);
        item.shape = sd.nextToken(RECT);
        item.bevel = sd.nextInt(5);
        return item;
    }

    @Override
    public String encode() {
        SequenceEncoder se1 = new SequenceEncoder(TYPE, ';');
        se1.append(this.width);
        se1.append(this.height);
        se1.append(this.shape);
        se1.append(this.bevel);
        SequenceEncoder se2 = new SequenceEncoder(se1.getValue(), '|');
        se2.append(super.encode());
        return se2.getValue();
    }

    public static class ShapeConfig
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{ShapeItem.RECT, ShapeItem.RRECT, ShapeItem.OVAL};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.ShapeItem.rectangle", "Editor.ShapeItem.rounded_rectangle", "Editor.ShapeItem.oval"};
        }
    }
}

