/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.build.module.gamepieceimage.Symbol;
import VASSAL.tools.image.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class SizeConfigurer
extends StringEnumConfigurer {
    private static final Map<String, String> symbolMap = new HashMap<String, String>();

    public SizeConfigurer(String key, String name) {
        super(key, name, Symbol.NatoUnitSymbolSet.getSymbolSizes());
        if (symbolMap.isEmpty()) {
            for (Symbol.SizeOption size : Symbol.NatoUnitSymbolSet.SIZES) {
                symbolMap.put(size.getName(), size.getDisplayName());
            }
        }
    }

    public JComboBox getComboBox() {
        return new SizeComboBox();
    }

    public class SizeComboBox
    extends JComboBox {
        private static final long serialVersionUID = 1L;

        public SizeComboBox() {
            String[] s;
            for (String item : s = Symbol.NatoUnitSymbolSet.getSymbolSizes()) {
                this.addItem(item);
            }
            SizeRenderer renderer = new SizeRenderer();
            this.setRenderer(renderer);
        }

        public SizeComboBox(ItemListener l) {
            this();
            this.addItemListener(l);
        }

        public SizeComboBox(ItemListener l, String sizeName) {
            this();
            this.setSelectedItem(sizeName);
            this.addItemListener(l);
        }

        public class SizeRenderer
        extends JLabel
        implements ListCellRenderer {
            private static final long serialVersionUID = 1L;

            public SizeRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(2);
                this.setVerticalAlignment(0);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                int sample_w = 6;
                int sample_h = 12;
                boolean sample_g = true;
                int w = 42;
                int h = 13;
                BufferedImage img = ImageUtils.createCompatibleImage(42, 13);
                Graphics2D g = img.createGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, 42, 13);
                g.setColor(Color.black);
                g.drawRect(0, 0, 41, 12);
                BufferedImage simg = Symbol.NatoUnitSymbolSet.buildSizeImage((String)value, 6, 12, 1);
                int x = 21 - simg.getWidth() / 2;
                g.drawImage((Image)simg, x, 0, null);
                g.dispose();
                this.setIcon(new ImageIcon(img));
                this.setText(symbolMap.get(value));
                this.setHorizontalTextPosition(2);
                this.setHorizontalAlignment(4);
                this.setFont(list.getFont());
                return this;
            }
        }
    }
}

