/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.deck;

import VASSAL.build.module.map.deck.SortParameter;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class SortParameterConfigurer
extends Configurer {
    private JPanel controls;
    private StringConfigurer propertyConfig;
    private BooleanConfigurer descendingConfig;
    private BooleanConfigurer numericConfig;

    public SortParameterConfigurer(String key, String name, Object val) {
        super(key, name, val);
    }

    public SortParameterConfigurer(Object val) {
        this("", "", val);
    }

    public SortParameterConfigurer() {
        this(null);
    }

    @Override
    public String getValueString() {
        return this.value == null ? "" : ((SortParameter)this.getValue()).toString();
    }

    @Override
    public void setValue(String s) {
        this.setValue(new SortParameter(s));
    }

    @Override
    public void setValue(Object o) {
        if (this.propertyConfig == null) {
            this.propertyConfig = new StringConfigurer("");
            this.propertyConfig.setHintKey("Editor.DeckSortKeyCommand.name_hint");
            this.descendingConfig = new BooleanConfigurer(false);
            this.numericConfig = new BooleanConfigurer(false);
        }
        this.setFrozen(true);
        if (!this.noUpdate && o instanceof SortParameter) {
            SortParameter param = (SortParameter)o;
            this.propertyConfig.setValue(param == null ? "" : param.getSortProperty());
            this.descendingConfig.setValue(param != null && param.isDescendingSort());
            this.numericConfig.setValue(param != null && param.isNumericSort());
        }
        this.setFrozen(false);
        super.setValue(o);
    }

    @Override
    public void setFrozen(boolean val) {
        super.setFrozen(val);
        this.propertyConfig.setFrozen(val);
        this.descendingConfig.setFrozen(val);
        this.numericConfig.setFrozen(val);
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel((LayoutManager)new MigLayout("ins 2,gapy 4,hidemode 3", "[]rel[][]rel[][]rel[]"));
            this.controls.setBorder(BorderFactory.createEtchedBorder());
            JLabel propertyLabel = new JLabel(Resources.getString("Editor.DeckSortKeyCommand.name"));
            propertyLabel.setLabelFor(this.propertyConfig.getControls());
            this.controls.add(propertyLabel);
            this.controls.add(this.propertyConfig.getControls());
            JLabel descendingLabel = new JLabel(Resources.getString("Editor.DeckSortKeyCommand.descending"));
            descendingLabel.setLabelFor(this.descendingConfig.getControls());
            this.controls.add(descendingLabel);
            this.controls.add(this.descendingConfig.getControls());
            JLabel numericLabel = new JLabel(Resources.getString("Editor.DeckSortKeyCommand.numeric"));
            numericLabel.setLabelFor(this.numericConfig.getControls());
            this.controls.add(numericLabel);
            this.controls.add(this.numericConfig.getControls());
            this.propertyConfig.addPropertyChangeListener(e -> this.updateValue());
            this.descendingConfig.addPropertyChangeListener(e -> this.updateValue());
            this.numericConfig.addPropertyChangeListener(e -> this.updateValue());
        }
        return this.controls;
    }

    private void updateValue() {
        this.noUpdate = true;
        this.setValue(new SortParameter(this.propertyConfig.getValueString(), this.descendingConfig.booleanValue(), this.numericConfig.booleanValue()));
        this.noUpdate = false;
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        this.propertyConfig.setHighlighted(highlighted);
        this.descendingConfig.setHighlighted(highlighted);
        this.numericConfig.setHighlighted(highlighted);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        this.propertyConfig.addFocusListener(listener);
        this.descendingConfig.addFocusListener(listener);
        this.numericConfig.addFocusListener(listener);
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        this.propertyConfig.removeFocusListener(listener);
        this.descendingConfig.removeFocusListener(listener);
        this.numericConfig.removeFocusListener(listener);
    }

    @Override
    public void requestFocus() {
        if (this.propertyConfig != null) {
            this.propertyConfig.requestFocus();
        }
    }
}

