/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.module.properties.PropertyPrompt;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import javax.swing.JOptionPane;

public class EnumeratedPropertyPrompt
extends PropertyPrompt {
    protected String[] validValues;
    protected Expression[] valueExpressions;
    protected PropertyPrompt.DialogParent dialogParent;

    public EnumeratedPropertyPrompt(PropertyPrompt.DialogParent dialogParent, String prompt, String[] validValues, PropertyPrompt.Constraints propertySource) {
        super(propertySource, prompt);
        this.validValues = validValues;
        this.valueExpressions = new Expression[validValues.length];
        for (int i = 0; i < validValues.length; ++i) {
            this.valueExpressions[i] = Expression.createExpression(validValues[i]);
        }
        this.dialogParent = dialogParent;
    }

    public Expression[] getValueExpressions() {
        return this.valueExpressions;
    }

    @Override
    public String getNewValue(String oldValue) {
        Object[] finalValues = new String[this.valueExpressions.length];
        for (int i = 0; i < finalValues.length; ++i) {
            String value;
            try {
                AuditTrail audit = AuditTrail.create((Auditable)(this.constraints == null ? null : this.constraints.getPropertySource()), this.valueExpressions[i].getExpression());
                value = this.constraints == null ? this.valueExpressions[i].evaluate((Auditable)this.constraints.getPropertySource(), audit) : this.valueExpressions[i].evaluate(this.constraints.getPropertySource(), this.constraints.getPropertySource(), audit);
            }
            catch (ExpressionException e) {
                value = this.valueExpressions[i].getExpression();
            }
            finalValues[i] = value;
        }
        String newValue = (String)JOptionPane.showInputDialog(this.dialogParent.getComponent(), this.promptText, null, 3, null, finalValues, oldValue);
        return newValue == null ? oldValue : newValue;
    }

    public String[] getValidValues() {
        return this.validValues;
    }
}

