/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.InviteCommand;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;

public class InviteEncoder
implements CommandEncoder {
    public static final String COMMAND_PREFIX = "INVITE\t";
    private final ChatServerConnection client;

    public InviteEncoder(ChatServerConnection client) {
        this.client = client;
    }

    @Override
    public Command decode(String s) {
        if (!s.startsWith(COMMAND_PREFIX)) {
            return null;
        }
        String[] info = s.split("\\t");
        if (info.length != 4) {
            return null;
        }
        return new InviteCommand(info[1], info[2], info[3], this.client);
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof InviteCommand)) {
            return null;
        }
        InviteCommand cmd = (InviteCommand)c;
        return COMMAND_PREFIX + cmd.getPlayer() + "\t" + cmd.getPlayerId() + "\t" + cmd.getRoom();
    }
}

