/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.MsgSender;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.logging.Logger;

public class Node
implements MsgSender {
    private static final Logger logger = Logger.getLogger(MsgSender.class.getName());
    private final String id;
    private String info;
    private Node parent;
    private final List<Node> children = new ArrayList<Node>();

    public Node(Node parent, String id, String info) {
        this.parent = parent;
        this.id = id;
        this.info = info;
    }

    public String getId() {
        return this.id;
    }

    public String getInfo() {
        return this.info;
    }

    public String getInfoProperty(String propName) {
        try {
            return new PropertiesEncoder(this.info).getProperties().getProperty(propName);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Node getParent() {
        return this.parent;
    }

    public void remove(Node child) {
        logger.finer("Removing " + child + " from " + this);
        this.children.remove(child);
    }

    public void add(Node child) {
        Objects.requireNonNull(child);
        if (child.parent != null) {
            child.parent.remove(child);
        }
        logger.finer("Adding " + child + " to " + this);
        this.children.add(child);
        child.setParent(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.id, node.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return super.toString() + "[id=" + this.id + "]";
    }

    public Node getChild(String id) {
        for (Node n : this.getChildren()) {
            if (!id.equals(n.getId())) continue;
            return n;
        }
        return null;
    }

    public Node getDescendant(String path) {
        String id;
        Node n;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(path, '/');
        for (n = this; st.hasMoreTokens() && n != null; n = n.getChild(id)) {
            id = st.nextToken();
        }
        return n;
    }

    @Override
    public void send(String msg) {
        for (Node n : this.getChildren()) {
            n.send(msg);
        }
    }

    public Node[] getLeafDescendants() {
        ArrayList<Node> l = new ArrayList<Node>();
        this.addLeaves(this, l);
        return l.toArray(new Node[0]);
    }

    private void addLeaves(Node base, List<Node> l) {
        if (base.isLeaf()) {
            l.add(base);
        } else {
            for (Node n : base.getChildren()) {
                this.addLeaves(n, l);
            }
        }
    }

    public boolean isLeaf() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node[] getChildren() {
        List<Node> list = this.children;
        synchronized (list) {
            return this.children.toArray(new Node[0]);
        }
    }

    public static Node build(Node base, String path) {
        Node node = null;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(path, '/');
        while (st.hasMoreTokens()) {
            String childId = st.nextToken();
            node = base.getChild(childId);
            if (node == null) {
                node = new Node(base, childId, null);
                base.add(node);
            }
            base = node;
        }
        return node;
    }

    public Node buildWithInfo(Node base, String pathAndInfo) {
        Node node = null;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(pathAndInfo, '/');
        while (st.hasMoreTokens()) {
            SequenceEncoder.Decoder st2 = new SequenceEncoder.Decoder(st.nextToken(), '=');
            String childId = st2.nextToken();
            String childInfo = st2.nextToken();
            node = base.getChild(childId);
            if (node == null) {
                node = new Node(base, childId, null);
                base.add(node);
            }
            node.setInfo(childInfo);
            base = node;
        }
        return node;
    }

    private List<Node> getPathList() {
        ArrayList<Node> path = new ArrayList<Node>();
        for (Node n = this; n != null && n.getId() != null; n = n.getParent()) {
            path.add(n);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath() {
        List<Node> list = this.children;
        synchronized (list) {
            SequenceEncoder se = new SequenceEncoder('/');
            List<Node> path = this.getPathList();
            ListIterator<Node> i = path.listIterator(path.size());
            while (i.hasPrevious()) {
                se.append(i.previous().getId());
            }
            return se.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPathAndInfo() {
        List<Node> list = this.children;
        synchronized (list) {
            SequenceEncoder se = new SequenceEncoder('/');
            List<Node> path = this.getPathList();
            ListIterator<Node> i = path.listIterator(path.size() - 1);
            while (i.hasPrevious()) {
                Node n = i.previous();
                SequenceEncoder se2 = new SequenceEncoder(n.getId(), '=').append(n.getInfo());
                se.append(se2.getValue());
            }
            return se.getValue();
        }
    }
}

