/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Room;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;

public class TextClient {
    private final ChatServerConnection client;

    public TextClient(ChatServerConnection client) {
        this.client = client;
        client.addPropertyChangeListener("AvailableRooms", this::availableRoomsChanged);
        client.addPropertyChangeListener("Msg", this::incomingMessageReceived);
        client.addPropertyChangeListener("Status", this::statusReceived);
        client.setConnected(true);
    }

    public ChatServerConnection getClient() {
        return this.client;
    }

    private void statusReceived(PropertyChangeEvent evt) {
        System.out.println(evt.getNewValue());
    }

    private void incomingMessageReceived(PropertyChangeEvent evt) {
        String msg = (String)evt.getNewValue();
        if (msg.startsWith("CHAT")) {
            System.out.println(msg.substring(4));
        }
    }

    private void availableRoomsChanged(PropertyChangeEvent evt) {
        System.out.println("----------" + new Date() + "---------");
        System.out.print(TextClient.report((Room[])evt.getNewValue()));
    }

    public static String report(Room[] r) {
        StringBuilder buffer = new StringBuilder();
        for (Room room : r) {
            buffer.append(room.getName()).append(": ").append(room.getPlayerList().stream().map(Objects::toString).collect(Collectors.joining(", "))).append('\n');
        }
        return buffer.toString();
    }

    public static class Encoder
    implements CommandEncoder {
        private static final String SERIALIZATION_PREFIX = "CHAT";

        @Override
        public Command decode(String command) {
            if (!command.startsWith(SERIALIZATION_PREFIX)) {
                return null;
            }
            return new ShowText(command.substring(SERIALIZATION_PREFIX.length()));
        }

        @Override
        public String encode(Command c) {
            if (!(c instanceof ShowText)) {
                return null;
            }
            return SERIALIZATION_PREFIX + ((ShowText)c).getMessage();
        }
    }

    public static class ShowText
    extends Command {
        private final String msg;

        public ShowText(String msg) {
            this.msg = msg;
        }

        public String getMessage() {
            return this.msg;
        }

        @Override
        protected void executeCommand() {
            System.out.println(this.msg);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

