/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Room;
import VASSAL.chat.ServerAddressBook;
import VASSAL.chat.ui.BasicChatControlsInitializer;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.RoomTree;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.VisibilityOption;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.SplitPane;
import VASSAL.tools.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;

public class ChatServerControls
extends AbstractBuildable {
    protected RoomTree currentRoom;
    protected JTextField newRoom;
    protected JLabel newRoomLabel;
    protected JToolBar toolbar;
    protected RoomTree roomTree;
    protected JButton newRoomButton;
    protected JButton launch;
    protected ChatServerConnection client;
    protected JPanel controlPanel;
    protected ChatControlsInitializer oldClient;
    protected BasicChatControlsInitializer basicControls;
    protected JButton configServerButton;
    protected String configServerText;
    @Deprecated(since="2020-11-15", forRemoval=true)
    protected ComponentSplitter.SplitPane splitter;
    protected SplitPane splitPane;

    public ChatServerControls() {
        JSplitPane split = new JSplitPane(1);
        split.setResizeWeight(0.5);
        JPanel roomPanel = new JPanel((LayoutManager)new MigLayout("fill, nogrid, hidemode 3"));
        roomPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), Resources.getString("Chat.active_games")));
        this.newRoom = new JTextField(12);
        this.newRoomLabel = new JLabel(Resources.getString("Chat.new_game"));
        this.newRoomLabel.setLabelFor(this.newRoom);
        roomPanel.add((Component)this.newRoomLabel, "");
        roomPanel.add((Component)this.newRoom, "growx, pushx");
        this.newRoomButton = new JButton("...");
        this.newRoomButton.setPreferredSize(new Dimension(20, 20));
        this.newRoomButton.setVisible(false);
        roomPanel.add((Component)this.newRoomButton, "hidemode 3");
        this.roomTree = new RoomTree();
        JScrollPane roomScroll = new JScrollPane(this.roomTree);
        roomPanel.add((Component)roomScroll, "newline, spanx, grow, push");
        split.setLeftComponent(roomPanel);
        this.currentRoom = new RoomTree();
        this.currentRoom.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
                throw new ExpandVetoException(evt);
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
            }
        });
        JScrollPane scroll = new JScrollPane(this.currentRoom);
        scroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), Resources.getString("Chat.current_game")));
        split.setRightComponent(scroll);
        split.setDividerLocation(160);
        split.setPreferredSize(new Dimension(320, 120));
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BorderLayout());
        this.controlPanel.add("Center", split);
        this.toolbar = new JToolBar();
        this.controlPanel.add("North", this.toolbar);
        this.toolbar.addSeparator();
        this.configServerButton = new JButton();
        this.configServerButton.addActionListener(e -> ServerAddressBook.editCurrentServer(!this.client.isConnected()));
        this.configServerButton.addMouseListener(new MouseAdapter(){

            private void maybePopup(MouseEvent e) {
                if (!ChatServerControls.this.client.isConnected() && e.isPopupTrigger()) {
                    ChatServerControls.this.showChangeServerMenu();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybePopup(e);
            }
        });
        this.toolbar.add(this.configServerButton);
    }

    private void showChangeServerMenu() {
        ServerAddressBook.changeServerPopup(this.configServerButton);
    }

    public void updateClientDisplay(Icon icon, String text) {
        this.configServerButton.setIcon(icon);
        this.configServerText = text;
        this.updateConfigServerToolTipText();
    }

    private void updateConfigServerToolTipText() {
        if (this.client.isConnected()) {
            this.configServerButton.setToolTipText(this.configServerText);
        } else {
            this.configServerButton.setToolTipText("<html><center>" + this.configServerText + "<br>" + Resources.getString("Chat.change_server"));
        }
    }

    public Component getExtendedControls() {
        return null;
    }

    @Override
    public void addTo(Buildable b) {
        GameModule gm = GameModule.getGameModule();
        this.setClient((ChatServerConnection)gm.getServer());
        this.launch = new JButton(Resources.getString("Chat.server"));
        this.launch.setFocusable(false);
        this.launch.setAlignmentY(0.0f);
        ActionListener al = evt -> this.toggleVisible();
        this.launch.addActionListener(al);
        NamedKeyStrokeListener l = new NamedKeyStrokeListener(al);
        l.setKeyStroke(NamedKeyStroke.of(83, 512));
        URL iconURL = this.getClass().getResource("/images/connect.gif");
        if (iconURL != null) {
            this.launch.setIcon(new ImageIcon(iconURL));
            this.launch.setText(null);
        }
        IconConfigurer iconConfig = new IconConfigurer("serverControlsIcon", Resources.getString("Chat.server_controls_button_icon"), "/images/connect.gif");
        iconConfig.setValue("/images/connect.gif");
        GlobalOptions.getInstance().addOption(iconConfig);
        iconConfig.addPropertyChangeListener(evt -> this.launch.setIcon(iconConfig.getIconValue()));
        iconConfig.fireUpdate();
        NamedHotKeyConfigurer keyConfig = new NamedHotKeyConfigurer("serverControlsHotKey", Resources.getString("Chat.server_controls_hotkey"), l.getNamedKeyStroke());
        GlobalOptions.getInstance().addOption(keyConfig);
        keyConfig.addPropertyChangeListener(evt -> {
            l.setKeyStroke(keyConfig.getValueNamedKeyStroke());
            this.launch.setToolTipText(Resources.getString("Chat.server_controls_tooltip", NamedHotKeyConfigurer.getString(l.getKeyStroke())));
        });
        keyConfig.fireUpdate();
        gm.addKeyStrokeListener(l);
        gm.getToolBar().add(this.launch);
    }

    public void toggleVisible() {
        if (this.controlPanel.getTopLevelAncestor() == null) {
            if (GlobalOptions.getInstance().isUseSingleWindow()) {
                JComponent gmcp = GameModule.getGameModule().getControlPanel();
                Container gmcppar = gmcp.getParent();
                int i = SwingUtils.getIndexInParent(gmcp, gmcppar);
                this.splitPane = new SplitPane(1, gmcp, this.controlPanel);
                this.splitPane.setResizeWeight(1.0);
                gmcppar.add((Component)this.splitPane, i);
            } else {
                JFrame frame = new JFrame(Resources.getString("Chat.server"));
                frame.setDefaultCloseOperation(1);
                frame.add(this.controlPanel);
                frame.setJMenuBar(MenuManager.getInstance().getMenuBarFor(frame));
                String key = "BoundsOfClientWindow";
                VisibilityOption pos = new VisibilityOption("BoundsOfClientWindow", frame);
                GameModule.getGameModule().getPrefs().addOption(pos);
                frame.setVisible(true);
            }
        } else if (this.splitPane != null) {
            this.splitPane.toggleRight();
        } else {
            this.controlPanel.getTopLevelAncestor().setVisible(!this.controlPanel.getTopLevelAncestor().isVisible());
        }
    }

    public JPanel getControls() {
        return this.controlPanel;
    }

    public void setClient(ChatServerConnection c) {
        this.client = c;
        if (c instanceof ChatControlsInitializer) {
            if (this.basicControls != null) {
                this.basicControls.uninitializeControls(this);
            }
            if (this.oldClient != null) {
                this.oldClient.uninitializeControls(this);
            }
            this.basicControls = new BasicChatControlsInitializer(c);
            this.basicControls.initializeControls(this);
            ((ChatControlsInitializer)((Object)c)).initializeControls(this);
            this.oldClient = (ChatControlsInitializer)((Object)c);
        }
        PropertyChangeListener roomUpdater = evt -> {
            Runnable runnable = () -> this.roomTree.setRooms((Room[])evt.getNewValue());
            SwingUtilities.invokeLater(runnable);
        };
        this.client.addPropertyChangeListener("AvailableRooms", roomUpdater);
        PropertyChangeListener currentRoomUpdater = evt -> {
            Runnable runnable = () -> {
                if (evt.getNewValue() == null) {
                    this.currentRoom.setRooms(new Room[0]);
                } else {
                    this.currentRoom.setRooms(new Room[]{(Room)evt.getNewValue()});
                    Object root = this.currentRoom.getModel().getRoot();
                    Object room = this.currentRoom.getModel().getChild(root, 0);
                    this.currentRoom.expandPath(new TreePath(new Object[]{root, room}));
                }
            };
            SwingUtilities.invokeLater(runnable);
        };
        this.client.addPropertyChangeListener("Room", currentRoomUpdater);
        this.client.addPropertyChangeListener("Connected", e -> this.updateConfigServerToolTipText());
    }

    public ChatServerConnection getClient() {
        return this.client;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public void setAttribute(String name, Object value) {
    }

    @Override
    public String getAttributeValueString(String name) {
        return null;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public RoomTree getCurrentRoom() {
        return this.currentRoom;
    }

    public JTextField getNewRoom() {
        return this.newRoom;
    }

    public void addExtendedNewRoomHandler(ActionListener l) {
        this.newRoomButton.addActionListener(l);
        this.newRoomButton.setVisible(true);
    }

    public void removeExtendedNewRoomHandler(ActionListener l) {
        this.newRoomButton.removeActionListener(l);
        this.newRoomButton.setVisible(false);
    }

    public void setRoomControlsVisible(boolean visible) {
        this.newRoom.setVisible(visible);
        this.newRoomLabel.setVisible(visible);
    }

    public RoomTree getRoomTree() {
        return this.roomTree;
    }
}

