/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.ui.RoomTreeRenderer;
import VASSAL.i18n.Resources;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class RoomTree
extends JTree {
    private static final long serialVersionUID = 1L;
    protected DefaultTreeModel model;
    protected DefaultMutableTreeNode root;

    public RoomTree() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.root = new DefaultMutableTreeNode(Resources.getString("Chat.server"));
        this.model = new DefaultTreeModel(this.root){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isLeaf(Object node) {
                return ((DefaultMutableTreeNode)node).getUserObject() instanceof Player;
            }
        };
        this.setModel(this.model);
        this.setCellRenderer(new RoomTreeRenderer());
    }

    public synchronized void setRooms(Room[] room) {
        int i;
        if (room == null) {
            room = new Room[]{};
        }
        for (i = 0; i < this.root.getChildCount(); ++i) {
            Room r = this.roomAt(i);
            int j = 0;
            for (j = 0; j < room.length && room[j] != r; ++j) {
                if (!room[j].equals(r)) continue;
                this.model.valueForPathChanged(new TreePath(((DefaultMutableTreeNode)this.root.getChildAt(i)).getPath()), room[j]);
                break;
            }
            if (j < room.length) continue;
            this.model.removeNodeFromParent((DefaultMutableTreeNode)this.root.getChildAt(i--));
        }
        for (i = 0; i < room.length; ++i) {
            int j;
            for (j = 0; j < this.root.getChildCount() && this.roomAt(j) != room[i]; ++j) {
            }
            if (j < this.root.getChildCount()) continue;
            this.model.insertNodeInto(new DefaultMutableTreeNode(room[i]), this.root, i);
        }
        for (i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            List<Player> p = this.roomAt(i).getPlayerList();
            while (p.size() < node.getChildCount()) {
                this.model.removeNodeFromParent((DefaultMutableTreeNode)node.getChildAt(0));
            }
            while (p.size() > node.getChildCount()) {
                this.model.insertNodeInto(new DefaultMutableTreeNode(room[i]), node, 0);
            }
            for (int j = 0; j < node.getChildCount(); ++j) {
                this.model.valueForPathChanged(new TreePath(((DefaultMutableTreeNode)node.getChildAt(j)).getPath()), p.get(j));
            }
        }
    }

    protected Room roomAt(int index) {
        return (Room)((DefaultMutableTreeNode)this.root.getChildAt(index)).getUserObject();
    }
}

