/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.map.HighlightLastMoved;
import VASSAL.command.Command;
import VASSAL.command.RemovePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.Stack;

public class AddPiece
extends Command {
    private Command undo;
    private final GamePiece target;
    private final String state;

    public AddPiece(GamePiece p) {
        this(p, p.getState());
    }

    public AddPiece(GamePiece p, String state) {
        this.target = p;
        this.state = state;
    }

    @Override
    protected void executeCommand() {
        if (this.target != null) {
            GameModule.getGameModule().getGameState().addPiece(this.target);
            this.target.setState(this.state);
            if (this.target.getMap() != null) {
                HighlightLastMoved.setLastMoved(this.target);
                if (GlobalOptions.getInstance().centerOnOpponentsMove() && !Boolean.TRUE.equals(this.target.getProperty("Invisible"))) {
                    if (this.target instanceof Stack && !((Stack)this.target).asList().stream().anyMatch(PieceIterator.VISIBLE)) {
                        return;
                    }
                    this.target.getMap().ensureVisible(this.target.getMap().selectionBoundsOf(this.target));
                    this.target.getMap().repaint();
                }
            }
        }
    }

    @Override
    protected Command myUndoCommand() {
        if (this.undo == null) {
            this.undo = new RemovePiece(this.target);
        }
        return this.undo;
    }

    public GamePiece getTarget() {
        return this.target;
    }

    public String getState() {
        return this.state;
    }
}

