/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.ConfigurableList;
import VASSAL.configure.ConfigurableListEntry;
import VASSAL.configure.Configurer;
import VASSAL.configure.NoInsetButton;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;

public abstract class AbstractConfigurableListEntry
implements ConfigurableListEntry {
    private final ConfigurableList parent;
    private JButton removeButton;
    private Configurer configurer;
    private final Object savedValue;
    private final int iconSize;

    public AbstractConfigurableListEntry(ConfigurableList parentConfig, Object value, int iconSize) {
        this.parent = parentConfig;
        this.savedValue = value;
        this.iconSize = iconSize;
    }

    public AbstractConfigurableListEntry(ConfigurableList parentConfig, Object value) {
        this(parentConfig, value, 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.parent.entryChanged(this);
        this.updateVisibility();
    }

    public abstract Configurer buildChildConfigurer(Object var1);

    public ConfigurableList getParent() {
        return this.parent;
    }

    @Override
    public JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new NoInsetButton("no", this.iconSize, "Editor.ConfigurableListEntryController.remove_button_tip");
            this.removeButton.addActionListener(e -> this.parent.deleteEntry(this));
        }
        return this.removeButton;
    }

    @Override
    public Configurer getConfigurer() {
        if (this.configurer == null) {
            this.configurer = this.buildChildConfigurer(this.savedValue);
            this.configurer.addPropertyChangeListener(e -> this.updateVisibility());
            this.addPropertyChangeListener(this);
            FocusListener fl = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    AbstractConfigurableListEntry.this.focusGained();
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            };
            this.configurer.addFocusListener(fl);
        }
        return this.configurer;
    }

    @Override
    public void focusGained() {
        this.getParent().selectEntry(this);
    }

    @Override
    public void requestFocus() {
        this.getConfigurer().requestFocus();
    }

    @Override
    public void updateVisibility() {
    }

    @Override
    public abstract void setHighlighted(boolean var1);
}

