/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.PropertyNameSource;
import VASSAL.configure.BeanShellExpressionConfigurer;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.FunctionBuilder;
import VASSAL.script.expression.IntBuilder;
import VASSAL.script.expression.StrBuilder;
import VASSAL.tools.menu.MenuScroller;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class BeanShellFunctionMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    protected static final String[] SUM_COUNT_HINTS = new String[]{Resources.getString("Editor.BeanShell.warning"), Resources.getString("Editor.BeanShell.warning2"), Resources.getString("Editor.BeanShell.warning3")};
    protected static final String[] SUM_COUNT_MAP_HINTS = new String[]{Resources.getString("Editor.BeanShell.warning"), Resources.getString("Editor.BeanShell.map_warning"), Resources.getString("Editor.BeanShell.warning2"), Resources.getString("Editor.BeanShell.warning3")};
    protected static int maxScrollItems = 0;
    protected BeanShellExpressionConfigurer configurer;
    protected EditablePiece target;

    public BeanShellFunctionMenu(EditablePiece target, BeanShellExpressionConfigurer configurer) {
        this.target = target;
        this.configurer = configurer;
        JMenu constantMenu = new JMenu(Resources.getString("Editor.BeanShell.constant"));
        JMenuItem integerItem = new JMenuItem(Resources.getString("Editor.BeanShell.number"));
        integerItem.setToolTipText(Resources.getString("Editor.BeanShell.a_number"));
        integerItem.addActionListener(e -> this.buildInteger());
        constantMenu.add(integerItem);
        JMenuItem stringItem = new JMenuItem(Resources.getString("Editor.BeanShell.string"));
        stringItem.setToolTipText(Resources.getString("Editor.BeanShell.a_string"));
        stringItem.addActionListener(e -> this.buildString());
        constantMenu.add(stringItem);
        this.add(constantMenu);
        JMenu propertyMenu = new JMenu(Resources.getString("Editor.BeanShell.property"));
        if (target != null) {
            JMenu pieceMenu = new JMenu(Resources.getString("Editor.BeanShell.piece_property"));
            this.addProp(pieceMenu, "Moved");
            this.addProp(pieceMenu, "Selected");
            this.addProp(pieceMenu, "PieceId");
            this.addPieceProps(pieceMenu, target);
            propertyMenu.add(pieceMenu);
        }
        JMenu globalsMenu = new JMenu(Resources.getString("Editor.BeanShell.global_property"));
        this.buildGlobalMenu(globalsMenu, GameModule.getGameModule(), true);
        MenuScroller.setScrollerFor(globalsMenu, this.getMaxScrollItems(), 100);
        propertyMenu.add(globalsMenu);
        JMenu vassalMenu = new JMenu(Resources.getString("Editor.BeanShell.vassal_property"));
        this.addProp(vassalMenu, "PlayerSide");
        this.addProp(vassalMenu, "PlayerName");
        this.addProp(vassalMenu, "PlayerId");
        propertyMenu.add(vassalMenu);
        this.add(propertyMenu);
        JMenu operatorMenu = new JMenu(Resources.getString("Editor.BeanShell.operator"));
        this.addOperator(operatorMenu, "+", Resources.getString("Editor.BeanShell.add"));
        this.addOperator(operatorMenu, "-", Resources.getString("Editor.BeanShell.subtract"));
        this.addOperator(operatorMenu, "*", Resources.getString("Editor.BeanShell.multiply"));
        this.addOperator(operatorMenu, "/", Resources.getString("Editor.BeanShell.divide"));
        this.addOperator(operatorMenu, "%", Resources.getString("Editor.BeanShell.modulus"));
        this.add(operatorMenu);
        JMenu comparisonMenu = new JMenu(Resources.getString("Editor.BeanShell.comparison"));
        this.addOperator(comparisonMenu, "==", Resources.getString("Editor.BeanShell.equals"));
        this.addOperator(comparisonMenu, "!=", Resources.getString("Editor.BeanShell.not_equals"));
        this.addOperator(comparisonMenu, ">", Resources.getString("Editor.BeanShell.greater_than"));
        this.addOperator(comparisonMenu, ">=", Resources.getString("Editor.BeanShell.greater_than_or_equal_to"));
        this.addOperator(comparisonMenu, "<", Resources.getString("Editor.BeanShell.less_than"));
        this.addOperator(comparisonMenu, "<=", Resources.getString("Editor.BeanShell.less_than_or_equal_to"));
        this.addOperator(comparisonMenu, "=~", Resources.getString("Editor.BeanShell.matches_regular_expression"));
        this.addOperator(comparisonMenu, "!~", Resources.getString("Editor.BeanShell.does_not_match_regular_expression"));
        this.add(comparisonMenu);
        JMenu logicalMenu = new JMenu(Resources.getString("Editor.BeanShell.logical"));
        this.addOperator(logicalMenu, "&&", Resources.getString("Editor.BeanShell.and"));
        this.addOperator(logicalMenu, "||", Resources.getString("Editor.BeanShell.or"));
        this.addOperator(logicalMenu, "!", Resources.getString("Editor.BeanShell.not"));
        this.addOperator(logicalMenu, "(", Resources.getString("Editor.BeanShell.left_parenthesis"));
        this.addOperator(logicalMenu, ")", Resources.getString("Editor.BeanShell.right_parenthesis"));
        this.add(logicalMenu);
        JMenu mathMenu = new JMenu(Resources.getString("Editor.BeanShell.math"));
        this.addFunction(mathMenu, "Math.abs", Resources.getString("Editor.BeanShell.abs"), new String[]{Resources.getString("Editor.BeanShell.number")}, "(n)");
        this.addFunction(mathMenu, "Math.min", Resources.getString("Editor.BeanShell.min"), new String[]{Resources.getString("Editor.BeanShell.number1"), Resources.getString("Editor.BeanShell.number2")}, "(m, n)");
        this.addFunction(mathMenu, "Math.max", Resources.getString("Editor.BeanShell.max"), new String[]{Resources.getString("Editor.BeanShell.number1"), Resources.getString("Editor.BeanShell.number2")}, "(m, n)");
        JMenu propMenu = new JMenu(Resources.getString("Editor.BeanShell.property"));
        this.addFunction(propMenu, "GetProperty", Resources.getString("Editor.BeanShell.getproperty"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)");
        this.addFunction(propMenu, "GetMapProperty", Resources.getString("Editor.BeanShell.getmapproperty"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.map_name")}, "(prop, map)");
        this.addFunction(propMenu, "GetZoneProperty", Resources.getString("Editor.BeanShell.getzoneproperty"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.zone_name")}, "(prop, zone)");
        this.addFunction(propMenu, "GetZoneProperty", Resources.getString("Editor.BeanShell.getzonemapproperty"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.zone_name"), Resources.getString("Editor.BeanShell.map_name")}, "(prop, zone, map)");
        JMenu stringMenu = new JMenu(Resources.getString("Editor.BeanShell.string"));
        this.addFunction(stringMenu, ".length", Resources.getString("Editor.BeanShell.Slength"), new String[]{Resources.getString("Editor.BeanShell.target_string")}, "()");
        this.addFunction(stringMenu, ".contains", Resources.getString("Editor.BeanShell.Scontains"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.search_string")}, "(string)");
        this.addFunction(stringMenu, ".startsWith", Resources.getString("Editor.BeanShell.Sstartswith"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.search_string")}, "(string)");
        this.addFunction(stringMenu, ".endsWith", Resources.getString("Editor.BeanShell.Sendswith"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.search_string")}, "(string)");
        this.addFunction(stringMenu, ".matches", Resources.getString("Editor.BeanShell.Smatches"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.regex")}, "(regExpr)");
        this.addFunction(stringMenu, ".indexOf", Resources.getString("Editor.BeanShell.Sindexof"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.search_string")}, "(string)");
        this.addFunction(stringMenu, ".lastIndexOf", Resources.getString("Editor.BeanShell.Slastindexof"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.search_string")}, "(string)");
        this.addFunction(stringMenu, ".substring", Resources.getString("Editor.BeanShell.Ssubstring"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.starting_position")}, "(start)");
        this.addFunction(stringMenu, ".substring", Resources.getString("Editor.BeanShell.Ssubstring2"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.starting_position"), Resources.getString("Editor.BeanShell.ending_position")}, "(start, end)");
        this.addFunction(stringMenu, ".replace", Resources.getString("Editor.BeanShell.Sreplace"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.to_find"), Resources.getString("Editor.BeanShell.to_replace")}, "(old, new)");
        JMenu randomMenu = new JMenu(Resources.getString("Editor.BeanShell.random"));
        this.addFunction(randomMenu, "Random", Resources.getString("Editor.BeanShell.random1"), new String[]{Resources.getString("Editor.BeanShell.randomhi")}, "(x)");
        this.addFunction(randomMenu, "Random", Resources.getString("Editor.BeanShell.random2"), new String[]{Resources.getString("Editor.BeanShell.randomlo"), Resources.getString("Editor.BeanShell.randomhi")}, "(x, y)");
        this.addFunction(randomMenu, "IsRandom", Resources.getString("Editor.BeanShell.random3"), new String[0], "()");
        this.addFunction(randomMenu, "IsRandom", Resources.getString("Editor.BeanShell.random4"), new String[]{Resources.getString("Editor.BeanShell.randomp")}, "(p)");
        JMenu countMenu = new JMenu(Resources.getString("Editor.BeanShell.sumcount"));
        this.addFunction(countMenu, "SumStack", Resources.getString("Editor.BeanShell.sum1"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(name)");
        this.addFunction(countMenu, "CountStack", Resources.getString("Editor.BeanShell.sum6"), new String[0], "()");
        this.addFunction(countMenu, "CountStack", Resources.getString("Editor.BeanShell.sum7"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(name)");
        this.addFunction(countMenu, "Sum", Resources.getString("Editor.BeanShell.sum2"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(name, expr)", SUM_COUNT_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addFunction(countMenu, "Sum", Resources.getString("Editor.BeanShell.sum3"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression"), Resources.getString("Editor.BeanShell.map_name")}, "(name, expr, map)", SUM_COUNT_MAP_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME, BeanShellExpressionConfigurer.Option.NONE});
        this.addFunction(countMenu, "Count", Resources.getString("Editor.BeanShell.sum4"), new String[]{Resources.getString("Editor.BeanShell.property_match_expression")}, "(expr)", SUM_COUNT_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.PME});
        this.addFunction(countMenu, "Count", Resources.getString("Editor.BeanShell.sum5"), new String[]{Resources.getString("Editor.BeanShell.property_match_expression"), Resources.getString("Editor.BeanShell.map_name")}, "(expr, map)", SUM_COUNT_MAP_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.PME, BeanShellExpressionConfigurer.Option.NONE});
        JMenu functionMenu = new JMenu(Resources.getString("Editor.BeanShell.function"));
        functionMenu.add(mathMenu);
        functionMenu.add(propMenu);
        functionMenu.add(randomMenu);
        functionMenu.add(stringMenu);
        functionMenu.add(countMenu);
        this.addFunction(functionMenu, "?", Resources.getString("Editor.BeanShell.ternary"), new String[]{Resources.getString("Editor.BeanShell.logical_expression"), Resources.getString("Editor.BeanShell.if_true"), Resources.getString("Editor.BeanShell.if_false")}, "(expr ? r1 : r2)");
        this.addFunction(functionMenu, "Alert", Resources.getString("Editor.BeanShell.alert"), new String[]{Resources.getString("Editor.BeanShell.text_to_display")}, "(text)");
        this.add(functionMenu);
    }

    protected void addFunction(JMenu menu, String op, String desc, String[] parms, String parmInfo) {
        this.addFunction(menu, op, desc, parms, parmInfo, null);
    }

    protected void addFunction(JMenu menu, String op, String desc, String[] parms, String parmInfo, String[] hints) {
        BeanShellExpressionConfigurer.Option[] options = new BeanShellExpressionConfigurer.Option[parms.length];
        Arrays.fill((Object[])options, (Object)BeanShellExpressionConfigurer.Option.NONE);
        this.addFunction(menu, op, desc, parms, parmInfo, hints, options);
    }

    protected void addFunction(JMenu menu, String op, String desc, String[] parms, String parmInfo, String[] hints, BeanShellExpressionConfigurer.Option[] options) {
        JMenuItem item = new JMenuItem(op + (String)(parmInfo != null && parmInfo.length() == 0 ? "" : " " + parmInfo));
        item.setToolTipText(desc);
        item.addActionListener(e -> this.buildFunction(op, desc, parms, hints, options));
        menu.add(item);
    }

    protected void buildFunction(String op, String desc, String[] parmDesc, String[] hints, BeanShellExpressionConfigurer.Option[] options) {
        if (parmDesc.length == 0) {
            this.configurer.insertName(op + "()");
        } else {
            StringConfigurer result = new StringConfigurer(null, "", "");
            new FunctionBuilder(result, (JDialog)this.configurer.getTopLevelAncestor(), op, desc, parmDesc, this.target, hints, options, this.configurer.getSelectedText()).setVisible(true);
            if (result.getValue() != null && result.getValueString().length() > 0) {
                this.configurer.insertName(result.getValueString());
            }
        }
    }

    protected void buildInteger() {
        StringConfigurer result = new StringConfigurer(null, "", "");
        new IntBuilder(result, (JDialog)this.configurer.getTopLevelAncestor()).setVisible(true);
        if (result.getValue() != null && result.getValueString().length() > 0) {
            this.configurer.insertName(result.getValueString());
        }
    }

    protected void buildString() {
        StringConfigurer result = new StringConfigurer(null, "", "");
        new StrBuilder(result, (JDialog)this.configurer.getTopLevelAncestor()).setVisible(true);
        if (result.getValue() != null && result.getValueString().length() > 0) {
            this.configurer.insertName(result.getValueString());
        }
    }

    protected void addOperator(JMenu menu, String op, String desc) {
        JMenuItem item = new JMenuItem(op);
        item.setToolTipText(desc);
        item.addActionListener(e -> this.configurer.insertName(op));
        menu.add(item);
    }

    protected void addProp(JMenu menu, String propName) {
        this.addProp(menu, propName, false);
    }

    protected void addProp(JMenu menu, String propName, boolean sort) {
        if (propName == null) {
            return;
        }
        JMenuItem item = new JMenuItem(propName);
        item.addActionListener(e -> this.configurer.insertPropertyName(propName));
        if (sort) {
            int pos = -1;
            for (int i = 0; i < menu.getItemCount() && pos < 0; ++i) {
                if (propName.compareTo(menu.getItem(i).getText()) > 0) continue;
                pos = i;
            }
            menu.add((Component)item, pos);
        } else {
            menu.add(item);
        }
    }

    protected void addPieceProps(JMenu menu, EditablePiece piece) {
        if (piece == null) {
            return;
        }
        JMenu pieceMenu = null;
        if (piece instanceof PropertyNameSource) {
            List<String> propNames = ((PropertyNameSource)((Object)piece)).getPropertyNames();
            for (String propName : propNames) {
                if (pieceMenu == null) {
                    pieceMenu = new JMenu();
                    pieceMenu.setText(piece.getDescription());
                }
                JMenuItem item = new JMenuItem(propName);
                item.addActionListener(e -> this.configurer.insertPropertyName(((JMenuItem)e.getSource()).getText()));
                pieceMenu.add(item);
            }
            if (pieceMenu != null) {
                menu.add(pieceMenu);
            }
            if (piece instanceof Decorator) {
                this.addPieceProps(menu, (EditablePiece)((Decorator)piece).getInner());
            }
        }
    }

    protected void buildGlobalMenu(JMenu parentMenu, AbstractBuildable target, boolean useParentMenu) {
        String n;
        List<Buildable> buildables = target.getBuildables();
        Object menuName = ConfigureTree.getConfigureName(target.getClass());
        if (target instanceof AbstractConfigurable && (n = ((AbstractConfigurable)target).getConfigureName()) != null && n.length() > 0) {
            menuName = (String)menuName + " " + n;
        }
        JMenu myMenu = new JMenu((String)menuName);
        List<String> propNames = target.getPropertyNames();
        for (String propName : propNames) {
            this.addProp(useParentMenu ? parentMenu : myMenu, propName, true);
        }
        for (Buildable b : buildables) {
            if (b instanceof AbstractConfigurable) {
                boolean useParent = b instanceof GlobalProperties || b instanceof Board || b instanceof ZonedGrid;
                this.buildGlobalMenu(useParentMenu ? parentMenu : myMenu, (AbstractConfigurable)b, useParent);
                continue;
            }
            if (!(b instanceof BoardPicker)) continue;
            this.buildGlobalMenu(myMenu, (AbstractBuildable)b, true);
        }
        if (!useParentMenu && myMenu.getItemCount() > 0) {
            MenuScroller.setScrollerFor(myMenu, this.getMaxScrollItems(), 100);
            int pos = -1;
            for (int i = 0; i < parentMenu.getItemCount() && pos < 0; ++i) {
                if (myMenu.getText().compareTo(parentMenu.getItem(i).getText()) > 0) continue;
                pos = i;
            }
            parentMenu.add((Component)myMenu, pos);
        }
    }

    protected int getMaxScrollItems() {
        if (maxScrollItems == 0) {
            Dimension itemSize = new JMenuItem("Testing").getPreferredSize();
            maxScrollItems = (int)(0.98 * (double)SwingUtils.getScreenBounds((Component)this.configurer.getControls()).height / (double)itemSize.height);
        }
        return maxScrollItems;
    }
}

