/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.ValidationReport;
import VASSAL.i18n.Resources;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ValidationReportDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final CallBack callback;

    public ValidationReportDialog(ValidationReport report, CallBack cb) {
        super((Frame)GameModule.getGameModule().getPlayerWindow(), false);
        this.setTitle(Resources.getString("Editor.ValidationReportDialog.problems"));
        this.setLayout((LayoutManager)new MigLayout("ins panel", "[fill,grow]"));
        this.callback = cb;
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("", "push[]rel[]push"));
        List<String> warnings = report.getWarnings();
        switch (warnings.size()) {
            case 0: {
                this.add((Component)new JLabel(Resources.getString("Editor.ValidationReportDialog.no_problems")), "wrap");
                buttonPanel.add(this.createOkButton());
                break;
            }
            default: {
                this.add((Component)new JLabel(Resources.getString("Editor.ValidationReportDialog.following_problems")), "wrap");
                this.add((Component)new JLabel(Resources.getString("Editor.ValidationReportDialog.danger_will_robinson")), "wrap");
                JList<String> list = new JList<String>(warnings.toArray(new String[0]));
                list.setVisibleRowCount(Math.min(list.getVisibleRowCount(), warnings.size()));
                this.add((Component)new ScrollPane(list), "wrap");
                buttonPanel.add((Component)this.createOkButton(), "sg 1, tag ok");
                buttonPanel.add((Component)this.createCancelButton(), "sg 1, tag cancel");
            }
        }
        this.add(buttonPanel);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JButton createCancelButton() {
        JButton cancel = new JButton(Resources.getString("General.cancel"));
        cancel.addActionListener(e -> {
            this.callback.cancel();
            this.dispose();
        });
        return cancel;
    }

    private JButton createOkButton() {
        JButton ok = new JButton(Resources.getString("Editor.ValidationReportDialog.ignore"));
        ok.addActionListener(e -> {
            this.callback.ok();
            this.dispose();
        });
        return ok;
    }

    public static interface CallBack {
        public void ok();

        public void cancel();
    }
}

