/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.CardSlot;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.Embellishment;
import VASSAL.counters.GamePiece;
import VASSAL.counters.MultiImagePicker;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PlaceMarker;
import VASSAL.i18n.Resources;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.swing.Dialogs;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class MassPieceLoader {
    protected static final int DESC_COL = 0;
    protected static final int NAME_COL = 2;
    protected static final int IMAGE_COL = 1;
    protected static final int SKIP_COL = 3;
    protected static final int COPIES_COL = 4;
    protected static final int COLUMN_COUNT = 5;
    protected static final Color EDITABLE_COLOR = Color.blue;
    protected Configurable target;
    protected ConfigureTree configureTree;
    private final List<String> imageNames = new ArrayList<String>();
    private final List<String> baseImages = new ArrayList<String>();
    private final List<String> levelImages = new ArrayList<String>();
    private final Map<String, PieceInfo> pieceInfo = new HashMap<String, PieceInfo>();
    private final List<Emb> layers = new ArrayList<Emb>();
    protected MassLoaderDialog dialog;
    private static final DirectoryConfigurer dirConfig = new DirectoryConfigurer(null, "");
    private static final BooleanConfigurer basicConfig = new BooleanConfigurer(null, "", Boolean.FALSE);
    private static final BooleanConfigurer emptyLevelConfig = new BooleanConfigurer(null, "", Boolean.FALSE);
    private static final MassPieceDefiner definer = new MassPieceDefiner();
    protected static final String ENDS_WITH = "ends with";
    protected static final String INCLUDES = "includes";
    protected static final String MATCHES = "matches";
    protected static final String EQUALS = "same as";
    protected static final String BASE_IMAGE = "use Base Image";

    public MassPieceLoader(ConfigureTree tree, Configurable target) {
        this.target = target;
        this.configureTree = tree;
    }

    public void load() {
        this.dialog = new MassLoaderDialog();
        SwingUtils.ensureOnScreen(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.isCancelled()) {
            this.dialog.load();
        }
    }

    protected void addImageToModule(String name) {
        if (name != null && name.length() > 0) {
            try {
                GameModule.getGameModule().getArchiveWriter().addImage(new File(dirConfig.getFileValue(), name).getCanonicalPath(), name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getPieceName(String baseName) {
        PieceInfo info = this.pieceInfo.get(baseName);
        return info == null ? ImageUtils.stripImageSuffix(baseName) : info.getName();
    }

    class MassLoaderDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        protected boolean cancelled;
        protected DefineDialog defineDialog;
        protected MyTreeTable tree;
        protected MyTreeTableModel model;
        protected BasicNode root;
        protected File loadDirectory;

        public MassLoaderDialog() {
            super(MassPieceLoader.this.configureTree.getFrame());
            this.cancelled = false;
            this.setModal(true);
            this.setTitle(Resources.getString("Editor.MassPieceLoader.load_multiple"));
            this.setLayout((LayoutManager)new MigLayout("ins panel,wrap 2,gapy 4", "[right]rel[grow,fill]", "[][][][grow,fill][]"));
            this.setPreferredSize(new Dimension(800, 600));
            dirConfig.addPropertyChangeListener(e -> {
                if (e.getNewValue() != null) {
                    this.buildTree((File)e.getNewValue());
                }
            });
            this.add(new JLabel(Resources.getString("Editor.MassPieceLoader.image_directory")));
            this.add(dirConfig.getControls(), "grow");
            basicConfig.addPropertyChangeListener(e -> {
                if (e.getNewValue() != null) {
                    this.buildTree(dirConfig.getFileValue());
                }
            });
            this.add(new JLabel(Resources.getString("Editor.MassPieceLoader.no_basic_piece")));
            this.add(basicConfig.getControls());
            emptyLevelConfig.addPropertyChangeListener(e -> {
                if (e.getNewValue() != null) {
                    this.buildTree(dirConfig.getFileValue());
                }
            });
            this.add(new JLabel(Resources.getString("Editor.MassPieceLoader.no_empty_level")));
            this.add(emptyLevelConfig.getControls());
            this.defineDialog = new DefineDialog(this);
            JButton defineButton = new JButton(Resources.getString("Editor.MassPieceLoader.edit_piece_template"));
            defineButton.addActionListener(e -> {
                GamePiece savePiece = definer.getPiece();
                SwingUtils.ensureOnScreen(this.defineDialog);
                this.defineDialog.setVisible(true);
                if (this.defineDialog.isCancelled()) {
                    definer.setPiece(savePiece);
                } else {
                    this.buildTree(dirConfig.getFileValue());
                }
            });
            this.add((Component)defineButton, "skip 1,growx 0");
            this.tree = new MyTreeTable();
            this.buildTree(dirConfig.getFileValue());
            JScrollPane scrollPane = new JScrollPane((Component)((Object)this.tree));
            this.add((Component)scrollPane, "span 2,grow");
            JPanel buttonBox = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]push"));
            JButton okButton = new JButton(Resources.getString("General.ok"));
            okButton.addActionListener(e -> this.save());
            buttonBox.add(okButton);
            JButton cancelButton = new JButton(Resources.getString("General.cancel"));
            cancelButton.addActionListener(e -> this.cancel());
            buttonBox.add(cancelButton);
            JButton helpButton = new JButton(Resources.getString("General.help"));
            helpButton.addActionListener(e -> {
                HelpFile h = HelpFile.getReferenceManualPage("MassPieceLoader.html");
                BrowserSupport.openURL(h.getContents().toString());
            });
            buttonBox.add(helpButton);
            this.add((Component)buttonBox, "span 2,center,grow 0");
            this.pack();
            this.setLocationRelativeTo(this.getParent());
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    MassLoaderDialog.this.cancel();
                }
            });
        }

        public void cancel() {
            this.cancelled = true;
            this.dispose();
        }

        public void save() {
            int pieceCount = 0;
            for (int i = 0; i < this.root.getChildCount(); ++i) {
                PieceNode node = (PieceNode)this.root.getChildAt(i);
                if (node.isSkip()) continue;
                pieceCount += node.getCopies();
            }
            if (pieceCount > 0) {
                String message = Resources.getString("Editor.MassPieceLoader.this_will_load", pieceCount, MassPieceLoader.this.target.getConfigureName());
                int result = Dialogs.showConfirmDialog(null, Resources.getString("Editor.MassPieceLoader.confirm_load"), Resources.getString("Editor.MassPieceLoader.confirm_load"), message, 2, 1);
                if (result == 1) {
                    this.cancel();
                    return;
                }
                if (result == 2) {
                    return;
                }
            }
            this.cancelled = false;
            this.dispose();
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public File getDirectory() {
            return dirConfig.getFileValue();
        }

        protected void buildTree(File dir) {
            this.loadDirectory = dir;
            MassPieceLoader.this.layers.clear();
            GamePiece piece = definer.getPiece();
            while (piece instanceof Decorator) {
                if (!((piece = Decorator.getDecorator(piece, Emb.class)) instanceof Emb)) continue;
                MassPieceLoader.this.layers.add(0, (Emb)piece);
                piece = ((Emb)piece).getInner();
            }
            this.loadImageNames(dir);
            MassPieceLoader.this.baseImages.clear();
            MassPieceLoader.this.levelImages.clear();
            for (String imageName : MassPieceLoader.this.imageNames) {
                Emb emb;
                boolean match = false;
                Iterator<Emb> iterator = MassPieceLoader.this.layers.iterator();
                while (iterator.hasNext() && !(match = (emb = iterator.next()).matchLayer(imageName))) {
                }
                if (match) {
                    MassPieceLoader.this.levelImages.add(imageName);
                    continue;
                }
                MassPieceLoader.this.baseImages.add(imageName);
            }
            this.root = new BasicNode();
            for (String baseImage : MassPieceLoader.this.baseImages) {
                PieceNode pieceNode = new PieceNode(baseImage);
                for (Emb emb : MassPieceLoader.this.layers) {
                    Emb newLayer = new Emb(emb.getType(), null);
                    if (!newLayer.buildLayers(baseImage, MassPieceLoader.this.levelImages)) continue;
                    LayerNode layerNode = new LayerNode(newLayer.getLayerName());
                    for (int i = 0; i < newLayer.getImageNames().length; ++i) {
                        String levelName = newLayer.getLevelNames()[i];
                        LevelNode levelNode = new LevelNode(levelName == null ? "" : levelName, newLayer.getImageNames()[i], i);
                        layerNode.add((MutableTreeTableNode)levelNode);
                    }
                    pieceNode.add((MutableTreeTableNode)layerNode);
                }
                this.root.add((MutableTreeTableNode)pieceNode);
            }
            this.model = new MyTreeTableModel(this.root);
            this.tree.setTreeTableModel((TreeTableModel)this.model);
            TableColumnModel tcm = this.tree.getColumnModel();
            tcm.getColumn(0).setPreferredWidth(100);
            tcm.getColumn(0).setCellRenderer(new ImageNameRenderer());
            tcm.getColumn(2).setPreferredWidth(200);
            tcm.getColumn(2).setCellRenderer(new NameRenderer());
            tcm.getColumn(2).setCellEditor(new NameEditor(new JTextField()));
            tcm.getColumn(1).setPreferredWidth(200);
            tcm.getColumn(1).setCellRenderer(new ImageNameRenderer());
            tcm.getColumn(3).setPreferredWidth(50);
            tcm.getColumn(3).setMaxWidth(50);
            tcm.getColumn(4).setPreferredWidth(50);
            tcm.getColumn(4).setMaxWidth(50);
            tcm.getColumn(4).setCellRenderer(new CopiesRenderer());
        }

        protected void loadImageNames(File dir) {
            Object[] files;
            MassPieceLoader.this.imageNames.clear();
            if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
                Arrays.sort(files);
                for (Object file : files) {
                    String imageName = ((File)file).getName();
                    if (!ImageUtils.hasImageSuffix(imageName)) continue;
                    MassPieceLoader.this.imageNames.add(imageName);
                }
            }
        }

        public void load() {
            File dir = MassPieceLoader.this.dialog.getDirectory();
            if (dir == null) {
                return;
            }
            for (int i = 0; i < this.root.getChildCount(); ++i) {
                PieceNode pieceNode = (PieceNode)this.root.getChildAt(i);
                if (pieceNode.isSkip()) continue;
                this.load(pieceNode);
            }
        }

        public void load(PieceNode pieceNode) {
            String baseImage = pieceNode.getBaseImageName();
            MassPieceLoader.this.addImageToModule(baseImage);
            String basicType = new SequenceEncoder("", ';').append("").append(basicConfig.booleanValue() != false ? "" : baseImage).append(pieceNode.getName()).getValue();
            BasicPiece basic = (BasicPiece)GameModule.getGameModule().createPiece("piece;" + basicType);
            GamePiece template = definer.getPiece();
            ArrayList<Decorator> traits = new ArrayList<Decorator>();
            while (template instanceof Decorator) {
                traits.add(0, (Decorator)template);
                template = ((Decorator)template).getInner();
            }
            for (int count = 0; count < pieceNode.getCopies(); ++count) {
                GamePiece piece = basic;
                for (Decorator trait : traits) {
                    String saveState;
                    if (trait.getClass().equals(Emb.class)) {
                        Emb newLayer = new Emb(trait.myGetType(), null);
                        if (!newLayer.buildLayers(baseImage, MassPieceLoader.this.levelImages)) continue;
                        for (String image : newLayer.getBuiltImageList()) {
                            MassPieceLoader.this.addImageToModule(image);
                        }
                        newLayer.setInner(piece);
                        saveState = newLayer.getState();
                        piece = GameModule.getGameModule().createPiece(newLayer.getType());
                        piece.setState(saveState);
                        continue;
                    }
                    Decorator newTrait = (Decorator)GameModule.getGameModule().createPiece(trait.getType());
                    newTrait.setState(trait.getState());
                    newTrait.setInner(piece);
                    saveState = newTrait.getState();
                    piece = GameModule.getGameModule().createPiece(newTrait.getType());
                    piece.setState(saveState);
                }
                PieceSlot slot = null;
                Class[] c = MassPieceLoader.this.target.getAllowableConfigureComponents();
                for (int i = 0; i < c.length && slot == null; ++i) {
                    if (!c[i].equals(CardSlot.class)) continue;
                    slot = new CardSlot();
                    slot.setPiece(piece);
                }
                if (slot == null) {
                    slot = new PieceSlot(piece);
                }
                MassPieceLoader.this.configureTree.updateGpIds(slot);
                MassPieceLoader.this.configureTree.externalInsert(MassPieceLoader.this.target, slot);
            }
        }

        class ImageNameRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            ImageNameRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                DefaultTableCellRenderer c = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                BasicNode node = (BasicNode)((Object)MassLoaderDialog.this.tree.getPathForRow(row).getLastPathComponent());
                c.setEnabled(!node.isSkip());
                if (node instanceof PieceNode) {
                    String image = node.getImageName();
                    String i = "<html><img src=\"file:/" + MassLoaderDialog.this.loadDirectory.getAbsolutePath() + "/" + image + "\"></html>";
                    c.setToolTipText(i);
                }
                return c;
            }
        }

        class NameRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            NameRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                BasicNode node = (BasicNode)((Object)MassLoaderDialog.this.tree.getPathForRow(row).getLastPathComponent());
                c.setEnabled(!node.isSkip());
                c.setForeground(EDITABLE_COLOR);
                return c;
            }
        }

        class NameEditor
        extends DefaultCellEditor {
            private static final long serialVersionUID = 1L;

            public NameEditor(JTextField textField) {
                super(textField);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                c.setForeground(Color.blue);
                return c;
            }
        }

        class CopiesRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            CopiesRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel renderedLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                BasicNode node = (BasicNode)((Object)MassLoaderDialog.this.tree.getPathForRow(row).getLastPathComponent());
                renderedLabel.setHorizontalAlignment(0);
                renderedLabel.setEnabled(!node.isSkip());
                renderedLabel.setForeground(EDITABLE_COLOR);
                return renderedLabel;
            }
        }
    }

    private static class PieceInfo {
        protected String name;
        protected boolean skip;

        public PieceInfo(String name, boolean skip) {
            this.name = name;
            this.skip = skip;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean b) {
            this.skip = b;
        }
    }

    static class MassPieceDefiner
    extends PrototypeDefinition.Config.Definer {
        private static final long serialVersionUID = 1L;
        protected static DefaultListModel<GamePiece> newModel;
        protected boolean copyIsEmb;

        public MassPieceDefiner() {
            super(GameModule.getGameModule().getGpIdSupport());
            if (newModel == null) {
                newModel = new DefaultListModel();
                Enumeration e = availableModel.elements();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    newModel.addElement((GamePiece)o);
                    if (!(o instanceof Embellishment)) continue;
                    newModel.addElement(new Emb());
                }
            }
            this.availableList.setModel(newModel);
            this.setPiece(null);
        }

        @Override
        protected void copy(int index) {
            this.copyIsEmb = ((GamePiece)this.inUseModel.get(index)).getClass().equals(Emb.class);
            super.copy(index);
        }

        @Override
        protected void paste() {
            Decorator c;
            String type = clipBoard.getType();
            Decorator decorator = c = type.startsWith("emb2;") && this.copyIsEmb ? new Emb(type, null) : (Decorator)GameModule.getGameModule().createPiece(type, null);
            if (c instanceof PlaceMarker) {
                ((PlaceMarker)c).updateGpId(GameModule.getGameModule().getGpIdSupport());
            }
            int selectedIndex = this.getInUseSelectedIndex();
            c.setInner((GamePiece)this.inUseModel.lastElement());
            this.inUseModel.addElement(c);
            c.mySetState(clipBoard.getState());
            this.moveDecorator(this.inUseModel.size() - 1, selectedIndex + 1);
            this.refresh();
        }
    }

    private static class Entry
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final TranslatingStringEnumConfigurer typeConfig;
        private final StringConfigurer nameConfig;
        private final JLabel warning = new JLabel(Resources.getString("Editor.MassPieceLoader.warning_suffix"));

        public Entry() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(new JLabel(Resources.getString("Editor.MassPieceLoader.do_not_suffix")));
            JPanel entry = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "[]rel[]"));
            entry.add(new JLabel(Resources.getString("Editor.MassPieceLoader.image_name") + " "));
            this.typeConfig = new TranslatingStringEnumConfigurer(null, "", new String[]{MassPieceLoader.ENDS_WITH, MassPieceLoader.INCLUDES, MassPieceLoader.MATCHES, MassPieceLoader.EQUALS, MassPieceLoader.BASE_IMAGE}, new String[]{"Editor.MassPieceLoader.ends_with", "Editor.MassPieceLoader.includes", "Editor.MassPieceLoader.matches", "Editor.MassPieceLoader.same_as", "Editor.MassPieceLoader.base_image"});
            entry.add(this.typeConfig.getControls());
            this.nameConfig = new StringConfigurer(null, "");
            entry.add(this.nameConfig.getControls());
            this.add(entry);
            this.warning.setVisible(false);
            this.add(this.warning);
            this.typeConfig.addPropertyChangeListener(e -> this.updateVisibility());
            this.nameConfig.addPropertyChangeListener(e -> this.updateVisibility());
        }

        protected void updateVisibility() {
            this.warning.setVisible(ImageUtils.hasImageSuffix(this.nameConfig.getValueString()));
            this.nameConfig.getControls().setVisible(!this.typeConfig.getValueString().equals(MassPieceLoader.BASE_IMAGE));
        }

        @Override
        public String toString() {
            return this.typeConfig.getValueString().charAt(0) + this.nameConfig.getValueString();
        }

        public void setImageName(String s) {
            switch (s.charAt(0)) {
                case 'e': {
                    this.typeConfig.setValue(MassPieceLoader.ENDS_WITH);
                    break;
                }
                case 'i': {
                    this.typeConfig.setValue(MassPieceLoader.INCLUDES);
                    break;
                }
                case 'm': {
                    this.typeConfig.setValue(MassPieceLoader.MATCHES);
                    break;
                }
                case 's': {
                    this.typeConfig.setValue(MassPieceLoader.EQUALS);
                    break;
                }
                case 'u': {
                    this.typeConfig.setValue(MassPieceLoader.BASE_IMAGE);
                }
            }
            this.nameConfig.setValue(s.substring(1));
        }
    }

    private static class LoaderImagePicker
    extends MultiImagePicker {
        private static final long serialVersionUID = 1L;

        private LoaderImagePicker() {
        }

        @Override
        public void addEntry() {
            String entry = Resources.getString("Editor.MassPieceLoader.image") + " " + (this.imageListElements.size() + 1);
            this.imageListElements.addElement(entry);
            Entry pick = new Entry();
            this.multiPanel.add(entry, pick);
            this.imageList.setSelectedIndex(this.imageListElements.size() - 1);
            this.cl.show(this.multiPanel, (String)this.imageList.getSelectedValue());
        }

        @Override
        public List<String> getImageNameList() {
            int size = this.imageListElements.size();
            ArrayList<String> names = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                names.add(this.multiPanel.getComponent(i).toString());
            }
            return names;
        }

        @Override
        public void clear() {
            this.multiPanel.removeAll();
            this.imageListElements.removeAllElements();
        }

        @Override
        public void setImageList(String[] names) {
            while (names.length > this.multiPanel.getComponentCount()) {
                this.addEntry();
            }
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null) continue;
                ((Entry)this.multiPanel.getComponent(i)).setImageName(names[i]);
            }
        }
    }

    private static class Emb
    extends Embellishment {
        private final List<String> builtImages = new ArrayList<String>();

        public Emb() {
        }

        public Emb(String type, GamePiece p) {
            super(type, p);
        }

        public String[] getImageNames() {
            return this.imageName;
        }

        public String[] getLevelNames() {
            return this.commonName;
        }

        @Override
        public String getDescription() {
            return Resources.getString("Editor.MassPieceLoader.embellishment_trait_description") + super.getDescription().substring(Resources.getString("Editor.Embellishment.trait_description").length());
        }

        public boolean matchLayer(String s) {
            for (String levelName : this.imageName) {
                if (!this.match(s.split("\\.")[0], levelName)) continue;
                return true;
            }
            return false;
        }

        protected boolean match(String s, String levelName) {
            if (levelName != null && levelName.length() > 1) {
                if (levelName.charAt(0) == MassPieceLoader.BASE_IMAGE.charAt(0)) {
                    return false;
                }
                if (levelName.charAt(0) == MassPieceLoader.ENDS_WITH.charAt(0)) {
                    return s.endsWith(levelName.substring(1));
                }
                if (levelName.charAt(0) == MassPieceLoader.INCLUDES.charAt(0)) {
                    return s.contains(levelName.substring(1));
                }
                if (levelName.charAt(0) == MassPieceLoader.EQUALS.charAt(0)) {
                    return s.equals(levelName.substring(1));
                }
                try {
                    return Pattern.matches(levelName.substring(1), s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean buildLayers(String baseImage, List<String> levelImages) {
            String base = baseImage.split("\\.")[0];
            int count = 0;
            this.builtImages.clear();
            for (int i = 0; i < this.imageName.length; ++i) {
                String imageTemplate = this.imageName[i];
                String thisImage = null;
                if (imageTemplate.charAt(0) == MassPieceLoader.BASE_IMAGE.charAt(0)) {
                    thisImage = baseImage;
                } else {
                    Iterator<String> it = levelImages.iterator();
                    while (it.hasNext() && thisImage == null) {
                        String checkImage = it.next();
                        String checkImageBase = checkImage.split("\\.")[0];
                        if (imageTemplate.charAt(0) == MassPieceLoader.EQUALS.charAt(0)) {
                            if (!this.match(checkImageBase, imageTemplate)) continue;
                            thisImage = checkImage;
                            continue;
                        }
                        if (!checkImage.startsWith(base) || !this.match(checkImageBase, imageTemplate)) continue;
                        thisImage = checkImage;
                    }
                }
                this.imageName[i] = thisImage;
                if (thisImage == null) continue;
                ++count;
                this.builtImages.add(thisImage);
            }
            if (emptyLevelConfig.getValueBoolean()) {
                int j = 0;
                int newLength = 0;
                for (int i = 0; i < this.imageName.length; ++i) {
                    if (this.imageName[i] == null) continue;
                    ++newLength;
                }
                String[] imageNameTmp = new String[newLength];
                String[] commonNameTmp = new String[newLength];
                for (int i = 0; i < this.imageName.length; ++i) {
                    if (this.imageName[i] == null) continue;
                    imageNameTmp[j] = this.imageName[i];
                    commonNameTmp[j] = this.commonName[i];
                    ++j;
                }
                this.imageName = imageNameTmp;
                this.commonName = commonNameTmp;
            }
            return count > 0;
        }

        public List<String> getBuiltImageList() {
            return this.builtImages;
        }

        @Override
        public PieceEditor getEditor() {
            return new LoaderEd(this);
        }

        public static class LoaderEd
        extends Embellishment.Ed {
            public LoaderEd(Embellishment e) {
                super(e);
            }

            @Override
            protected MultiImagePicker getImagePicker() {
                return new LoaderImagePicker();
            }
        }
    }

    private static class LevelNode
    extends BasicNode {
        int levelNumber;

        public LevelNode(String name, String imageName, int level) {
            super(name, imageName);
            this.levelNumber = level;
        }

        @Override
        public String getDescription() {
            return Resources.getString("Editor.MassPieceLoader.level") + " " + (this.levelNumber + 1) + (String)(this.name.length() > 0 ? " [" + this.name + "]" : "");
        }

        @Override
        public String getName() {
            return "";
        }
    }

    private static class LayerNode
    extends BasicNode {
        public LayerNode(String name) {
            super(name, "");
        }

        @Override
        public String getDescription() {
            return Resources.getString("Editor.MassPieceLoader.layer_desc") + (String)(this.name.length() > 0 ? " [" + this.name + "]" : "");
        }

        @Override
        public String getName() {
            return "";
        }
    }

    private class PieceNode
    extends BasicNode {
        public PieceNode(String imageName) {
            this.setImageName(imageName);
            PieceInfo info = MassPieceLoader.this.pieceInfo.get(imageName);
            if (info == null) {
                this.setName(ImageUtils.stripImageSuffix(imageName));
                this.setSkip(false);
            } else {
                this.setName(info.getName());
                this.setSkip(info.isSkip());
            }
        }

        public String getBaseImageName() {
            return super.getImageName();
        }

        @Override
        public String getImageName() {
            if (basicConfig.booleanValue().booleanValue()) {
                return "";
            }
            return super.getImageName();
        }

        @Override
        public String getDescription() {
            return Resources.getString("Editor.MassPieceLoader.piece_desc");
        }

        @Override
        public void setName(String name) {
            super.setName(name);
            MassPieceLoader.this.pieceInfo.put(this.getImageName(), new PieceInfo(name, this.isSkip()));
        }

        @Override
        public void setSkip(boolean skip) {
            super.setSkip(skip);
            MassPieceLoader.this.pieceInfo.put(this.getImageName(), new PieceInfo(this.getName(), skip));
        }
    }

    private static class BasicNode
    extends DefaultMutableTreeTableNode {
        protected String name;
        protected String imageName;
        protected boolean skip;
        protected int copies;

        public BasicNode() {
            this("", "");
        }

        public BasicNode(String name, String imageName) {
            this.name = name;
            this.imageName = imageName;
            this.skip = false;
            this.copies = 1;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getImageName() {
            return this.imageName;
        }

        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean b) {
            this.skip = b;
        }

        public void setCopies(int i) {
            this.copies = i;
        }

        public int getCopies() {
            return this.copies;
        }

        public String getDescription() {
            return Resources.getString("Editor.MassPieceLoader.root");
        }

        public Object getValueAt(int col) {
            switch (col) {
                case 0: {
                    return this.getDescription();
                }
                case 2: {
                    return this.getName();
                }
                case 1: {
                    return this.getImageName();
                }
                case 3: {
                    return this.isSkip();
                }
                case 4: {
                    return this.getCopies();
                }
            }
            return "";
        }
    }

    private static class NullRenderer
    implements TableCellRenderer {
        private NullRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
            return new JLabel("");
        }
    }

    private class MyTreeTable
    extends JXTreeTable {
        private static final long serialVersionUID = 1L;

        public MyTreeTable() {
            this.setRootVisible(false);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 3 || column == 4) {
                if (this.getPathForRow(row) == null) {
                    return new NullRenderer();
                }
                if (!(this.getPathForRow(row).getLastPathComponent() instanceof PieceNode)) {
                    return new NullRenderer();
                }
            }
            return super.getCellRenderer(row, column);
        }
    }

    private class MyTreeTableModel
    extends DefaultTreeTableModel {
        public MyTreeTableModel(BasicNode rootNode) {
            super((TreeTableNode)rootNode);
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Resources.getString("Editor.MassPieceLoader.item");
                }
                case 2: {
                    return Resources.getString("Editor.MassPieceLoader.piece_name");
                }
                case 1: {
                    return Resources.getString("Editor.MassPieceLoader.image_name");
                }
                case 3: {
                    return Resources.getString("Editor.MassPieceLoader.skip");
                }
                case 4: {
                    return Resources.getString("Editor.MassPieceLoader.copies");
                }
            }
            return "";
        }

        public Class<?> getColumnClass(int column) {
            if (column == 3) {
                return Boolean.class;
            }
            if (column == 4) {
                return Integer.class;
            }
            return String.class;
        }

        public boolean isCellEditable(Object node, int column) {
            if (node instanceof PieceNode) {
                if (column == 2 || column == 4) {
                    return !((PieceNode)((Object)node)).isSkip();
                }
                return column == 3;
            }
            return false;
        }

        public Object getValueAt(Object node, int column) {
            return ((BasicNode)((Object)node)).getValueAt(column);
        }

        public void setValueAt(Object value, Object node, int column) {
            if (node instanceof PieceNode) {
                if (column == 2) {
                    ((PieceNode)((Object)node)).setName((String)value);
                } else if (column == 3) {
                    ((PieceNode)((Object)node)).setSkip((Boolean)value);
                } else if (column == 4) {
                    int val;
                    int n = val = value == null ? 1 : (Integer)value;
                    if (val < 1) {
                        val = 1;
                    }
                    ((PieceNode)((Object)node)).setCopies(val);
                }
            } else {
                super.setValueAt(value, node, column);
            }
        }
    }

    private static class DefineDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        protected boolean cancelled = false;

        public DefineDialog(JDialog owner) {
            super(owner);
            this.setModal(true);
            this.setVisible(false);
            this.setTitle(Resources.getString("Editor.MassPieceLoader.multiple_piece_template"));
            this.setLocationRelativeTo(owner);
            this.setLayout((LayoutManager)new MigLayout("ins panel,wrap 1,gapy 4", "[grow,fill]", "[grow,fill][]"));
            this.add((Component)definer, "grow");
            JButton saveButton = new JButton(Resources.getString("General.save"));
            saveButton.addActionListener(e -> this.save());
            JButton canButton = new JButton(Resources.getString("General.cancel"));
            canButton.addActionListener(e -> this.cancel());
            JPanel bbox = new JPanel((LayoutManager)new MigLayout("ins 0", "push[][]push"));
            bbox.add(saveButton);
            bbox.add(canButton);
            this.add((Component)bbox, "center");
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    this.cancel();
                }
            });
            this.pack();
        }

        protected void save() {
            this.cancelled = false;
            this.setVisible(false);
        }

        protected void cancel() {
            this.cancelled = true;
            this.setVisible(false);
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

