/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.launch.TileProgressPumpStateMachine;
import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.io.InputStreamPump;
import java.io.IOException;
import java.io.InputStream;

class TileProgressPump
implements InputStreamPump {
    protected InputStream in;
    protected volatile boolean running = false;
    protected final TileProgressPumpStateMachine sm;
    protected final EventListener<IOException> ioexListener;

    public TileProgressPump(EventListener<String> nameListener, EventListener<Integer> progListener, EventListener<IOException> ioexListener) {
        this.sm = new TileProgressPumpStateMachine(nameListener, progListener);
        this.ioexListener = ioexListener;
    }

    @Override
    public void setInputStream(InputStream in) {
        if (this.running) {
            throw new UnsupportedOperationException();
        }
        this.in = in;
    }

    @Override
    public void run() {
        this.running = true;
        byte[] buf = new byte[256];
        StringBuilder sb = new StringBuilder();
        int state = 0;
        try {
            int count;
            while ((count = this.in.read(buf)) != -1) {
                state = this.sm.run(state, buf, 0, count, sb);
            }
            if (state != 0 && state != 5) {
                throw new IOException("Stream ended before DONE");
            }
        }
        catch (IOException e) {
            this.ioexListener.receive(this, e);
        }
    }
}

