/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.deprecation;

import VASSAL.tools.deprecation.DependencyWalker;
import VASSAL.tools.deprecation.Processor;
import VASSAL.tools.deprecation.Walker;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Consumer;

public class DependencyWriter {
    public static void main(String[] args) throws IOException {
        String infile;
        String outfile;
        if (args.length != 1 && args.length != 3) {
            throw new IllegalArgumentException();
        }
        if ("-o".equals(args[0])) {
            outfile = args[1];
            infile = args[2];
        } else {
            outfile = null;
            infile = args[0];
        }
        DependencyWalker walker = new DependencyWalker();
        HashSet deps = new HashSet();
        Consumer<String> collect = s -> deps.add(s);
        walker.setClassCallback(collect);
        walker.setMethodCallback(collect);
        walker.setFieldCallback(collect);
        try (PrintStream ps = args.length == 1 ? System.out : new PrintStream(outfile, StandardCharsets.UTF_8);){
            walker.setThisClassBeginCallback(s -> ps.println((String)s));
            walker.setThisClassEndCallback(s -> {
                Object[] darr = deps.toArray(new String[0]);
                Arrays.sort(darr);
                for (Object dep : darr) {
                    ps.println("  " + (String)dep);
                }
                ps.println("");
                deps.clear();
            });
            Processor.process((Walker)walker, infile);
        }
    }
}

