/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.deprecation;

import VASSAL.tools.deprecation.DependencyWalker;
import VASSAL.tools.deprecation.Processor;
import VASSAL.tools.deprecation.Walker;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.tuple.Pair;

public class RemovalAndDeprecationChecker {
    private final DependencyWalker walker = new DependencyWalker();
    private final Map<String, String> removed = this.readRemoved();
    private final Map<String, String> deprecated = this.readDeprecated();

    private Map<String, String> readRemoved() throws IOException {
        HashMap<String, String> r = new HashMap<String, String>();
        try (InputStream in = this.getClass().getResourceAsStream("/removed");){
            if (in != null) {
                Processor.readCompSet(in, cols -> r.put(cols[0], cols[1]));
            }
        }
        return r;
    }

    private Map<String, String> readDeprecated() throws IOException {
        HashMap<String, String> d = new HashMap<String, String>();
        try (InputStream in = this.getClass().getResourceAsStream("/deprecated");){
            if (in != null) {
                Processor.readCompSet(in, cols -> {
                    if ("true".equals(cols[2])) {
                        d.put(cols[0], cols[1]);
                    }
                });
            }
        }
        return d;
    }

    public Pair<Map<String, Map<String, String>>, Map<String, Map<String, String>>> check(ZipFile zf) throws IOException {
        HashMap rmap = new HashMap();
        HashMap dmap = new HashMap();
        HashMap removed_used = new HashMap();
        HashMap deprecated_used = new HashMap();
        Consumer<String> callback = s -> {
            String version = this.removed.get(s);
            if (version != null) {
                removed_used.put(s, version);
            } else {
                String when = this.deprecated.get(s);
                if (when != null) {
                    deprecated_used.put(s, when);
                }
            }
        };
        this.walker.setClassCallback(callback);
        this.walker.setMethodCallback(callback);
        this.walker.setFieldCallback(callback);
        this.walker.setThisClassBeginCallback(s -> {
            removed_used.clear();
            deprecated_used.clear();
        });
        this.walker.setThisClassEndCallback(s -> {
            if (!removed_used.isEmpty()) {
                rmap.put(s, new HashMap(removed_used));
            }
            if (!deprecated_used.isEmpty()) {
                dmap.put(s, new HashMap(deprecated_used));
            }
        });
        Processor.process((Walker)this.walker, zf);
        return Pair.of(rmap, dmap);
    }

    public static String formatResult(Map<String, Map<String, String>> dmap) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> dependers = new ArrayList<String>(dmap.keySet());
        Collections.sort(dependers);
        for (String dhead : dependers) {
            Map<String, String> dtmap = dmap.get(dhead);
            ArrayList<String> ds = new ArrayList<String>(dtmap.keySet());
            Collections.sort(ds);
            for (String dtail : ds) {
                sb.append('\n').append(dhead).append(" => ").append(dtail).append(", ").append(dtmap.get(dtail));
            }
        }
        return sb.toString();
    }
}

