/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public final class GeneralFilter {
    public static final int OPAQUE = 0;
    public static final int TRANS_PREMULT = 1;
    public static final int TRANS_UNPREMULT = 2;

    private GeneralFilter() {
    }

    public static BufferedImage zoom(Rectangle dst, BufferedImage src, Filter filter) {
        WritableRaster dstR = src.getColorModel().createCompatibleWritableRaster(dst.width, dst.height);
        GeneralFilter.zoom(dstR, dstR.getBounds(), src, filter);
        return new BufferedImage(src.getColorModel(), dstR, src.isAlphaPremultiplied(), null);
    }

    public static void zoom(WritableRaster dstR, Rectangle dst_fr, BufferedImage srcI, Filter filter) {
        int[] dst_data = ((DataBufferInt)dstR.getDataBuffer()).getData();
        int src_type = srcI.getTransparency() == 1 ? 0 : (srcI.isAlphaPremultiplied() ? 1 : 2);
        int dx0 = dstR.getMinX();
        int dy0 = dstR.getMinY();
        int dx1 = dx0 + dstR.getWidth() - 1;
        int dy1 = dy0 + dstR.getHeight() - 1;
        int dw = dstR.getWidth();
        int dh = dstR.getHeight();
        int dstWidth = dst_fr.width;
        int dstHeight = dst_fr.height;
        int srcWidth = srcI.getWidth();
        int srcHeight = srcI.getHeight();
        float xscale = srcWidth == 1 ? (float)dstWidth : (float)(dstWidth - 1) / (float)(srcWidth - 1);
        float yscale = srcHeight == 1 ? (float)dstHeight : (float)(dstHeight - 1) / (float)(srcHeight - 1);
        float fwidth = filter.getSamplingRadius();
        int sx0 = Math.max(0, (int)Math.floor(((float)dx0 - fwidth) / xscale));
        int sy0 = Math.max(0, (int)Math.floor(((float)dy0 - fwidth) / yscale));
        int sx1 = Math.min(srcWidth - 1, (int)Math.ceil(((float)dx1 + fwidth) / xscale));
        int sy1 = Math.min(srcHeight - 1, (int)Math.ceil(((float)dy1 + fwidth) / yscale));
        int sw = sx1 - sx0 + 1;
        int sh = sy1 - sy0 + 1;
        int[] src_data = ((DataBufferInt)srcI.getRaster().getDataBuffer()).getData();
        GeneralFilter.resample(src_data, false, sx0, sy0, sx1, sy1, sw, sh, src_type, srcWidth, srcHeight, dst_data, dx0, dy0, dx1, dy1, dw, dh, dstWidth, dstHeight, xscale, yscale, filter);
    }

    public static void resample(int[] src_data, boolean src_data_consecutive, int sx0, int sy0, int sx1, int sy1, int sw, int sh, int src_type, int srcWidth, int srcHeight, int[] dst_data, int dx0, int dy0, int dx1, int dy1, int dw, int dh, int dstWidth, int dstHeight, float xscale, float yscale, Filter filter) {
        int[] work = new int[sh];
        float fwidth = filter.getSamplingRadius();
        CList[] ycontrib = GeneralFilter.calc_contrib(dh, fwidth, yscale, dy0, sy0, sh, filter);
        CList[] xcontrib = GeneralFilter.calc_contrib(dw, fwidth, xscale, dx0, sx0, sw, filter);
        switch (src_type) {
            case 0: {
                if (src_data_consecutive) {
                    for (int dx = 0; dx < dw; ++dx) {
                        GeneralFilter.apply_h_opaque(0, 0, sh, sw, xcontrib[dx], src_data, work);
                        GeneralFilter.apply_v_opaque(dh, ycontrib, work, dst_data, dx, dw);
                    }
                } else {
                    for (int dx = 0; dx < dw; ++dx) {
                        GeneralFilter.apply_h_opaque(sx0, sy0, sh, srcWidth, xcontrib[dx], src_data, work);
                        GeneralFilter.apply_v_opaque(dh, ycontrib, work, dst_data, dx, dw);
                    }
                }
                break;
            }
            case 1: {
                if (src_data_consecutive) {
                    for (int dx = 0; dx < dw; ++dx) {
                        GeneralFilter.apply_h(0, 0, sh, sw, xcontrib[dx], src_data, work);
                        GeneralFilter.apply_v(dh, ycontrib, work, dst_data, dx, dw);
                    }
                } else {
                    for (int dx = 0; dx < dw; ++dx) {
                        GeneralFilter.apply_h(sx0, sy0, sh, srcWidth, xcontrib[dx], src_data, work);
                        GeneralFilter.apply_v(dh, ycontrib, work, dst_data, dx, dw);
                    }
                }
                break;
            }
            case 2: {
                int dx;
                int a;
                int i;
                int[] pre_src_data = new int[src_data.length];
                for (i = 0; i < src_data.length; ++i) {
                    int unpre = src_data[i];
                    a = unpre >>> 24 & 0xFF;
                    if (a == 255) {
                        pre_src_data[i] = unpre;
                        continue;
                    }
                    float na = (float)a / 255.0f;
                    pre_src_data[i] = a << 24 | (int)((float)(unpre >>> 16 & 0xFF) * na + 0.5f) << 16 | (int)((float)(unpre >>> 8 & 0xFF) * na + 0.5f) << 8 | (int)((float)(unpre & 0xFF) * na + 0.5f);
                }
                if (src_data_consecutive) {
                    for (dx = 0; dx < dw; ++dx) {
                        GeneralFilter.apply_h(0, 0, sh, sw, xcontrib[dx], pre_src_data, work);
                        GeneralFilter.apply_v(dh, ycontrib, work, dst_data, dx, dw);
                    }
                } else {
                    for (dx = 0; dx < dw; ++dx) {
                        GeneralFilter.apply_h(sx0, sy0, sh, srcWidth, xcontrib[dx], pre_src_data, work);
                        GeneralFilter.apply_v(dh, ycontrib, work, dst_data, dx, dw);
                    }
                }
                for (i = 0; i < dst_data.length; ++i) {
                    int pre = dst_data[i];
                    a = pre >>> 24 & 0xFF;
                    if (a == 255) continue;
                    float inv_na = 255.0f / (float)a;
                    dst_data[i] = a << 24 | (int)((float)(pre >>> 16 & 0xFF) * inv_na + 0.5f) << 16 | (int)((float)(pre >>> 8 & 0xFF) * inv_na + 0.5f) << 8 | (int)((float)(pre & 0xFF) * inv_na + 0.5f);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static CList[] calc_contrib(int dl, float fwidth, float scale, int d0, int s0, int sl, Filter filter) {
        CList[] contrib = new CList[dl];
        for (int i = 0; i < contrib.length; ++i) {
            contrib[i] = new CList();
        }
        float blur = 1.0f;
        float kscale = 1.0f / (1.0f * Math.max(1.0f / scale, 1.0f));
        float width = fwidth / kscale;
        for (int i = 0; i < dl; ++i) {
            int numContrib;
            float center = ((float)(i + d0) + 0.5f) / scale;
            int start = (int)Math.max(center - width + 0.5f, (float)s0);
            int stop = (int)Math.min(center + width + 0.5f, (float)(s0 + sl));
            contrib[i].n = numContrib = stop - start;
            contrib[i].pixel = start - s0;
            contrib[i].weight = new float[numContrib];
            float density = 0.0f;
            for (int n = 0; n < numContrib; ++n) {
                contrib[i].weight[n] = filter.apply(kscale * ((float)(start + n) - center + 0.5f));
                density += contrib[i].weight[n];
            }
            if (density == 0.0f || density == 1.0f) continue;
            int j = 0;
            while (j < numContrib) {
                int n = j++;
                contrib[i].weight[n] = contrib[i].weight[n] / density;
            }
        }
        return contrib;
    }

    private static void apply_h(int sx0, int sy0, int sh, int stride, CList xcontrib, int[] src, int[] work) {
        int max = xcontrib.n;
        int base = sx0 + xcontrib.pixel + sy0 * stride;
        for (int k = 0; k < sh; ++k) {
            int j;
            float s_a = 0.0f;
            float s_r = 0.0f;
            float s_g = 0.0f;
            float s_b = 0.0f;
            int pos = base + k * stride;
            int pel = src[pos];
            boolean bPelDelta = false;
            for (j = 0; j < max; ++j) {
                if (xcontrib.weight[j] == 0.0f || src[pos + j] == pel) continue;
                bPelDelta = true;
                break;
            }
            if (bPelDelta) {
                for (j = 0; j < max; ++j) {
                    float w = xcontrib.weight[j];
                    int sd = src[pos + j];
                    s_a += (float)(sd >>> 24 & 0xFF) * w;
                    s_r += (float)(sd >>> 16 & 0xFF) * w;
                    s_g += (float)(sd >>> 8 & 0xFF) * w;
                    s_b += (float)(sd & 0xFF) * w;
                }
                work[k] = (s_a > 255.0f ? 255 : (s_a < 0.0f ? 0 : (int)(s_a + 0.5f))) << 24 | (s_r > 255.0f ? 255 : (s_r < 0.0f ? 0 : (int)(s_r + 0.5f))) << 16 | (s_g > 255.0f ? 255 : (s_g < 0.0f ? 0 : (int)(s_g + 0.5f))) << 8 | (s_b > 255.0f ? 255 : (s_b < 0.0f ? 0 : (int)(s_b + 0.5f)));
                continue;
            }
            work[k] = pel;
        }
    }

    private static void apply_h_opaque(int sx0, int sy0, int sh, int stride, CList xcontrib, int[] src, int[] work) {
        int max = xcontrib.n;
        int base = sx0 + xcontrib.pixel + sy0 * stride;
        for (int k = 0; k < sh; ++k) {
            int j;
            float s_r = 0.0f;
            float s_g = 0.0f;
            float s_b = 0.0f;
            int pos = base + k * stride;
            int pel = src[pos];
            boolean bPelDelta = false;
            for (j = 0; j < max; ++j) {
                if (xcontrib.weight[j] == 0.0f || src[pos + j] == pel) continue;
                bPelDelta = true;
                break;
            }
            if (bPelDelta) {
                for (j = 0; j < max; ++j) {
                    float w = xcontrib.weight[j];
                    int sd = src[pos + j];
                    s_r += (float)(sd >>> 16 & 0xFF) * w;
                    s_g += (float)(sd >>> 8 & 0xFF) * w;
                    s_b += (float)(sd & 0xFF) * w;
                }
                work[k] = (s_r > 255.0f ? 255 : (s_r < 0.0f ? 0 : (int)(s_r + 0.5f))) << 16 | (s_g > 255.0f ? 255 : (s_g < 0.0f ? 0 : (int)(s_g + 0.5f))) << 8 | (s_b > 255.0f ? 255 : (s_b < 0.0f ? 0 : (int)(s_b + 0.5f)));
                continue;
            }
            work[k] = pel;
        }
    }

    private static void apply_v(int dh, CList[] ycontrib, int[] work, int[] dst, int dx, int dw) {
        for (int i = 0; i < dh; ++i) {
            int a;
            int j;
            float s_a = 0.0f;
            float s_r = 0.0f;
            float s_g = 0.0f;
            float s_b = 0.0f;
            CList c = ycontrib[i];
            int max = c.n;
            int pel = work[c.pixel];
            boolean bPelDelta = false;
            for (j = 0; j < max; ++j) {
                if (c.weight[j] == 0.0f || work[c.pixel + j] == pel) continue;
                bPelDelta = true;
                break;
            }
            if (bPelDelta) {
                for (j = 0; j < max; ++j) {
                    float w = c.weight[j];
                    int wd = work[c.pixel + j];
                    s_a += (float)(wd >>> 24 & 0xFF) * w;
                    s_r += (float)(wd >>> 16 & 0xFF) * w;
                    s_g += (float)(wd >>> 8 & 0xFF) * w;
                    s_b += (float)(wd & 0xFF) * w;
                }
                int n = s_a > 255.0f ? 255 : (a = s_a < 0.0f ? 0 : (int)(s_a + 0.5f));
                dst[dx + i * dw] = a << 24 | (s_r > (float)a ? a : (s_r < 0.0f ? 0 : (int)(s_r + 0.5f))) << 16 | (s_g > (float)a ? a : (s_g < 0.0f ? 0 : (int)(s_g + 0.5f))) << 8 | (s_b > (float)a ? a : (s_b < 0.0f ? 0 : (int)(s_b + 0.5f)));
                continue;
            }
            a = pel >>> 24 & 0xFF;
            int r = pel >>> 16 & 0xFF;
            int g = pel >>> 8 & 0xFF;
            int b = pel & 0xFF;
            dst[dx + i * dw] = a << 24 | (r > a ? a : r) << 16 | (g > a ? a : g) << 8 | (b > a ? a : b);
        }
    }

    private static void apply_v_opaque(int dh, CList[] ycontrib, int[] work, int[] dst, int dx, int dw) {
        for (int i = 0; i < dh; ++i) {
            int j;
            float s_r = 0.0f;
            float s_g = 0.0f;
            float s_b = 0.0f;
            CList c = ycontrib[i];
            int max = c.n;
            int pel = work[c.pixel];
            boolean bPelDelta = false;
            for (j = 0; j < max; ++j) {
                if (c.weight[j] == 0.0f || work[c.pixel + j] == pel) continue;
                bPelDelta = true;
                break;
            }
            if (bPelDelta) {
                for (j = 0; j < max; ++j) {
                    float w = c.weight[j];
                    int wd = work[c.pixel + j];
                    s_r += (float)(wd >>> 16 & 0xFF) * w;
                    s_g += (float)(wd >>> 8 & 0xFF) * w;
                    s_b += (float)(wd & 0xFF) * w;
                }
                dst[dx + i * dw] = (s_r > 255.0f ? 255 : (s_r < 0.0f ? 0 : (int)(s_r + 0.5f))) << 16 | (s_g > 255.0f ? 255 : (s_g < 0.0f ? 0 : (int)(s_g + 0.5f))) << 8 | (s_b > 255.0f ? 255 : (s_b < 0.0f ? 0 : (int)(s_b + 0.5f)));
                continue;
            }
            dst[dx + i * dw] = pel;
        }
    }

    public static abstract class Filter {
        public abstract float getSamplingRadius();

        public abstract float apply(float var1);
    }

    private static final class CList {
        public int n;
        public int pixel;
        public float[] weight;

        private CList() {
        }
    }

    public static final class BSplineFilter
    extends Filter {
        @Override
        public float apply(float t) {
            if (t < 0.0f) {
                t = -t;
            }
            if (t < 1.0f) {
                float tt = t * t;
                return 0.5f * tt * t - tt + 0.6666667f;
            }
            if (t < 2.0f) {
                t = 2.0f - t;
                return 0.16666667f * (t * t * t);
            }
            return 0.0f;
        }

        @Override
        public float getSamplingRadius() {
            return 2.0f;
        }
    }

    public static final class BellFilter
    extends Filter {
        @Override
        public float apply(float t) {
            if (t < 0.0f) {
                t = -t;
            }
            if (t < 0.5f) {
                return 0.75f - t * t;
            }
            if (t < 1.5f) {
                return 0.5f * ((t -= 1.5f) * t);
            }
            return 0.0f;
        }

        @Override
        public float getSamplingRadius() {
            return 1.5f;
        }
    }

    public static final class MitchellFilter
    extends Filter {
        private static final float B = 0.33333334f;
        private static final float C = 0.33333334f;
        private static final float P0 = 0.8888889f;
        private static final float P2 = -2.0f;
        private static final float P3 = 1.1666666f;
        private static final float Q0 = 1.7777778f;
        private static final float Q1 = -3.3333333f;
        private static final float Q2 = 2.0f;
        private static final float Q3 = -0.38888887f;

        @Override
        public float apply(float t) {
            if (t < -2.0f) {
                return 0.0f;
            }
            if (t < -1.0f) {
                return 1.7777778f - t * (-3.3333333f - t * (2.0f - t * -0.38888887f));
            }
            if (t < 0.0f) {
                return 0.8888889f + t * t * (-2.0f - t * 1.1666666f);
            }
            if (t < 1.0f) {
                return 0.8888889f + t * t * (-2.0f + t * 1.1666666f);
            }
            if (t < 2.0f) {
                return 1.7777778f + t * (-3.3333333f + t * (2.0f + t * -0.38888887f));
            }
            return 0.0f;
        }

        @Override
        public float getSamplingRadius() {
            return 2.0f;
        }
    }

    public static final class Lanczos3Filter
    extends Filter {
        private float sinc(float t) {
            if (t == 0.0f) {
                return 1.0f;
            }
            t = (float)((double)t * Math.PI);
            return (float)(Math.sin(t) / (double)t);
        }

        @Override
        public float apply(float t) {
            if (t < -3.0f) {
                return 0.0f;
            }
            if (t < 0.0f) {
                return this.sinc(-t) * this.sinc(-t / 3.0f);
            }
            if (t < 3.0f) {
                return this.sinc(t) * this.sinc(t / 3.0f);
            }
            return 0.0f;
        }

        @Override
        public float getSamplingRadius() {
            return 3.0f;
        }
    }

    public static final class TriangleFilter {
        public float apply(float t) {
            if (t < 0.0f) {
                t = -t;
            }
            if (t < 1.0f) {
                return 1.0f - t;
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 1.0f;
        }
    }

    public static final class BoxFilter
    extends Filter {
        @Override
        public float apply(float t) {
            if (t > -0.5f && t <= 0.5f) {
                return 1.0f;
            }
            return 0.0f;
        }

        @Override
        public float getSamplingRadius() {
            return 0.5f;
        }
    }

    public static final class HermiteFilter
    extends Filter {
        @Override
        public float apply(float t) {
            if (t < 0.0f) {
                t = -t;
            }
            if (t < 1.0f) {
                return (2.0f * t - 3.0f) * t * t + 1.0f;
            }
            return 0.0f;
        }

        @Override
        public float getSamplingRadius() {
            return 1.0f;
        }
    }
}

