/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ImageOpObserver;
import VASSAL.tools.imageop.Op;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public class Repainter
implements ImageOpObserver {
    protected final Component c;
    protected final int x;
    protected final int y;
    protected final int w;
    protected final int h;

    public Repainter(Component c, int x, int y, int w, int h) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.c = c;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public Repainter(Component c, Rectangle r) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.c = c;
        if (r == null) {
            r = c.getBounds();
        }
        this.x = r.x;
        this.y = r.y;
        this.w = r.width;
        this.h = r.height;
    }

    @Override
    public void imageOpChange(ImageOp op, boolean success) {
        if (success) {
            this.c.repaint(this.x, this.y, this.w, this.h);
        }
    }

    @Override
    public void succeeded(VASSAL.tools.opcache.Op<BufferedImage> op, BufferedImage img) {
        this.c.repaint(this.x, this.y, this.w, this.h);
    }

    @Override
    public void cancelled(VASSAL.tools.opcache.Op<BufferedImage> op, CancellationException e) {
        ErrorDialog.bug(e);
    }

    @Override
    public void interrupted(VASSAL.tools.opcache.Op<BufferedImage> op, InterruptedException e) {
        ErrorDialog.bug(e);
    }

    @Override
    public void failed(VASSAL.tools.opcache.Op<BufferedImage> op, ExecutionException e) {
        if (!Op.handleException(e)) {
            ErrorDialog.bug(e);
        }
    }
}

