/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.RotateScaleOp;
import VASSAL.tools.opcache.Op;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class RotateScaleOpBitmapImpl
extends AbstractTileOpImpl
implements RotateScaleOp {
    private final ImageOp sop;
    private final double scale;
    private final double angle;
    private final RenderingHints hints;
    private final int hash;

    public RotateScaleOpBitmapImpl(ImageOp sop, double angle, double scale) {
        this(sop, angle, scale, ImageUtils.getDefaultHints());
    }

    public RotateScaleOpBitmapImpl(ImageOp sop, double angle, double scale, RenderingHints hints) {
        if (sop == null) {
            throw new IllegalArgumentException();
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale = " + scale);
        }
        this.sop = sop;
        this.angle = angle;
        this.scale = scale;
        this.hints = hints;
        this.hash = new HashCodeBuilder().append((Object)sop).append(scale).append(angle).append((Object)hints).toHashCode();
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.singletonList(this.sop);
    }

    @Override
    public BufferedImage eval() throws Exception {
        return ImageUtils.transform(this.sop.getImage(null), this.scale, this.angle, this.hints);
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = ImageUtils.transform(new Rectangle(this.sop.getSize()), this.scale, this.angle).getSize();
        }
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public RenderingHints getHints() {
        return this.hints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        RotateScaleOpBitmapImpl op = (RotateScaleOpBitmapImpl)o;
        return this.scale == op.getScale() && this.angle == op.getAngle() && this.hints.equals(op.getHints()) && this.sop.equals(op.sop);
    }

    public int hashCode() {
        return this.hash;
    }
}

