/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.menu;

import VASSAL.tools.menu.AbstractProxy;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;

public class CheckBoxMenuItemProxy
extends AbstractProxy<JCheckBoxMenuItem>
implements ItemListener {
    private Action action;
    private boolean state;

    public CheckBoxMenuItemProxy() {
        this(null, false);
    }

    public CheckBoxMenuItemProxy(Action action) {
        this(action, false);
    }

    public CheckBoxMenuItemProxy(Action action, boolean state) {
        this.action = action;
        this.state = state;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
        this.forEachPeer(item -> item.setAction(action));
    }

    public boolean isSelected() {
        return this.state;
    }

    public void setSelected(boolean state) {
        this.state = state;
        this.forEachPeer(item -> item.setSelected(state));
    }

    @Override
    public JCheckBoxMenuItem createPeer() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(this.action);
        item.setSelected(this.state);
        item.addItemListener(this);
        this.peers.add(new WeakReference<JCheckBoxMenuItem>(item, this.queue));
        return item;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.state = e.getStateChange() == 1;
        this.forEachPeer(item -> item.setSelected(this.state));
    }
}

