import VASSAL.build.module
import VASSAL.build.module.documentation
import VASSAL.build.module.properties
import VASSAL.build.widget
import VASSAL.chat.ui
import VASSAL.command
import VASSAL.configure
import VASSAL.counters
import VASSAL.i18n
import VASSAL.launch
import VASSAL.preferences
import VASSAL.script.expression
import VASSAL.search
import VASSAL.tools
import VASSAL.tools.filechooser
import VASSAL.tools.image
import java.awt
import java.beans
import java.io
import java.lang
import java.util
import javax.swing
import org.w3c.dom
import typing



class BadDataReport:
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, abstractConfigurable: 'AbstractConfigurable', string: str, string2: str): ...
    @typing.overload
    def __init__(self, abstractConfigurable: 'AbstractConfigurable', string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, pieceSlot: VASSAL.build.widget.PieceSlot, string: str, string2: str): ...
    @typing.overload
    def __init__(self, editablePiece: VASSAL.counters.EditablePiece, string: str): ...
    @typing.overload
    def __init__(self, editablePiece: VASSAL.counters.EditablePiece, string: str, string2: str): ...
    @typing.overload
    def __init__(self, editablePiece: VASSAL.counters.EditablePiece, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, expressionException: VASSAL.script.expression.ExpressionException): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail): ...
    def getAuditReport(self) -> str: ...
    def getAuditTrail(self) -> VASSAL.script.expression.AuditTrail: ...
    def getCause(self) -> java.lang.Throwable: ...
    def getData(self) -> str: ...
    def getFullData(self) -> str: ...
    def getMessage(self) -> str: ...
    def isReportable(self) -> bool: ...
    def setReportable(self, boolean: bool) -> None: ...

class Buildable:
    def add(self, buildable: 'Buildable') -> None: ...
    def addTo(self, buildable: 'Buildable') -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...

class Builder:
    @staticmethod
    def build(element: org.w3c.dom.Element, buildable: Buildable) -> None: ...
    @typing.overload
    @staticmethod
    def create(element: org.w3c.dom.Element) -> Buildable: ...
    @typing.overload
    @staticmethod
    def create(element: org.w3c.dom.Element, buildable: Buildable) -> Buildable: ...
    @staticmethod
    def createDocument(inputStream: java.io.InputStream) -> org.w3c.dom.Document: ...
    @staticmethod
    def createNewDocument() -> org.w3c.dom.Document: ...
    @staticmethod
    def getText(element: org.w3c.dom.Element) -> str: ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def toString(document: org.w3c.dom.Document) -> str: ...
    @staticmethod
    def writeDocument(document: org.w3c.dom.Document, writer: java.io.Writer) -> None: ...

class Configurable(VASSAL.i18n.Translatable):
    NAME_PROPERTY: typing.ClassVar[str] = ...
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type]: ...
    def getConfigureComponents(self) -> typing.List['Configurable']: ...
    def getConfigureName(self) -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def remove(self, buildable: Buildable) -> None: ...
    def removeFrom(self, buildable: Buildable) -> None: ...

class GpIdChecker:
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, gpIdSupport: 'GpIdSupport'): ...
    @typing.overload
    def __init__(self, set: java.util.Set[str]): ...
    @typing.overload
    def add(self, prototypeDefinition: VASSAL.build.module.PrototypeDefinition) -> None: ...
    @typing.overload
    def add(self, pieceSlot: VASSAL.build.widget.PieceSlot) -> None: ...
    def createUpdatedPiece(self, gamePiece: VASSAL.counters.GamePiece) -> VASSAL.counters.GamePiece: ...
    def fixErrors(self) -> None: ...
    def hasErrors(self) -> bool: ...
    def useLabelerName(self) -> bool: ...
    def useLayerName(self) -> bool: ...
    def useName(self) -> bool: ...

class GpIdSupport:
    def generateGpId(self) -> str: ...
    def getNextGpId(self) -> int: ...
    def setNextGpId(self, int: int) -> None: ...

class IllegalBuildException(java.lang.RuntimeException):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class PropertyProducer:
    def getProperty(self, object: typing.Any) -> typing.Any: ...

class AbstractBuildable(VASSAL.search.AbstractImageFinder, Buildable, VASSAL.configure.ValidityChecker, VASSAL.build.module.properties.PropertyNameSource, VASSAL.script.expression.Auditable):
    def __init__(self): ...
    def add(self, buildable: Buildable) -> None: ...
    def addImageNamesRecursively(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    _getAllDescendantComponentsOf__T = typing.TypeVar('_getAllDescendantComponentsOf__T')  # <T>
    def getAllDescendantComponentsOf(self, class_: typing.Type[_getAllDescendantComponentsOf__T]) -> java.util.List[_getAllDescendantComponentsOf__T]: ...
    def getAncestor(self) -> Buildable: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBuildComponents(self) -> java.util.Enumeration[Buildable]: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def getBuildables(self) -> java.util.List[Buildable]: ...
    _getComponentsOf__T = typing.TypeVar('_getComponentsOf__T')  # <T>
    def getComponentsOf(self, class_: typing.Type[_getComponentsOf__T]) -> java.util.List[_getComponentsOf__T]: ...
    def getNonFolderAncestor(self) -> Buildable: ...
    def getPropertyNames(self) -> java.util.List[str]: ...
    def setAncestor(self, buildable: Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def validate(self, buildable: Buildable, validationReport: VASSAL.configure.ValidationReport) -> None: ...

class AutoConfigurable(Configurable):
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class Util:
        def __init__(self): ...
        @staticmethod
        def buildAttributes(element: org.w3c.dom.Element, autoConfigurable: 'AutoConfigurable') -> None: ...
        @staticmethod
        def getBuildElement(document: org.w3c.dom.Document, autoConfigurable: 'AutoConfigurable') -> org.w3c.dom.Element: ...

class AbstractConfigurable(AbstractBuildable, AutoConfigurable, VASSAL.search.SearchTarget):
    def __init__(self): ...
    def add(self, buildable: Buildable) -> None: ...
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    def getConfigureComponents(self) -> typing.List[Configurable]: ...
    def getConfigureName(self) -> str: ...
    def getConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def getLocalizedConfigureName(self) -> str: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getPropertyList(self) -> java.util.List[str]: ...
    def remove(self, buildable: Buildable) -> None: ...
    def removePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def setConfigureName(self, string: str) -> None: ...

class AbstractFolder(AbstractConfigurable):
    NAME: typing.ClassVar[str] = ...
    DESCRIPTION: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: Buildable) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def removeFrom(self, buildable: Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class AbstractToolbarItem(AbstractConfigurable):
    NAME: typing.ClassVar[str] = ...
    TOOLTIP: typing.ClassVar[str] = ...
    BUTTON_TEXT: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    ICON: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addLocalImageNames(self, collection: typing.Union[java.util.Collection[str], typing.Sequence[str], typing.Set[str]]) -> None: ...
    def addTo(self, buildable: Buildable) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getLaunchButton(self) -> VASSAL.tools.LaunchButton: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def removeFrom(self, buildable: Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class IconConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class GameModule(AbstractConfigurable, VASSAL.command.CommandEncoder, VASSAL.tools.ToolBarComponent, VASSAL.build.module.properties.PropertySource, VASSAL.build.module.properties.MutablePropertiesContainer, VASSAL.build.module.properties.TranslatableStringContainer, GpIdSupport):
    MODULE_NAME: typing.ClassVar[str] = ...
    MODULE_VERSION: typing.ClassVar[str] = ...
    DESCRIPTION: typing.ClassVar[str] = ...
    VASSAL_VERSION_CREATED: typing.ClassVar[str] = ...
    VASSAL_VERSION_RUNNING: typing.ClassVar[str] = ...
    NEXT_PIECESLOT_ID: typing.ClassVar[str] = ...
    BUILDFILE: typing.ClassVar[str] = ...
    BUILDFILE_OLD: typing.ClassVar[str] = ...
    REAL_NAME: typing.ClassVar[str] = ...
    SECRET_NAME: typing.ClassVar[str] = ...
    PERSONAL_INFO: typing.ClassVar[str] = ...
    MODULE_NAME_PROPERTY: typing.ClassVar[str] = ...
    MODULE_VERSION_PROPERTY: typing.ClassVar[str] = ...
    MODULE_DESCRIPTION_PROPERTY: typing.ClassVar[str] = ...
    MODULE_OTHER1_PROPERTY: typing.ClassVar[str] = ...
    MODULE_OTHER2_PROPERTY: typing.ClassVar[str] = ...
    MODULE_VASSAL_VERSION_CREATED_PROPERTY: typing.ClassVar[str] = ...
    MODULE_VASSAL_VERSION_RUNNING_PROPERTY: typing.ClassVar[str] = ...
    MODULE_CURRENT_LOCALE: typing.ClassVar[str] = ...
    MODULE_CURRENT_LOCALE_NAME: typing.ClassVar[str] = ...
    DRAWING_MOUSEOVER_PROPERTY: typing.ClassVar[str] = ...
    def __init__(self, dataArchive: VASSAL.tools.DataArchive): ...
    def addCommandEncoder(self, commandEncoder: VASSAL.command.CommandEncoder) -> None: ...
    def addIdChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def addKeyStrokeListener(self, keyStrokeListener: VASSAL.tools.KeyStrokeListener) -> None: ...
    def addKeyStrokeSource(self, keyStrokeSource: VASSAL.tools.KeyStrokeSource) -> None: ...
    def addMutableProperty(self, string: str, mutableProperty: VASSAL.build.module.properties.MutableProperty) -> None: ...
    def addSideChangeListenerToPlayerRoster(self, sideChangeListener: typing.Union[VASSAL.build.module.PlayerRoster.SideChangeListener, typing.Callable]) -> None: ...
    def addTo(self, buildable: Buildable) -> None: ...
    def addTranslatableString(self, string: str, translatableString: VASSAL.build.module.properties.TranslatableString) -> None: ...
    def appendToTitle(self, string: str) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def clearPausedCommands(self) -> None: ...
    @staticmethod
    def clearTempUserId() -> None: ...
    @typing.overload
    def createPiece(self, string: str) -> VASSAL.counters.GamePiece: ...
    @typing.overload
    def createPiece(self, string: str, gamePiece: VASSAL.counters.GamePiece) -> VASSAL.counters.GamePiece: ...
    def decode(self, string: str) -> VASSAL.command.Command: ...
    def encode(self, command: VASSAL.command.Command) -> str: ...
    def fireKeyStroke(self, namedKeyStroke: VASSAL.tools.NamedKeyStroke) -> None: ...
    def generateGpId(self) -> str: ...
    @staticmethod
    def getActiveUserId() -> str: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getArchiveWriter(self) -> VASSAL.tools.ArchiveWriter: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getChatter(self) -> VASSAL.build.module.Chatter: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getConsole(self) -> VASSAL.build.module.Console: ...
    def getControlPanel(self) -> javax.swing.JComponent: ...
    def getCrc(self) -> int: ...
    def getDataArchive(self) -> VASSAL.tools.DataArchive: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getFileChooser(self) -> VASSAL.tools.filechooser.FileChooser: ...
    def getFrame(self) -> javax.swing.JFrame: ...
    def getGameFile(self) -> str: ...
    def getGameFileMode(self) -> 'GameModule.GameFileMode': ...
    @staticmethod
    def getGameModule() -> 'GameModule': ...
    def getGameName(self) -> str: ...
    def getGameState(self) -> VASSAL.build.module.GameState: ...
    def getGameVersion(self) -> str: ...
    def getGpIdSupport(self) -> GpIdSupport: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getI18nData(self) -> VASSAL.i18n.ComponentI18nData: ...
    def getI18nPrefix(self) -> str: ...
    def getImageTileSource(self) -> VASSAL.tools.image.ImageTileSource: ...
    def getLocalizedGameName(self) -> str: ...
    def getLocalizedProperty(self, object: typing.Any) -> typing.Any: ...
    def getLogger(self) -> VASSAL.command.Logger: ...
    def getMutablePropertiesContainerId(self) -> str: ...
    def getMutableProperty(self, string: str) -> VASSAL.build.module.properties.MutableProperty: ...
    def getNextGpId(self) -> int: ...
    def getPieceWindow(self) -> VASSAL.build.module.PieceWindow: ...
    def getPlayerRoster(self) -> VASSAL.build.module.PlayerRoster: ...
    def getPlayerWindow(self) -> VASSAL.launch.PlayerWindow: ...
    def getPrefs(self) -> VASSAL.preferences.Prefs: ...
    def getProperty(self, object: typing.Any) -> typing.Any: ...
    def getRNG(self) -> java.util.Random: ...
    def getResourcePathFinder(self) -> VASSAL.tools.ResourcePathFinder: ...
    def getServer(self) -> VASSAL.build.module.ServerConnection: ...
    def getServerControls(self) -> VASSAL.chat.ui.ChatServerControls: ...
    @staticmethod
    def getTempUserId() -> str: ...
    def getTitleString(self) -> str: ...
    def getToolBar(self) -> javax.swing.JToolBar: ...
    def getTranslatableString(self, string: str) -> VASSAL.build.module.properties.TranslatableString: ...
    def getTranslatableStringContainerId(self) -> str: ...
    @staticmethod
    def getUserId() -> str: ...
    @typing.overload
    def getWindowTitleString(self, string: str, string2: str) -> str: ...
    @typing.overload
    def getWindowTitleString(self, string: str, string2: str, boolean: bool) -> str: ...
    def getWizardSupport(self) -> VASSAL.build.module.WizardSupport: ...
    @staticmethod
    def init(gameModule: 'GameModule') -> None: ...
    def initFrameTitle(self) -> None: ...
    def isEditorOpen(self) -> bool: ...
    @staticmethod
    def isErrorLogToChat() -> bool: ...
    def isLoadOverSemaphore(self) -> bool: ...
    def isLoadingContinuationSemaphore(self) -> bool: ...
    def isLocalizationEnabled(self) -> bool: ...
    def isMatSupport(self) -> bool: ...
    def isMultiPlayer(self) -> bool: ...
    def isRefreshingSemaphore(self) -> bool: ...
    def isReplayingOrLogging(self) -> bool: ...
    def isTranslatableSupport(self) -> bool: ...
    def pauseLogging(self) -> bool: ...
    def quit(self) -> None: ...
    def refreshKeyStrokeListeners(self) -> None: ...
    def removeCommandEncoder(self, commandEncoder: VASSAL.command.CommandEncoder) -> None: ...
    def removeFrom(self, buildable: Buildable) -> None: ...
    def removeIdChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def removeKeyStrokeListener(self, keyStrokeListener: VASSAL.tools.KeyStrokeListener) -> None: ...
    def removeMutableProperty(self, string: str) -> VASSAL.build.module.properties.MutableProperty: ...
    def removeSideChangeListenerFromPlayerRoster(self, sideChangeListener: typing.Union[VASSAL.build.module.PlayerRoster.SideChangeListener, typing.Callable]) -> None: ...
    def removeTranslatableString(self, string: str) -> VASSAL.build.module.properties.TranslatableString: ...
    def resetSourcesAndListeners(self) -> None: ...
    def resumeLogging(self) -> VASSAL.command.Command: ...
    def save(self) -> None: ...
    def saveAs(self) -> None: ...
    def sendAndLog(self, command: VASSAL.command.Command) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setChatter(self, chatter: VASSAL.build.module.Chatter) -> None: ...
    def setDirty(self, boolean: bool) -> None: ...
    @staticmethod
    def setErrorLogToChat(boolean: bool) -> None: ...
    def setGameFile(self, string: str, gameFileMode: 'GameModule.GameFileMode') -> None: ...
    def setGameFileMode(self, gameFileMode: 'GameModule.GameFileMode') -> None: ...
    def setGpIdSupport(self, gpIdSupport: GpIdSupport) -> None: ...
    def setLoadOverSemaphore(self, boolean: bool) -> None: ...
    def setLoadingContinuationSemaphore(self, boolean: bool) -> None: ...
    def setMatSupport(self, boolean: bool) -> None: ...
    def setNextGpId(self, int: int) -> None: ...
    def setPieceWindow(self, pieceWindow: VASSAL.build.module.PieceWindow) -> None: ...
    def setPrefs(self, prefs: VASSAL.preferences.Prefs) -> None: ...
    def setRefreshingSemaphore(self, boolean: bool) -> None: ...
    @staticmethod
    def setTempUserId(string: str) -> None: ...
    @staticmethod
    def setUserId(string: str) -> None: ...
    def shutDown(self) -> bool: ...
    def toString(self) -> str: ...
    def updateLastSave(self) -> None: ...
    def updateTitleBar(self) -> None: ...
    def warn(self, string: str) -> None: ...
    class GameFileMode(java.lang.Enum['GameModule.GameFileMode']):
        SAVED_GAME: typing.ClassVar['GameModule.GameFileMode'] = ...
        LOADED_GAME: typing.ClassVar['GameModule.GameFileMode'] = ...
        REPLAYED_GAME: typing.ClassVar['GameModule.GameFileMode'] = ...
        REPLAYING_GAME: typing.ClassVar['GameModule.GameFileMode'] = ...
        LOGGING_GAME: typing.ClassVar['GameModule.GameFileMode'] = ...
        LOGGED_GAME: typing.ClassVar['GameModule.GameFileMode'] = ...
        NEW_GAME: typing.ClassVar['GameModule.GameFileMode'] = ...
        def toString(self) -> str: ...
        _valueOf_1__T = typing.TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'GameModule.GameFileMode': ...
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @staticmethod
        def values() -> typing.List['GameModule.GameFileMode']: ...

class Widget(AbstractConfigurable):
    NAME: typing.ClassVar[str] = ...
    WIDTH: typing.ClassVar[str] = ...
    HEIGHT: typing.ClassVar[str] = ...
    def addTo(self, buildable: Buildable) -> None: ...
    def build(self, element: org.w3c.dom.Element) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getBuildElement(self, document: org.w3c.dom.Document) -> org.w3c.dom.Element: ...
    def getChildAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getComponent(self) -> java.awt.Component: ...
    def getConfigureComponents(self) -> typing.List[Configurable]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getParent(self) -> 'Widget': ...
    def getScale(self) -> float: ...
    def hasScale(self) -> bool: ...
    def removeFrom(self, buildable: Buildable) -> None: ...
    class MyCellRenderer(javax.swing.DefaultListCellRenderer):
        def __init__(self): ...
        def getListCellRendererComponent(self, jList: javax.swing.JList, object: typing.Any, int: int, boolean: bool, boolean2: bool) -> java.awt.Component: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.build")``.

    AbstractBuildable: typing.Type[AbstractBuildable]
    AbstractConfigurable: typing.Type[AbstractConfigurable]
    AbstractFolder: typing.Type[AbstractFolder]
    AbstractToolbarItem: typing.Type[AbstractToolbarItem]
    AutoConfigurable: typing.Type[AutoConfigurable]
    BadDataReport: typing.Type[BadDataReport]
    Buildable: typing.Type[Buildable]
    Builder: typing.Type[Builder]
    Configurable: typing.Type[Configurable]
    GameModule: typing.Type[GameModule]
    GpIdChecker: typing.Type[GpIdChecker]
    GpIdSupport: typing.Type[GpIdSupport]
    IllegalBuildException: typing.Type[IllegalBuildException]
    PropertyProducer: typing.Type[PropertyProducer]
    Widget: typing.Type[Widget]
    module: VASSAL.build.module.__module_protocol__
    widget: VASSAL.build.widget.__module_protocol__
