import VASSAL.build.module
import VASSAL.script.expression
import VASSAL.tools
import java.util
import typing



class DieServer(VASSAL.script.expression.Auditable):
    def __init__(self): ...
    def buildInternetRollString(self, rollSet: 'RollSet') -> typing.List[str]: ...
    def doIRoll(self, rollSet: 'RollSet') -> None: ...
    def doInternetRoll(self, rollSet: 'RollSet', formattedString: VASSAL.tools.FormattedString) -> None: ...
    def extractEmail(self, string: str) -> str: ...
    def getDescription(self) -> str: ...
    def getMaxEmails(self) -> int: ...
    def getName(self) -> str: ...
    def getPasswd(self) -> str: ...
    def getPrimaryEmail(self) -> str: ...
    def getSecondaryEmail(self) -> str: ...
    def getUseEmail(self) -> bool: ...
    def getnDiceList(self) -> typing.List[int]: ...
    def getnSideList(self) -> typing.List[int]: ...
    def isPasswdRequired(self) -> bool: ...
    def parseInternetRollString(self, rollSet: 'RollSet', vector: java.util.Vector[str]) -> None: ...
    def reportResult(self, rollSet: 'RollSet', formattedString: VASSAL.tools.FormattedString) -> None: ...
    def roll(self, rollSet: 'RollSet', formattedString: VASSAL.tools.FormattedString) -> None: ...
    def setPasswd(self, string: str) -> None: ...
    def setPrimaryEmail(self, string: str) -> None: ...
    def setSecondaryEmail(self, string: str) -> None: ...
    def setUseEmail(self, boolean: bool) -> None: ...

class RollSet:
    description: str = ...
    dieRolls: typing.List[VASSAL.build.module.DieRoll] = ...
    def __init__(self, string: str, dieRollArray: typing.List[VASSAL.build.module.DieRoll]): ...
    def getDescription(self) -> str: ...
    def getDieRolls(self) -> typing.List[VASSAL.build.module.DieRoll]: ...
    def getMaxDescLength(self) -> int: ...
    def setDescription(self, string: str) -> None: ...

class BonesDiceServer(DieServer):
    def __init__(self): ...
    def buildInternetRollString(self, rollSet: RollSet) -> typing.List[str]: ...
    def doIRoll(self, rollSet: RollSet) -> None: ...
    def parseInternetRollString(self, rollSet: RollSet, vector: java.util.Vector[str]) -> None: ...
    def roll(self, rollSet: RollSet, formattedString: VASSAL.tools.FormattedString) -> None: ...

class ShadowDiceDieServer(DieServer):
    ROLL_MARKER: typing.ClassVar[str] = ...
    def __init__(self): ...
    def buildInternetRollString(self, rollSet: RollSet) -> typing.List[str]: ...
    def hexify(self, string: str) -> str: ...
    def parseInternetRollString(self, rollSet: RollSet, vector: java.util.Vector[str]) -> None: ...
    def roll(self, rollSet: RollSet, formattedString: VASSAL.tools.FormattedString) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.build.module.dice")``.

    BonesDiceServer: typing.Type[BonesDiceServer]
    DieServer: typing.Type[DieServer]
    RollSet: typing.Type[RollSet]
    ShadowDiceDieServer: typing.Type[ShadowDiceDieServer]
