import VASSAL.build
import VASSAL.build.module.documentation
import VASSAL.configure
import VASSAL.counters
import VASSAL.i18n
import VASSAL.tools
import java.awt
import java.awt.event
import java.util
import javax.swing
import typing



class DeckKeyCommand:
    def deregisterListeners(self) -> None: ...
    def getAdditionalReportProperties(self) -> typing.List[str]: ...
    def getKeyCommands(self, deck: VASSAL.counters.Deck) -> java.util.List[VASSAL.counters.KeyCommand]: ...
    def registerListeners(self, deck: VASSAL.counters.Deck) -> None: ...

class SortParameter:
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, boolean: bool, boolean2: bool): ...
    def decode(self, string: str) -> None: ...
    def encode(self) -> str: ...
    def getSortProperty(self) -> str: ...
    def isDescendingSort(self) -> bool: ...
    def isNumericSort(self) -> bool: ...
    def setDescendingSort(self, boolean: bool) -> None: ...
    def setNumericSort(self, boolean: bool) -> None: ...
    def setSortProperty(self, string: str) -> None: ...
    def setValue(self, sortParameter: 'SortParameter') -> None: ...
    def toString(self) -> str: ...

class SortParameterArrayConfigurer(VASSAL.configure.Configurer, VASSAL.configure.ConfigurableList):
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, object: typing.Any): ...
    def addEntry(self) -> None: ...
    @staticmethod
    def decode(string: str) -> java.util.List[SortParameter]: ...
    def deleteEntry(self, configurableListEntry: VASSAL.configure.ConfigurableListEntry) -> None: ...
    @staticmethod
    def encode(list: java.util.List[SortParameter]) -> str: ...
    def entryChanged(self, configurableListEntry: VASSAL.configure.ConfigurableListEntry) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getListController(self) -> javax.swing.JComponent: ...
    def getSelectedEntryIndex(self) -> int: ...
    def getSortParameterListValue(self) -> java.util.List[SortParameter]: ...
    def getValueString(self) -> str: ...
    def moveEntryDown(self) -> None: ...
    def moveEntryUp(self) -> None: ...
    def repack(self) -> None: ...
    def selectEntry(self, configurableListEntry: VASSAL.configure.ConfigurableListEntry) -> None: ...
    def setSelectedEntryIndex(self, int: int) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class SortParameterComparator(java.util.Comparator[VASSAL.counters.GamePiece]):
    def __init__(self, list: java.util.List[SortParameter]): ...
    def compare(self, gamePiece: VASSAL.counters.GamePiece, gamePiece2: VASSAL.counters.GamePiece) -> int: ...

class SortParameterConfigurer(VASSAL.configure.Configurer):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, object: typing.Any): ...
    @typing.overload
    def __init__(self, string: str, string2: str, object: typing.Any): ...
    def addFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getValueString(self) -> str: ...
    def removeFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def requestFocus(self) -> None: ...
    def setFrozen(self, boolean: bool) -> None: ...
    def setHighlighted(self, boolean: bool) -> None: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class AbstractDeckKeyCommand(VASSAL.build.AbstractConfigurable, DeckKeyCommand):
    DESCRIPTION: typing.ClassVar[str] = ...
    MENU_TEXT: typing.ClassVar[str] = ...
    REPORT_FORMAT: typing.ClassVar[str] = ...
    HOTKEY: typing.ClassVar[str] = ...
    COMMAND_NAME: typing.ClassVar[str] = ...
    DECK_NAME: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAdditionalReportProperties(self) -> typing.List[str]: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getDescription(self) -> str: ...
    def getFormattedStringList(self) -> java.util.List[str]: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getKeyStroke(self) -> VASSAL.tools.NamedKeyStroke: ...
    def getMenuTextList(self) -> java.util.List[str]: ...
    def getNamedKeyStrokeList(self) -> java.util.List[VASSAL.tools.NamedKeyStroke]: ...
    def getReportFormat(self) -> VASSAL.tools.FormattedString: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class DeckReportFormatConfig(VASSAL.i18n.TranslatableConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class DeckSendKeyCommand(AbstractDeckKeyCommand):
    TARGET_DECK: typing.ClassVar[str] = ...
    VARIABLE_DECK: typing.ClassVar[str] = ...
    DECK_EXPRESSION: typing.ClassVar[str] = ...
    SEND_MATCHING: typing.ClassVar[str] = ...
    MATCH_EXPRESSION: typing.ClassVar[str] = ...
    LIMIT_TOTAL: typing.ClassVar[str] = ...
    LIMIT_EXPRESSION: typing.ClassVar[str] = ...
    STOP: typing.ClassVar[str] = ...
    STOP_EXPRESSION: typing.ClassVar[str] = ...
    STOP_INCLUDE: typing.ClassVar[str] = ...
    ORDER: typing.ClassVar[str] = ...
    SENT_COUNT: typing.ClassVar[str] = ...
    def __init__(self): ...
    def deregisterListeners(self) -> None: ...
    def getAdditionalReportProperties(self) -> typing.List[str]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getAttributeVisibility(self, string: str) -> VASSAL.configure.VisibilityCondition: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDeckExpression(self) -> VASSAL.tools.FormattedString: ...
    def getExpressionList(self) -> java.util.List[str]: ...
    def getKeyCommands(self, deck: VASSAL.counters.Deck) -> java.util.List[VASSAL.counters.KeyCommand]: ...
    def getLimitExpression(self) -> VASSAL.tools.FormattedString: ...
    def getMatchExpression(self) -> VASSAL.tools.FormattedString: ...
    def getSendListener(self) -> VASSAL.tools.NamedKeyStrokeListener: ...
    def getStopExpresson(self) -> VASSAL.tools.FormattedString: ...
    def getTargetDeck(self) -> str: ...
    def isLimitTotal(self) -> bool: ...
    def isSendMatching(self) -> bool: ...
    def isStop(self) -> bool: ...
    def isStopInclude(self) -> bool: ...
    def isVariableDeck(self) -> bool: ...
    def registerListeners(self, deck: VASSAL.counters.Deck) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...

class DeckSortKeyCommand(AbstractDeckKeyCommand):
    SORT_PARAMETERS: typing.ClassVar[str] = ...
    def __init__(self): ...
    def deregisterListeners(self) -> None: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getKeyCommands(self, deck: VASSAL.counters.Deck) -> java.util.List[VASSAL.counters.KeyCommand]: ...
    def getSortParameters(self) -> java.util.List[SortParameter]: ...
    def registerListeners(self, deck: VASSAL.counters.Deck) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    class SortParameterConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.build.module.map.deck")``.

    AbstractDeckKeyCommand: typing.Type[AbstractDeckKeyCommand]
    DeckKeyCommand: typing.Type[DeckKeyCommand]
    DeckSendKeyCommand: typing.Type[DeckSendKeyCommand]
    DeckSortKeyCommand: typing.Type[DeckSortKeyCommand]
    SortParameter: typing.Type[SortParameter]
    SortParameterArrayConfigurer: typing.Type[SortParameterArrayConfigurer]
    SortParameterComparator: typing.Type[SortParameterComparator]
    SortParameterConfigurer: typing.Type[SortParameterConfigurer]
