import VASSAL.build
import VASSAL.build.module.documentation
import VASSAL.configure
import java.awt
import java.awt.event
import java.io
import javax.swing
import jpype.protocol
import typing



class BasicPreference(VASSAL.build.AbstractConfigurable):
    NAME: typing.ClassVar[str] = ...
    TAB: typing.ClassVar[str] = ...
    DESC: typing.ClassVar[str] = ...
    DEFAULT: typing.ClassVar[str] = ...
    def __init__(self): ...
    def addTo(self, buildable: VASSAL.build.Buildable) -> None: ...
    def getAllowableConfigureComponents(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getDefaultClass(self) -> typing.Type[typing.Any]: ...
    def getDefaultValue(self) -> str: ...
    def getDescription(self) -> str: ...
    def getHelpFile(self) -> VASSAL.build.module.documentation.HelpFile: ...
    def getPreferenceConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getVariableName(self) -> str: ...
    def removeFrom(self, buildable: VASSAL.build.Buildable) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setDefaultValue(self, object: typing.Any) -> None: ...
    class NoteConfig(VASSAL.configure.ConfigurerFactory):
        def __init__(self): ...
        def getConfigurer(self, autoConfigurable: VASSAL.build.AutoConfigurable, string: str, string2: str) -> VASSAL.configure.Configurer: ...

class PositionOption(VASSAL.configure.Configurer, java.awt.event.ComponentListener):
    key: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self, string: str, window: java.awt.Window): ...
    @typing.overload
    def __init__(self, string: str, window: java.awt.Window, rectangle: java.awt.Rectangle): ...
    def componentHidden(self, componentEvent: java.awt.event.ComponentEvent) -> None: ...
    def componentMoved(self, componentEvent: java.awt.event.ComponentEvent) -> None: ...
    def componentResized(self, componentEvent: java.awt.event.ComponentEvent) -> None: ...
    def componentShown(self, componentEvent: java.awt.event.ComponentEvent) -> None: ...
    def getControls(self) -> java.awt.Component: ...
    def getValue(self) -> typing.Any: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...

class Prefs(java.io.Closeable):
    MODULES_DIR_KEY: typing.ClassVar[str] = ...
    DISABLE_D3D: typing.ClassVar[str] = ...
    DISABLE_OGL_FBO: typing.ClassVar[str] = ...
    BAD_DATA_AUDIT_TRAILS: typing.ClassVar[str] = ...
    MAIN_WINDOW_REMEMBER: typing.ClassVar[str] = ...
    MAIN_WINDOW_HEIGHT: typing.ClassVar[str] = ...
    MAIN_WINDOW_WIDTH: typing.ClassVar[str] = ...
    OVERRIDE_DEFAULT_FONT_SIZE: typing.ClassVar[str] = ...
    TRANSLATABLE_SUPPORT: typing.ClassVar[str] = ...
    def __init__(self, prefsEditor: 'PrefsEditor', string: str): ...
    @typing.overload
    def addOption(self, string: str, configurer: VASSAL.configure.Configurer, string2: str) -> None: ...
    @typing.overload
    def addOption(self, configurer: VASSAL.configure.Configurer) -> None: ...
    @typing.overload
    def addOption(self, string: str, configurer: VASSAL.configure.Configurer) -> None: ...
    def close(self) -> None: ...
    def getEditor(self) -> 'PrefsEditor': ...
    def getFile(self) -> java.io.File: ...
    @staticmethod
    def getGlobalPrefs() -> 'Prefs': ...
    def getOption(self, string: str) -> VASSAL.configure.Configurer: ...
    def getStoredValue(self, string: str) -> str: ...
    def getValue(self, string: str) -> typing.Any: ...
    @staticmethod
    def initSharedGlobalPrefs() -> None: ...
    def isDisableAutoWrite(self) -> bool: ...
    @staticmethod
    def sanitize(string: str) -> str: ...
    def save(self) -> None: ...
    def setDisableAutoWrite(self, boolean: bool) -> None: ...
    def setValue(self, string: str, object: typing.Any) -> None: ...
    def write(self) -> None: ...

class PrefsEditor:
    def __init__(self): ...
    @typing.overload
    def addOption(self, string: str, configurer: VASSAL.configure.Configurer) -> None: ...
    @typing.overload
    def addOption(self, string: str, configurer: VASSAL.configure.Configurer, string2: str) -> None: ...
    def addPrefs(self, prefs: Prefs) -> None: ...
    def close(self) -> None: ...
    def getDialog(self) -> javax.swing.JDialog: ...
    def getEditAction(self) -> javax.swing.Action: ...
    def initDialog(self, frame: java.awt.Frame) -> None: ...
    def write(self) -> None: ...

class ReadOnlyPrefs:
    def __init__(self, string: str): ...
    @staticmethod
    def getGlobalPrefs() -> 'ReadOnlyPrefs': ...
    def getStoredValue(self, string: str) -> str: ...

class BooleanPreference(BasicPreference):
    def __init__(self): ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDefaultClass(self) -> typing.Type[typing.Any]: ...
    def getDefaultValue(self) -> str: ...
    def getPreferenceConfigurer(self) -> VASSAL.configure.Configurer: ...
    def setDefaultValue(self, object: typing.Any) -> None: ...

class DoublePreference(BasicPreference):
    def __init__(self): ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDefaultClass(self) -> typing.Type[typing.Any]: ...
    def getDefaultValue(self) -> str: ...
    def getPreferenceConfigurer(self) -> VASSAL.configure.Configurer: ...
    def setDefaultValue(self, object: typing.Any) -> None: ...

class EnumPreference(BasicPreference):
    LIST: typing.ClassVar[str] = ...
    def __init__(self): ...
    def getAttributeDescriptions(self) -> typing.List[str]: ...
    def getAttributeNames(self) -> typing.List[str]: ...
    def getAttributeTypes(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getAttributeValueString(self, string: str) -> str: ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDefaultClass(self) -> typing.Type[typing.Any]: ...
    def getDefaultValue(self) -> str: ...
    def getPreferenceConfigurer(self) -> VASSAL.configure.Configurer: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setDefaultValue(self, object: typing.Any) -> None: ...

class GlobalPrefs(Prefs):
    @typing.overload
    def __init__(self, prefsEditor: PrefsEditor, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, prefsEditor: PrefsEditor, string: str): ...
    @typing.overload
    def addOption(self, string: str, configurer: VASSAL.configure.Configurer, string2: str) -> None: ...
    @typing.overload
    def addOption(self, configurer: VASSAL.configure.Configurer) -> None: ...
    @typing.overload
    def addOption(self, string: str, configurer: VASSAL.configure.Configurer) -> None: ...
    def isDisableAutoWrite(self) -> bool: ...
    def saveGlobal(self) -> None: ...
    def setDisableAutoWrite(self, boolean: bool) -> None: ...

class IntegerPreference(BasicPreference):
    def __init__(self): ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDefaultClass(self) -> typing.Type[typing.Any]: ...
    def getDefaultValue(self) -> str: ...
    def getPreferenceConfigurer(self) -> VASSAL.configure.Configurer: ...
    def setDefaultValue(self, object: typing.Any) -> None: ...

class StringPreference(BasicPreference):
    def __init__(self): ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDefaultClass(self) -> typing.Type[typing.Any]: ...
    def getDefaultValue(self) -> str: ...
    def getPreferenceConfigurer(self) -> VASSAL.configure.Configurer: ...
    def setDefaultValue(self, object: typing.Any) -> None: ...

class TextPreference(BasicPreference):
    def __init__(self): ...
    @staticmethod
    def getConfigureTypeName() -> str: ...
    def getDefaultClass(self) -> typing.Type[typing.Any]: ...
    def getDefaultValue(self) -> str: ...
    def getPreferenceConfigurer(self) -> VASSAL.configure.Configurer: ...
    def setDefaultValue(self, object: typing.Any) -> None: ...

class VisibilityOption(PositionOption):
    def __init__(self, string: str, window: java.awt.Window): ...
    def componentHidden(self, componentEvent: java.awt.event.ComponentEvent) -> None: ...
    def componentShown(self, componentEvent: java.awt.event.ComponentEvent) -> None: ...
    def getValueString(self) -> str: ...
    @typing.overload
    def setValue(self, object: typing.Any) -> None: ...
    @typing.overload
    def setValue(self, string: str) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.preferences")``.

    BasicPreference: typing.Type[BasicPreference]
    BooleanPreference: typing.Type[BooleanPreference]
    DoublePreference: typing.Type[DoublePreference]
    EnumPreference: typing.Type[EnumPreference]
    GlobalPrefs: typing.Type[GlobalPrefs]
    IntegerPreference: typing.Type[IntegerPreference]
    PositionOption: typing.Type[PositionOption]
    Prefs: typing.Type[Prefs]
    PrefsEditor: typing.Type[PrefsEditor]
    ReadOnlyPrefs: typing.Type[ReadOnlyPrefs]
    StringPreference: typing.Type[StringPreference]
    TextPreference: typing.Type[TextPreference]
    VisibilityOption: typing.Type[VisibilityOption]
