import VASSAL
import VASSAL.build
import VASSAL.build.module.properties
import VASSAL.configure
import VASSAL.counters
import VASSAL.script.expression
import VASSAL.tools.bug
import VASSAL.tools.concurrent
import VASSAL.tools.deprecation
import VASSAL.tools.filechooser
import VASSAL.tools.icon
import VASSAL.tools.image
import VASSAL.tools.imageop
import VASSAL.tools.imports
import VASSAL.tools.io
import VASSAL.tools.lang
import VASSAL.tools.logging
import VASSAL.tools.menu
import VASSAL.tools.opcache
import VASSAL.tools.swing
import VASSAL.tools.version
import java.awt
import java.awt.event
import java.awt.image
import java.io
import java.lang
import java.net
import java.nio.file
import java.security
import java.util
import java.util.concurrent
import javax.swing
import javax.swing.event
import jpype.protocol
import typing



class ActionManager:
    @typing.overload
    def addAction(self, object: typing.Any, action: javax.swing.Action) -> javax.swing.Action: ...
    @typing.overload
    def addAction(self, action: javax.swing.Action) -> javax.swing.Action: ...
    def getAction(self, object: typing.Any) -> javax.swing.Action: ...
    def getActionIds(self) -> java.util.Set[typing.Any]: ...
    @staticmethod
    def getInstance() -> 'ActionManager': ...
    def isEnabled(self, object: typing.Any) -> bool: ...
    def removeAction(self, object: typing.Any) -> javax.swing.Action: ...
    def setEnabled(self, object: typing.Any, boolean: bool) -> None: ...

class ApplicationIcons:
    VASSAL_ICON_LARGE: typing.ClassVar[str] = ...
    @typing.overload
    @staticmethod
    def setFor(jDialog: javax.swing.JDialog) -> None: ...
    @typing.overload
    @staticmethod
    def setFor(jFrame: javax.swing.JFrame) -> None: ...

class ArgsParser:
    def __init__(self, stringArray: typing.List[str]): ...
    def getProperties(self) -> java.util.Properties: ...

_ArrayIterator__T = typing.TypeVar('_ArrayIterator__T')  # <T>
class ArrayIterator(java.util.Iterator[_ArrayIterator__T], typing.Generic[_ArrayIterator__T]):
    def __init__(self, *t: _ArrayIterator__T): ...
    def hasNext(self) -> bool: ...
    def next(self) -> _ArrayIterator__T: ...
    def remove(self) -> None: ...

class ArrayUtils:
    _append_12__T = typing.TypeVar('_append_12__T')  # <T>
    _append_12__X = typing.TypeVar('_append_12__X')  # <X>
    _append_12__Y = typing.TypeVar('_append_12__Y')  # <Y>
    _append_13__T = typing.TypeVar('_append_13__T')  # <T>
    _append_13__X = typing.TypeVar('_append_13__X')  # <X>
    _append_13__Y = typing.TypeVar('_append_13__Y')  # <Y>
    _append_14__T = typing.TypeVar('_append_14__T')  # <T>
    _append_15__T = typing.TypeVar('_append_15__T')  # <T>
    @typing.overload
    @staticmethod
    def append(booleanArray: typing.List[bool], boolean2: bool) -> typing.List[bool]: ...
    @typing.overload
    @staticmethod
    def append(booleanArray: typing.List[bool], *boolean2: bool) -> typing.List[bool]: ...
    @typing.overload
    @staticmethod
    def append(byteArray: typing.List[int], byte2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def append(byteArray: typing.List[int], *byte2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def append(charArray: typing.List[str], char2: str) -> typing.List[str]: ...
    @typing.overload
    @staticmethod
    def append(charArray: typing.List[str], *char2: str) -> typing.List[str]: ...
    @typing.overload
    @staticmethod
    def append(doubleArray: typing.List[float], double2: float) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def append(doubleArray: typing.List[float], *double2: float) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def append(floatArray: typing.List[float], float2: float) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def append(floatArray: typing.List[float], *float2: float) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def append(intArray: typing.List[int], int2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def append(intArray: typing.List[int], *int2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def append(class_: typing.Type[typing.List[_append_12__T]], xArray: typing.List[_append_12__X], y: _append_12__Y) -> typing.List[_append_12__T]: ...
    @typing.overload
    @staticmethod
    def append(class_: typing.Type[typing.List[_append_13__T]], xArray: typing.List[_append_13__X], *y: _append_13__Y) -> typing.List[_append_13__T]: ...
    @typing.overload
    @staticmethod
    def append(tArray: typing.List[_append_14__T], t2: _append_14__T) -> typing.List[_append_14__T]: ...
    @typing.overload
    @staticmethod
    def append(tArray: typing.List[_append_15__T], *t2: _append_15__T) -> typing.List[_append_15__T]: ...
    @typing.overload
    @staticmethod
    def append(longArray: typing.List[int], long2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def append(longArray: typing.List[int], *long2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def append(shortArray: typing.List[int], short2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def append(shortArray: typing.List[int], *short2: int) -> typing.List[int]: ...
    _insert_12__T = typing.TypeVar('_insert_12__T')  # <T>
    _insert_12__X = typing.TypeVar('_insert_12__X')  # <X>
    _insert_12__Y = typing.TypeVar('_insert_12__Y')  # <Y>
    _insert_13__T = typing.TypeVar('_insert_13__T')  # <T>
    _insert_13__X = typing.TypeVar('_insert_13__X')  # <X>
    _insert_13__Y = typing.TypeVar('_insert_13__Y')  # <Y>
    _insert_14__T = typing.TypeVar('_insert_14__T')  # <T>
    _insert_15__T = typing.TypeVar('_insert_15__T')  # <T>
    @typing.overload
    @staticmethod
    def insert(booleanArray: typing.List[bool], int: int, boolean2: bool) -> typing.List[bool]: ...
    @typing.overload
    @staticmethod
    def insert(booleanArray: typing.List[bool], int: int, *boolean2: bool) -> typing.List[bool]: ...
    @typing.overload
    @staticmethod
    def insert(byteArray: typing.List[int], int: int, byte2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def insert(byteArray: typing.List[int], int: int, *byte2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def insert(charArray: typing.List[str], int: int, char2: str) -> typing.List[str]: ...
    @typing.overload
    @staticmethod
    def insert(charArray: typing.List[str], int: int, *char2: str) -> typing.List[str]: ...
    @typing.overload
    @staticmethod
    def insert(doubleArray: typing.List[float], int: int, double2: float) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def insert(doubleArray: typing.List[float], int: int, *double2: float) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def insert(floatArray: typing.List[float], int: int, float2: float) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def insert(floatArray: typing.List[float], int: int, *float2: float) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def insert(intArray: typing.List[int], int2: int, int3: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def insert(intArray: typing.List[int], int2: int, *int3: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def insert(class_: typing.Type[typing.List[_insert_12__T]], xArray: typing.List[_insert_12__X], int: int, y: _insert_12__Y) -> typing.List[_insert_12__T]: ...
    @typing.overload
    @staticmethod
    def insert(class_: typing.Type[typing.List[_insert_13__T]], xArray: typing.List[_insert_13__X], int: int, *y: _insert_13__Y) -> typing.List[_insert_13__T]: ...
    @typing.overload
    @staticmethod
    def insert(tArray: typing.List[_insert_14__T], int: int, t2: _insert_14__T) -> typing.List[_insert_14__T]: ...
    @typing.overload
    @staticmethod
    def insert(tArray: typing.List[_insert_15__T], int: int, *t2: _insert_15__T) -> typing.List[_insert_15__T]: ...
    @typing.overload
    @staticmethod
    def insert(longArray: typing.List[int], int: int, long2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def insert(longArray: typing.List[int], int: int, *long2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def insert(shortArray: typing.List[int], int: int, short2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def insert(shortArray: typing.List[int], int: int, *short2: int) -> typing.List[int]: ...
    _prepend_6__T = typing.TypeVar('_prepend_6__T')  # <T>
    _prepend_6__X = typing.TypeVar('_prepend_6__X')  # <X>
    _prepend_6__Y = typing.TypeVar('_prepend_6__Y')  # <Y>
    _prepend_7__T = typing.TypeVar('_prepend_7__T')  # <T>
    @typing.overload
    @staticmethod
    def prepend(booleanArray: typing.List[bool], boolean2: bool) -> typing.List[bool]: ...
    @typing.overload
    @staticmethod
    def prepend(byteArray: typing.List[int], byte2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def prepend(charArray: typing.List[str], char2: str) -> typing.List[str]: ...
    @typing.overload
    @staticmethod
    def prepend(doubleArray: typing.List[float], double2: float) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def prepend(floatArray: typing.List[float], float2: float) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def prepend(intArray: typing.List[int], int2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def prepend(class_: typing.Type[typing.List[_prepend_6__T]], xArray: typing.List[_prepend_6__X], y: _prepend_6__Y) -> typing.List[_prepend_6__T]: ...
    @typing.overload
    @staticmethod
    def prepend(tArray: typing.List[_prepend_7__T], t2: _prepend_7__T) -> typing.List[_prepend_7__T]: ...
    @typing.overload
    @staticmethod
    def prepend(longArray: typing.List[int], long2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def prepend(shortArray: typing.List[int], short2: int) -> typing.List[int]: ...
    _remove_2__T = typing.TypeVar('_remove_2__T')  # <T>
    @typing.overload
    @staticmethod
    def remove(floatArray: typing.List[float], float2: float) -> typing.List[float]: ...
    @typing.overload
    @staticmethod
    def remove(intArray: typing.List[int], int2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def remove(tArray: typing.List[_remove_2__T], t2: _remove_2__T) -> typing.List[_remove_2__T]: ...
    @typing.overload
    @staticmethod
    def remove(longArray: typing.List[int], long2: int) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def remove(shortArray: typing.List[int], short2: int) -> typing.List[int]: ...

class AudioClip:
    def play(self) -> None: ...

class BackgroundTask:
    def __init__(self): ...
    def doFirst(self) -> None: ...
    def doLater(self) -> None: ...
    def start(self) -> java.lang.Thread: ...

class BrowserSupport:
    def __init__(self): ...
    @staticmethod
    def getListener() -> javax.swing.event.HyperlinkListener: ...
    @staticmethod
    def openURI(uRI: java.net.URI) -> None: ...
    @typing.overload
    @staticmethod
    def openURL(string: str) -> None: ...
    @typing.overload
    @staticmethod
    def openURL(uRL: java.net.URL) -> None: ...

class BugDialog(javax.swing.JDialog):
    def __init__(self, frame: java.awt.Frame, throwable: java.lang.Throwable): ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    def setVisible(self, boolean: bool) -> None: ...

class BugUtils:
    @staticmethod
    def getErrorLog() -> str: ...
    @staticmethod
    def sendBugReport(string: str, string2: str, string3: str, throwable: java.lang.Throwable) -> None: ...

class ButtonFactory:
    def __init__(self): ...
    @staticmethod
    def getCancelButton() -> javax.swing.JButton: ...
    @typing.overload
    @staticmethod
    def getHelpButton() -> javax.swing.JButton: ...
    @typing.overload
    @staticmethod
    def getHelpButton(action: javax.swing.Action) -> javax.swing.JButton: ...
    @staticmethod
    def getOkButton() -> javax.swing.JButton: ...

class CRCUtils:
    DEFAULT_BUFFER_SIZE: typing.ClassVar[int] = ...
    def __init__(self): ...
    @staticmethod
    def getCRC(list: java.util.List[typing.Union[java.io.File, jpype.protocol.SupportsPath]]) -> int: ...

class ColorButton(javax.swing.JButton):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, color: java.awt.Color): ...
    def setColor(self, color: java.awt.Color) -> None: ...

class ComponentPathBuilder:
    def __init__(self): ...
    def getId(self, configurableArray: typing.List[VASSAL.build.Configurable]) -> str: ...
    @staticmethod
    def getInstance() -> 'ComponentPathBuilder': ...
    def getPath(self, string: str) -> typing.List[VASSAL.build.Configurable]: ...
    class PathFormatException(java.lang.Exception):
        def __init__(self, string: str): ...

class ComponentSplitter:
    def __init__(self): ...
    def getSplitAncestor(self, component: java.awt.Component, int: int) -> java.awt.Component: ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    @staticmethod
    def split(component: java.awt.Component, component2: java.awt.Component, int: int, boolean: bool) -> 'ComponentSplitter.SplitPane': ...
    @staticmethod
    def splitAncestorOf(component: java.awt.Component, int: int) -> java.awt.Component: ...
    def splitBottom(self, component: java.awt.Component, component2: java.awt.Component, boolean: bool) -> 'ComponentSplitter.SplitPane': ...
    def splitLeft(self, component: java.awt.Component, component2: java.awt.Component, boolean: bool) -> 'ComponentSplitter.SplitPane': ...
    def splitRight(self, component: java.awt.Component, component2: java.awt.Component, boolean: bool) -> 'ComponentSplitter.SplitPane': ...
    def splitTop(self, component: java.awt.Component, component2: java.awt.Component, boolean: bool) -> 'ComponentSplitter.SplitPane': ...
    class SplitPane(javax.swing.JSplitPane):
        HIDE_TOP: typing.ClassVar[int] = ...
        HIDE_BOTTOM: typing.ClassVar[int] = ...
        HIDE_LEFT: typing.ClassVar[int] = ...
        HIDE_RIGHT: typing.ClassVar[int] = ...
        def __init__(self, component: java.awt.Component, component2: java.awt.Component, int: int, boolean: bool): ...
        def getBaseComponent(self) -> java.awt.Component: ...
        def getHideableComponent(self) -> java.awt.Component: ...
        def getPreferredSize(self) -> java.awt.Dimension: ...
        def getTransverseSplit(self) -> 'ComponentSplitter.SplitPane': ...
        def hideComponent(self) -> None: ...
        def showComponent(self) -> None: ...
        def toggleVisibility(self) -> None: ...

class DataArchive(java.security.SecureClassLoader, java.io.Closeable):
    IMAGE_DIR: typing.ClassVar[str] = ...
    SOUND_DIR: typing.ClassVar[str] = ...
    ICON_DIR: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    def addExtension(self, dataArchive: 'DataArchive') -> None: ...
    def close(self) -> None: ...
    def contains(self, string: str) -> bool: ...
    def getArchive(self) -> VASSAL.tools.io.FileArchive: ...
    def getCachedAudioClip(self, string: str) -> AudioClip: ...
    @typing.overload
    def getImageNameSet(self) -> java.util.SortedSet[str]: ...
    @typing.overload
    def getImageNameSet(self, boolean: bool, boolean2: bool) -> java.util.SortedSet[str]: ...
    def getImageNames(self) -> typing.List[str]: ...
    def getImagePrefix(self) -> str: ...
    def getInputStream(self, string: str) -> java.io.InputStream: ...
    def getName(self) -> str: ...
    @typing.overload
    def getURL(self) -> java.net.URL: ...
    @typing.overload
    def getURL(self, string: str) -> java.net.URL: ...
    def getWriter(self) -> 'ArchiveWriter': ...
    @typing.overload
    def loadClass(self, string: str) -> typing.Type[typing.Any]: ...
    @typing.overload
    def loadClass(self, string: str, boolean: bool) -> typing.Type[typing.Any]: ...

class DialogUtils:
    @staticmethod
    def enqueue(runnable: typing.Union[java.lang.Runnable, typing.Callable]) -> java.util.concurrent.Future[typing.Any]: ...
    @staticmethod
    def isDisabled(object: typing.Any) -> bool: ...
    @staticmethod
    def setDisabled(object: typing.Any, boolean: bool) -> bool: ...

_EnumeratedIterator__T = typing.TypeVar('_EnumeratedIterator__T')  # <T>
class EnumeratedIterator(java.util.Enumeration[_EnumeratedIterator__T], typing.Generic[_EnumeratedIterator__T]):
    def __init__(self, iterator: java.util.Iterator[_EnumeratedIterator__T]): ...
    def hasMoreElements(self) -> bool: ...
    def nextElement(self) -> _EnumeratedIterator__T: ...

class ErrorDialog:
    @staticmethod
    def addBugHandler(bugHandler: VASSAL.tools.bug.BugHandler) -> None: ...
    @staticmethod
    def bug(throwable: java.lang.Throwable) -> None: ...
    @staticmethod
    def dataError(badDataReport: VASSAL.build.BadDataReport) -> None: ...
    @staticmethod
    def dataWarning(badDataReport: VASSAL.build.BadDataReport) -> None: ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    @typing.overload
    @staticmethod
    def show(component: java.awt.Component, string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(component: java.awt.Component, throwable: java.lang.Throwable, string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(component: java.awt.Component, throwable: java.lang.Throwable, string: str, string2: str, string3: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(throwable: java.lang.Throwable, string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(component: java.awt.Component, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(component: java.awt.Component, throwable: java.lang.Throwable, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(component: java.awt.Component, throwable: java.lang.Throwable, string: str, string2: str, string3: str, string4: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(throwable: java.lang.Throwable, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(component: java.awt.Component, string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(component: java.awt.Component, throwable: java.lang.Throwable, string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(component: java.awt.Component, throwable: java.lang.Throwable, string: str, object: typing.Any, string2: str, string3: str, string4: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(throwable: java.lang.Throwable, string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(component: java.awt.Component, object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(component: java.awt.Component, throwable: java.lang.Throwable, object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(component: java.awt.Component, throwable: java.lang.Throwable, object: typing.Any, string: str, string2: str, string3: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(throwable: java.lang.Throwable, object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @staticmethod
    def showDisableableNoI18N(throwable: java.lang.Throwable, object: typing.Any, string: str, string2: str, string3: str) -> java.util.concurrent.Future[typing.Any]: ...
    @staticmethod
    def showFileOverwriteFailure(fileSystemException: java.nio.file.FileSystemException, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @staticmethod
    def tileWarning(badDataReport: VASSAL.build.BadDataReport) -> None: ...

class FutureUtils:
    @typing.overload
    def wait(self, long: int) -> None: ...
    @typing.overload
    def wait(self) -> None: ...
    @typing.overload
    def wait(self, long: int, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def wait(future: java.util.concurrent.Future[typing.Any]) -> None: ...

class HTTPPostBuilder:
    def __init__(self): ...
    @typing.overload
    def post(self, string: str) -> java.io.InputStream: ...
    @typing.overload
    def post(self, uRL: java.net.URL) -> java.io.InputStream: ...
    @typing.overload
    def setParameter(self, string: str, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    def setParameter(self, string: str, string2: str) -> None: ...
    @typing.overload
    def setParameter(self, string: str, string2: str, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def setParameter(self, string: str, string2: str, string3: str) -> None: ...

class HashCode:
    _hash_13__T = typing.TypeVar('_hash_13__T')  # <T>
    @typing.overload
    @staticmethod
    def hash(boolean: bool) -> int: ...
    @typing.overload
    @staticmethod
    def hash(booleanArray: typing.List[bool]) -> int: ...
    @typing.overload
    @staticmethod
    def hash(byte: int) -> int: ...
    @typing.overload
    @staticmethod
    def hash(byteArray: typing.List[int]) -> int: ...
    @typing.overload
    @staticmethod
    def hash(char: str) -> int: ...
    @typing.overload
    @staticmethod
    def hash(charArray: typing.List[str]) -> int: ...
    @typing.overload
    @staticmethod
    def hash(double: float) -> int: ...
    @typing.overload
    @staticmethod
    def hash(doubleArray: typing.List[float]) -> int: ...
    @typing.overload
    @staticmethod
    def hash(float: float) -> int: ...
    @typing.overload
    @staticmethod
    def hash(floatArray: typing.List[float]) -> int: ...
    @typing.overload
    @staticmethod
    def hash(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def hash(intArray: typing.List[int]) -> int: ...
    @typing.overload
    @staticmethod
    def hash(object: typing.Any) -> int: ...
    @typing.overload
    @staticmethod
    def hash(tArray: typing.List[_hash_13__T]) -> int: ...
    @typing.overload
    @staticmethod
    def hash(long: int) -> int: ...
    @typing.overload
    @staticmethod
    def hash(longArray: typing.List[int]) -> int: ...
    @typing.overload
    @staticmethod
    def hash(short: int) -> int: ...
    @typing.overload
    @staticmethod
    def hash(shortArray: typing.List[int]) -> int: ...

class HeapFinderDummy:
    def __init__(self): ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...

class HotkeySpecifier(javax.swing.JTextField, java.awt.event.KeyListener):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    def getKey(self) -> int: ...
    def getKeyStroke(self) -> javax.swing.KeyStroke: ...
    @staticmethod
    def getString(keyStroke: javax.swing.KeyStroke) -> str: ...
    @staticmethod
    def getStringForStroke(keyStroke: javax.swing.KeyStroke) -> str: ...
    @staticmethod
    def getStrokeForString(string: str) -> javax.swing.KeyStroke: ...
    def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...

class IconButton(javax.swing.JButton):
    PLUS_ICON: typing.ClassVar[int] = ...
    MINUS_ICON: typing.ClassVar[int] = ...
    TICK_ICON: typing.ClassVar[int] = ...
    CROSS_ICON: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int, color: java.awt.Color, float: float): ...
    @staticmethod
    def getDefaultColor(int: int) -> java.awt.Color: ...

class ImprovedAveragingScaleFilter(java.awt.image.AreaAveragingScaleFilter):
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    def imageComplete(self, int: int) -> None: ...
    def setColorModel(self, colorModel: java.awt.image.ColorModel) -> None: ...
    def setHints(self, int: int) -> None: ...
    @typing.overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: java.awt.image.ColorModel, byteArray: typing.List[int], int5: int, int6: int) -> None: ...
    @typing.overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: java.awt.image.ColorModel, intArray: typing.List[int], int6: int, int7: int) -> None: ...

class IteratorUtils:
    def __init__(self): ...
    _iterate__T = typing.TypeVar('_iterate__T')  # <T>
    @staticmethod
    def iterate(iterator: java.util.Iterator[_iterate__T]) -> java.lang.Iterable[_iterate__T]: ...

class KeyStrokeListener:
    @typing.overload
    def __init__(self, actionListener: java.awt.event.ActionListener): ...
    @typing.overload
    def __init__(self, actionListener: java.awt.event.ActionListener, keyStroke: javax.swing.KeyStroke): ...
    def addKeyStrokeSource(self, keyStrokeSource: 'KeyStrokeSource') -> None: ...
    def getKeyStroke(self) -> javax.swing.KeyStroke: ...
    def keyPressed(self, keyStroke: javax.swing.KeyStroke) -> None: ...
    def removeKeyStrokeSource(self, keyStrokeSource: 'KeyStrokeSource') -> None: ...
    def setKeyStroke(self, keyStroke: javax.swing.KeyStroke) -> None: ...

class KeyStrokeSource:
    def __init__(self, jComponent: javax.swing.JComponent, int: int): ...
    def getComponent(self) -> javax.swing.JComponent: ...
    def getMode(self) -> int: ...

class LaunchButton(javax.swing.JButton):
    UNTRANSLATED_TEXT: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, actionListener: java.awt.event.ActionListener): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str, actionListener: java.awt.event.ActionListener): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str, string5: str, actionListener: java.awt.event.ActionListener): ...
    def getAttributeValueString(self, string: str) -> str: ...
    def getBaseline(self, int: int, int2: int) -> int: ...
    def getHotkeyAttribute(self) -> str: ...
    def getHotkeyConfigurer(self) -> VASSAL.configure.Configurer: ...
    def getIconAttribute(self) -> str: ...
    def getLaunchIcon(self) -> javax.swing.Icon: ...
    def getNameAttribute(self) -> str: ...
    def getNameConfigurer(self) -> VASSAL.configure.Configurer: ...
    def isAlwaysAcceptKeystroke(self) -> bool: ...
    def isNonBlank(self) -> bool: ...
    def setAlwaysAcceptKeystroke(self, boolean: bool) -> None: ...
    def setAttribute(self, string: str, object: typing.Any) -> None: ...
    def setToolTipText(self, string: str) -> None: ...

class LoopControl:
    LOOP_LIMIT: typing.ClassVar[int] = ...
    LOOP_COUNTED: typing.ClassVar[str] = ...
    LOOP_WHILE: typing.ClassVar[str] = ...
    LOOP_UNTIL: typing.ClassVar[str] = ...
    LOOP_TYPES: typing.ClassVar[typing.List[str]] = ...
    LOOP_TYPE_DESCS: typing.ClassVar[typing.List[str]] = ...
    def __init__(self): ...
    @staticmethod
    def loopDescToType(string: str) -> str: ...
    @staticmethod
    def loopTypeToDesc(string: str) -> str: ...

class NamedKeyManager:
    def __init__(self): ...
    @staticmethod
    def getInstance() -> 'NamedKeyManager': ...
    def getKeyStroke(self, string: str, keyStroke: javax.swing.KeyStroke) -> javax.swing.KeyStroke: ...
    def getNextStroke(self) -> int: ...
    @staticmethod
    def isNamed(keyStroke: javax.swing.KeyStroke) -> bool: ...

class NamedKeyStroke:
    NULL_KEYSTROKE: typing.ClassVar['NamedKeyStroke'] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int, int2: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int, string: str): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, keyStroke: javax.swing.KeyStroke): ...
    @typing.overload
    def __init__(self, keyStroke: javax.swing.KeyStroke, string: str): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getDesc(self) -> str: ...
    def getKeyStroke(self) -> javax.swing.KeyStroke: ...
    @staticmethod
    def getKeyStrokeForEvent(keyEvent: java.awt.event.KeyEvent) -> 'NamedKeyStroke': ...
    def getName(self) -> str: ...
    @typing.overload
    @staticmethod
    def getNamedKeyStroke(char: str) -> 'NamedKeyStroke': ...
    @typing.overload
    @staticmethod
    def getNamedKeyStroke(char: str, int: int) -> 'NamedKeyStroke': ...
    @typing.overload
    @staticmethod
    def getNamedKeyStroke(int: int, int2: int) -> 'NamedKeyStroke': ...
    def getStroke(self) -> javax.swing.KeyStroke: ...
    def isNamed(self) -> bool: ...
    def isNull(self) -> bool: ...
    @typing.overload
    @staticmethod
    def of(char: str) -> 'NamedKeyStroke': ...
    @typing.overload
    @staticmethod
    def of(char: str, int: int) -> 'NamedKeyStroke': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int) -> 'NamedKeyStroke': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int, string: str) -> 'NamedKeyStroke': ...
    @typing.overload
    @staticmethod
    def of(keyEvent: java.awt.event.KeyEvent) -> 'NamedKeyStroke': ...
    @typing.overload
    @staticmethod
    def of(string: str) -> 'NamedKeyStroke': ...
    @typing.overload
    @staticmethod
    def of(keyStroke: javax.swing.KeyStroke) -> 'NamedKeyStroke': ...
    @typing.overload
    @staticmethod
    def of(keyStroke: javax.swing.KeyStroke, string: str) -> 'NamedKeyStroke': ...

class Prioritizable:
    def getPriority(self) -> int: ...

class ProblemDialog:
    @typing.overload
    @staticmethod
    def show(int: int, component: java.awt.Component, string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(int: int, component: java.awt.Component, throwable: java.lang.Throwable, string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(int: int, component: java.awt.Component, throwable: java.lang.Throwable, string: str, string2: str, string3: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(int: int, string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(int: int, throwable: java.lang.Throwable, string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(int: int, component: java.awt.Component, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(int: int, component: java.awt.Component, throwable: java.lang.Throwable, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(int: int, component: java.awt.Component, throwable: java.lang.Throwable, string: str, string2: str, string3: str, string4: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(int: int, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(int: int, throwable: java.lang.Throwable, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(int: int, component: java.awt.Component, string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(int: int, component: java.awt.Component, throwable: java.lang.Throwable, string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(int: int, component: java.awt.Component, throwable: java.lang.Throwable, string: str, object: typing.Any, string2: str, string3: str, string4: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(int: int, string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(int: int, throwable: java.lang.Throwable, string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(int: int, component: java.awt.Component, object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(int: int, component: java.awt.Component, throwable: java.lang.Throwable, object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(int: int, component: java.awt.Component, throwable: java.lang.Throwable, object: typing.Any, string: str, string2: str, string3: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(int: int, object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(int: int, throwable: java.lang.Throwable, object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @staticmethod
    def showDisableableNoI18N(int: int, throwable: java.lang.Throwable, object: typing.Any, string: str, string2: str, string3: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showFileOverwriteFailure(int: int, component: java.awt.Component, fileSystemException: java.nio.file.FileSystemException, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showFileOverwriteFailure(int: int, fileSystemException: java.nio.file.FileSystemException, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @staticmethod
    def showOutdatedModule(string: str) -> java.util.concurrent.Future[typing.Any]: ...
    @staticmethod
    def showOutdatedUsage(string: str) -> java.util.concurrent.Future[typing.Any]: ...

class PropertiesEncoder:
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, properties: java.util.Properties): ...
    def getProperties(self) -> java.util.Properties: ...
    def getStringValue(self) -> str: ...
    def toString(self) -> str: ...

class QuickColors:
    QUICK_COLOR_CODES: typing.ClassVar[str] = ...
    QUICK_COLOR_NONE: typing.ClassVar[int] = ...
    QUICK_COLOR_REGEX: typing.ClassVar[typing.List[str]] = ...
    def __init__(self): ...
    @typing.overload
    @staticmethod
    def getQuickColor(char: str) -> int: ...
    @typing.overload
    @staticmethod
    def getQuickColor(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def getQuickColor(string: str, string2: str) -> int: ...
    @typing.overload
    @staticmethod
    def getQuickColorHTMLStyle(string: str) -> str: ...
    @typing.overload
    @staticmethod
    def getQuickColorHTMLStyle(string: str, string2: str) -> str: ...
    @typing.overload
    @staticmethod
    def stripQuickColorTag(string: str) -> str: ...
    @typing.overload
    @staticmethod
    def stripQuickColorTag(string: str, string2: str) -> str: ...

class ReadErrorDialog:
    @typing.overload
    @staticmethod
    def error(iOException: java.io.IOException, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    @staticmethod
    def error(iOException: java.io.IOException, string: str) -> None: ...
    @typing.overload
    @staticmethod
    def error(throwable: java.lang.Throwable, iOException: java.io.IOException, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    @staticmethod
    def error(throwable: java.lang.Throwable, iOException: java.io.IOException, string: str) -> None: ...
    @typing.overload
    @staticmethod
    def errorNoI18N(iOException: java.io.IOException, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    @staticmethod
    def errorNoI18N(iOException: java.io.IOException, string: str) -> None: ...

class RecursionLimitException(java.lang.Exception):
    def __init__(self, loopable: 'RecursionLimiter.Loopable'): ...
    def getAdditionalErrorMessage(self) -> str: ...
    def getComponentName(self) -> str: ...
    def getComponentTypeName(self) -> str: ...
    def setAdditionalErrorMessage(self, string: str) -> None: ...

class RecursionLimiter:
    def __init__(self): ...
    @staticmethod
    def endExecution() -> None: ...
    @staticmethod
    def infiniteLoop(recursionLimitException: RecursionLimitException) -> None: ...
    @staticmethod
    def isReportingInfiniteLoop() -> bool: ...
    @staticmethod
    def startExecution(loopable: 'RecursionLimiter.Loopable') -> None: ...
    class Loopable(VASSAL.script.expression.Auditable): ...

class ReflectionUtils:
    @staticmethod
    def handleImportClassFailure(throwable: java.lang.Throwable, string: str) -> None: ...
    @staticmethod
    def handleNewInstanceFailure(throwable: java.lang.Throwable, class_: typing.Type[typing.Any]) -> None: ...

class ResourcePathFinder:
    def findHelpFileName(self, string: str) -> str: ...
    def findImagePath(self, string: str) -> str: ...

class SavedGameUpdater:
    def __init__(self): ...
    def getPieceSlotsMap(self) -> java.util.Properties: ...
    def updateSavedGame(self, properties: java.util.Properties, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...

class ScrollPane(javax.swing.JScrollPane):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int, int2: int): ...
    @typing.overload
    def __init__(self, component: java.awt.Component): ...
    @typing.overload
    def __init__(self, component: java.awt.Component, int: int, int2: int): ...

class SequenceEncoder:
    @typing.overload
    def __init__(self, char: str): ...
    @typing.overload
    def __init__(self, string: str, char: str): ...
    @typing.overload
    def append(self, propertyExpression: VASSAL.configure.PropertyExpression) -> 'SequenceEncoder': ...
    @typing.overload
    def append(self, namedKeyStroke: NamedKeyStroke) -> 'SequenceEncoder': ...
    @typing.overload
    def append(self, boolean: bool) -> 'SequenceEncoder': ...
    @typing.overload
    def append(self, char: str) -> 'SequenceEncoder': ...
    @typing.overload
    def append(self, double: float) -> 'SequenceEncoder': ...
    @typing.overload
    def append(self, int: int) -> 'SequenceEncoder': ...
    @typing.overload
    def append(self, color: java.awt.Color) -> 'SequenceEncoder': ...
    @typing.overload
    def append(self, string: str) -> 'SequenceEncoder': ...
    @typing.overload
    def append(self, stringArray: typing.List[str]) -> 'SequenceEncoder': ...
    @typing.overload
    def append(self, keyStroke: javax.swing.KeyStroke) -> 'SequenceEncoder': ...
    @typing.overload
    def append(self, long: int) -> 'SequenceEncoder': ...
    def getValue(self) -> str: ...
    @staticmethod
    def main(stringArray: typing.List[str]) -> None: ...
    class Decoder(java.util.Iterator[str]):
        @typing.overload
        def __init__(self, decoder: 'SequenceEncoder.Decoder'): ...
        @typing.overload
        def __init__(self, string: str, char: str): ...
        def copy(self) -> 'SequenceEncoder.Decoder': ...
        def getRemaining(self) -> str: ...
        def hasMoreTokens(self) -> bool: ...
        def hasNext(self) -> bool: ...
        def next(self) -> str: ...
        def nextBoolean(self, boolean: bool) -> bool: ...
        def nextChar(self, char: str) -> str: ...
        def nextColor(self, color: java.awt.Color) -> java.awt.Color: ...
        def nextDouble(self, double: float) -> float: ...
        def nextInt(self, int: int) -> int: ...
        @typing.overload
        def nextKeyStroke(self, char: str) -> javax.swing.KeyStroke: ...
        @typing.overload
        def nextKeyStroke(self, keyStroke: javax.swing.KeyStroke) -> javax.swing.KeyStroke: ...
        def nextLong(self, long: int) -> int: ...
        @typing.overload
        def nextNamedKeyStroke(self) -> NamedKeyStroke: ...
        @typing.overload
        def nextNamedKeyStroke(self, namedKeyStroke: NamedKeyStroke) -> NamedKeyStroke: ...
        @typing.overload
        def nextNamedKeyStroke(self, char: str) -> NamedKeyStroke: ...
        def nextStringArray(self, int: int) -> typing.List[str]: ...
        @typing.overload
        def nextToken(self) -> str: ...
        @typing.overload
        def nextToken(self, string: str) -> str: ...
        def remove(self) -> None: ...

class SplashScreen(javax.swing.JWindow):
    def __init__(self, image: java.awt.Image): ...
    @staticmethod
    def disposeAll() -> None: ...
    @staticmethod
    def sendAllToBack() -> None: ...
    def setVisible(self, boolean: bool) -> None: ...

class ThrowableUtils:
    _getAncestor__T = typing.TypeVar('_getAncestor__T', bound=java.lang.Throwable)  # <T>
    @staticmethod
    def getAncestor(class_: typing.Type[_getAncestor__T], throwable: java.lang.Throwable) -> _getAncestor__T: ...
    _getRecent__T = typing.TypeVar('_getRecent__T', bound=java.lang.Throwable)  # <T>
    @staticmethod
    def getRecent(class_: typing.Type[_getRecent__T], throwable: java.lang.Throwable) -> _getRecent__T: ...
    @staticmethod
    def getStackTrace(throwable: java.lang.Throwable) -> str: ...
    _throwAncestor__T = typing.TypeVar('_throwAncestor__T', bound=java.lang.Throwable)  # <T>
    @staticmethod
    def throwAncestor(class_: typing.Type[_throwAncestor__T], throwable: java.lang.Throwable) -> None: ...
    _throwRecent__T = typing.TypeVar('_throwRecent__T', bound=java.lang.Throwable)  # <T>
    @staticmethod
    def throwRecent(class_: typing.Type[_throwRecent__T], throwable: java.lang.Throwable) -> None: ...

class ToolBarComponent:
    def getToolBar(self) -> javax.swing.JToolBar: ...

class URLUtils:
    @typing.overload
    @staticmethod
    def toJarURL(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> java.net.URL: ...
    @typing.overload
    @staticmethod
    def toJarURL(string: str) -> java.net.URL: ...
    @typing.overload
    @staticmethod
    def toURL(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> java.net.URL: ...
    @typing.overload
    @staticmethod
    def toURL(string: str) -> java.net.URL: ...

class UniqueIdManager(VASSAL.configure.ValidityChecker):
    def __init__(self, string: str): ...
    def add(self, identifyable: 'UniqueIdManager.Identifyable') -> None: ...
    def findInstance(self, string: str) -> 'UniqueIdManager.Identifyable': ...
    def getAllInstances(self) -> java.util.Iterator['UniqueIdManager.Identifyable']: ...
    @staticmethod
    def getIdentifier(identifyable: 'UniqueIdManager.Identifyable') -> str: ...
    def remove(self, identifyable: 'UniqueIdManager.Identifyable') -> None: ...
    def validate(self, buildable: VASSAL.build.Buildable, validationReport: VASSAL.configure.ValidationReport) -> None: ...
    class Identifyable:
        def getConfigureName(self) -> str: ...
        def getId(self) -> str: ...
        def setId(self, string: str) -> None: ...

class UsernameAndPasswordDialog(javax.swing.JDialog):
    def __init__(self, frame: java.awt.Frame): ...

class WarningDialog:
    @typing.overload
    @staticmethod
    def show(component: java.awt.Component, string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(component: java.awt.Component, throwable: java.lang.Throwable, string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(component: java.awt.Component, throwable: java.lang.Throwable, string: str, string2: str, string3: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def show(throwable: java.lang.Throwable, string: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(component: java.awt.Component, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(component: java.awt.Component, throwable: java.lang.Throwable, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(component: java.awt.Component, throwable: java.lang.Throwable, string: str, string2: str, string3: str, string4: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetails(throwable: java.lang.Throwable, string: str, string2: str, *object: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(component: java.awt.Component, string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(component: java.awt.Component, throwable: java.lang.Throwable, string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(component: java.awt.Component, throwable: java.lang.Throwable, string: str, object: typing.Any, string2: str, string3: str, string4: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDetailsDisableable(throwable: java.lang.Throwable, string: str, object: typing.Any, string2: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(component: java.awt.Component, object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(component: java.awt.Component, throwable: java.lang.Throwable, object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(component: java.awt.Component, throwable: java.lang.Throwable, object: typing.Any, string: str, string2: str, string3: str) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...
    @typing.overload
    @staticmethod
    def showDisableable(throwable: java.lang.Throwable, object: typing.Any, string: str, *object2: typing.Any) -> java.util.concurrent.Future[typing.Any]: ...

class WrapLayout(java.awt.FlowLayout):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int, int3: int): ...
    def layoutContainer(self, container: java.awt.Container) -> None: ...
    def minimumLayoutSize(self, container: java.awt.Container) -> java.awt.Dimension: ...
    def preferredLayoutSize(self, container: java.awt.Container) -> java.awt.Dimension: ...

class WriteErrorDialog:
    @typing.overload
    @staticmethod
    def error(iOException: java.io.IOException, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    @staticmethod
    def error(iOException: java.io.IOException, string: str) -> None: ...
    @typing.overload
    @staticmethod
    def error(throwable: java.lang.Throwable, iOException: java.io.IOException, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> None: ...
    @typing.overload
    @staticmethod
    def error(throwable: java.lang.Throwable, iOException: java.io.IOException, string: str) -> None: ...
    @staticmethod
    def reportFileOverwriteFailure(fileSystemException: java.nio.file.FileSystemException, string: str) -> None: ...
    @staticmethod
    def showError(component: java.awt.Component, iOException: java.io.IOException, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], string: str) -> None: ...

class AdjustableSpeedScrollPane(ScrollPane):
    @typing.overload
    def __init__(self, component: java.awt.Component): ...
    @typing.overload
    def __init__(self, component: java.awt.Component, int: int, int2: int): ...

class ArchiveWriter(DataArchive):
    @typing.overload
    def __init__(self, fileArchive: VASSAL.tools.io.FileArchive): ...
    @typing.overload
    def __init__(self, fileArchive: VASSAL.tools.io.FileArchive, string: str): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def addFile(self, string: str, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def addFile(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def addFile(self, string: str, string2: str) -> None: ...
    @typing.overload
    def addImage(self, string: str, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def addImage(self, string: str, string2: str) -> None: ...
    def addSound(self, string: str, string2: str) -> None: ...
    def removeFile(self, string: str) -> None: ...
    def removeImage(self, string: str) -> None: ...
    @typing.overload
    def save(self) -> None: ...
    @typing.overload
    def save(self, boolean: bool) -> None: ...
    @typing.overload
    def saveAs(self) -> None: ...
    @typing.overload
    def saveAs(self, boolean: bool) -> None: ...
    @typing.overload
    def saveAsButVerify(self) -> bool: ...
    @typing.overload
    def saveAsButVerify(self, boolean: bool) -> bool: ...
    @typing.overload
    def saveButVerify(self) -> bool: ...
    @typing.overload
    def saveButVerify(self, boolean: bool) -> bool: ...

class AudioSystemClip(AudioClip):
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream): ...
    @typing.overload
    def __init__(self, uRL: java.net.URL): ...
    def play(self) -> None: ...

class FormattedString(RecursionLimiter.Loopable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, propertySource: VASSAL.build.module.properties.PropertySource): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, propertySource: VASSAL.build.module.properties.PropertySource): ...
    def clearProperties(self) -> None: ...
    @typing.overload
    def debugInfo(self, string: str, string2: str) -> str: ...
    @typing.overload
    @staticmethod
    def debugInfo(formattedString: 'FormattedString', string: str, string2: str) -> str: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getComponentName(self) -> str: ...
    def getComponentTypeName(self) -> str: ...
    def getDefaultProperties(self) -> VASSAL.build.module.properties.PropertySource: ...
    def getFormat(self) -> str: ...
    @typing.overload
    def getLocalizedText(self) -> str: ...
    @typing.overload
    def getLocalizedText(self, propertySource: VASSAL.build.module.properties.PropertySource) -> str: ...
    @typing.overload
    def getLocalizedText(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> str: ...
    @typing.overload
    def getLocalizedText(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: VASSAL.script.expression.Auditable, string: str) -> str: ...
    @typing.overload
    def getLocalizedText(self, auditable: VASSAL.script.expression.Auditable, string: str) -> str: ...
    @typing.overload
    def getText(self) -> str: ...
    @typing.overload
    def getText(self, propertySource: VASSAL.build.module.properties.PropertySource) -> str: ...
    @typing.overload
    def getText(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> str: ...
    @typing.overload
    def getText(self, propertySource: VASSAL.build.module.properties.PropertySource, auditable: VASSAL.script.expression.Auditable, string: str) -> str: ...
    @typing.overload
    def getText(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool) -> str: ...
    @typing.overload
    def getText(self, propertySource: VASSAL.build.module.properties.PropertySource, boolean: bool, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> str: ...
    @typing.overload
    def getText(self, propertySource: VASSAL.build.module.properties.PropertySource, string: str) -> str: ...
    @typing.overload
    def getText(self, propertySource: VASSAL.build.module.properties.PropertySource, string: str, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> str: ...
    @typing.overload
    def getText(self, propertySource: VASSAL.build.module.properties.PropertySource, string: str, auditable: VASSAL.script.expression.Auditable, string2: str) -> str: ...
    @typing.overload
    def getText(self, auditable: VASSAL.script.expression.Auditable, string: str) -> str: ...
    @typing.overload
    def getTextAsInt(self, propertySource: VASSAL.build.module.properties.PropertySource, string: str, abstractConfigurable: VASSAL.build.AbstractConfigurable) -> int: ...
    @typing.overload
    def getTextAsInt(self, propertySource: VASSAL.build.module.properties.PropertySource, string: str, editablePiece: VASSAL.counters.EditablePiece) -> int: ...
    @typing.overload
    def getTextAsInt(self, propertySource: VASSAL.build.module.properties.PropertySource, string: str, editablePiece: VASSAL.counters.EditablePiece, auditable: VASSAL.script.expression.Auditable, auditTrail: VASSAL.script.expression.AuditTrail) -> int: ...
    def hashCode(self) -> int: ...
    def setDefaultProperties(self, propertySource: VASSAL.build.module.properties.PropertySource) -> None: ...
    def setFormat(self, string: str) -> None: ...
    def setProperty(self, string: str, string2: str) -> None: ...

class JarArchive(DataArchive):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    def getInputStream(self, string: str) -> java.io.InputStream: ...
    def getName(self) -> str: ...
    @typing.overload
    def getURL(self) -> java.net.URL: ...
    @typing.overload
    def getURL(self, string: str) -> java.net.URL: ...

class Mp3AudioClip(AudioClip):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, uRL: java.net.URL): ...
    def play(self) -> None: ...

class NamedKeyStrokeListener(KeyStrokeListener):
    @typing.overload
    def __init__(self, actionListener: java.awt.event.ActionListener): ...
    @typing.overload
    def __init__(self, actionListener: java.awt.event.ActionListener, namedKeyStroke: NamedKeyStroke): ...
    def getNamedKeyStroke(self) -> NamedKeyStroke: ...
    @typing.overload
    def setKeyStroke(self, namedKeyStroke: NamedKeyStroke) -> None: ...
    @typing.overload
    def setKeyStroke(self, keyStroke: javax.swing.KeyStroke) -> None: ...

class TemporaryToolBar(ToolBarComponent):
    def __init__(self): ...
    def getToolBar(self) -> javax.swing.JToolBar: ...
    def setDelegate(self, toolBarComponent: typing.Union[ToolBarComponent, typing.Callable]) -> None: ...

class PlayerIdFormattedString(FormattedString):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class Sort:
    def __init__(self): ...
    @staticmethod
    def quicksort(vector: java.util.Vector[typing.Any], comparator: typing.Union['Sort.Comparator', typing.Callable]) -> None: ...
    class Alpha(VASSAL.tools.Sort.Comparator):
        def __init__(self): ...
        def compare(self, object: typing.Any, object2: typing.Any) -> int: ...
    class Comparator:
        def compare(self, object: typing.Any, object2: typing.Any) -> int: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.tools")``.

    ActionManager: typing.Type[ActionManager]
    AdjustableSpeedScrollPane: typing.Type[AdjustableSpeedScrollPane]
    ApplicationIcons: typing.Type[ApplicationIcons]
    ArchiveWriter: typing.Type[ArchiveWriter]
    ArgsParser: typing.Type[ArgsParser]
    ArrayIterator: typing.Type[ArrayIterator]
    ArrayUtils: typing.Type[ArrayUtils]
    AudioClip: typing.Type[AudioClip]
    AudioSystemClip: typing.Type[AudioSystemClip]
    BackgroundTask: typing.Type[BackgroundTask]
    BrowserSupport: typing.Type[BrowserSupport]
    BugDialog: typing.Type[BugDialog]
    BugUtils: typing.Type[BugUtils]
    ButtonFactory: typing.Type[ButtonFactory]
    CRCUtils: typing.Type[CRCUtils]
    ColorButton: typing.Type[ColorButton]
    ComponentPathBuilder: typing.Type[ComponentPathBuilder]
    ComponentSplitter: typing.Type[ComponentSplitter]
    DataArchive: typing.Type[DataArchive]
    DialogUtils: typing.Type[DialogUtils]
    EnumeratedIterator: typing.Type[EnumeratedIterator]
    ErrorDialog: typing.Type[ErrorDialog]
    FormattedString: typing.Type[FormattedString]
    FutureUtils: typing.Type[FutureUtils]
    HTTPPostBuilder: typing.Type[HTTPPostBuilder]
    HashCode: typing.Type[HashCode]
    HeapFinderDummy: typing.Type[HeapFinderDummy]
    HotkeySpecifier: typing.Type[HotkeySpecifier]
    IconButton: typing.Type[IconButton]
    ImprovedAveragingScaleFilter: typing.Type[ImprovedAveragingScaleFilter]
    IteratorUtils: typing.Type[IteratorUtils]
    JarArchive: typing.Type[JarArchive]
    KeyStrokeListener: typing.Type[KeyStrokeListener]
    KeyStrokeSource: typing.Type[KeyStrokeSource]
    LaunchButton: typing.Type[LaunchButton]
    LoopControl: typing.Type[LoopControl]
    Mp3AudioClip: typing.Type[Mp3AudioClip]
    NamedKeyManager: typing.Type[NamedKeyManager]
    NamedKeyStroke: typing.Type[NamedKeyStroke]
    NamedKeyStrokeListener: typing.Type[NamedKeyStrokeListener]
    PlayerIdFormattedString: typing.Type[PlayerIdFormattedString]
    Prioritizable: typing.Type[Prioritizable]
    ProblemDialog: typing.Type[ProblemDialog]
    PropertiesEncoder: typing.Type[PropertiesEncoder]
    QuickColors: typing.Type[QuickColors]
    ReadErrorDialog: typing.Type[ReadErrorDialog]
    RecursionLimitException: typing.Type[RecursionLimitException]
    RecursionLimiter: typing.Type[RecursionLimiter]
    ReflectionUtils: typing.Type[ReflectionUtils]
    ResourcePathFinder: typing.Type[ResourcePathFinder]
    SavedGameUpdater: typing.Type[SavedGameUpdater]
    ScrollPane: typing.Type[ScrollPane]
    SequenceEncoder: typing.Type[SequenceEncoder]
    Sort: typing.Type[Sort]
    SplashScreen: typing.Type[SplashScreen]
    TemporaryToolBar: typing.Type[TemporaryToolBar]
    ThrowableUtils: typing.Type[ThrowableUtils]
    ToolBarComponent: typing.Type[ToolBarComponent]
    URLUtils: typing.Type[URLUtils]
    UniqueIdManager: typing.Type[UniqueIdManager]
    UsernameAndPasswordDialog: typing.Type[UsernameAndPasswordDialog]
    WarningDialog: typing.Type[WarningDialog]
    WrapLayout: typing.Type[WrapLayout]
    WriteErrorDialog: typing.Type[WriteErrorDialog]
    bug: VASSAL.tools.bug.__module_protocol__
    concurrent: VASSAL.tools.concurrent.__module_protocol__
    deprecation: VASSAL.tools.deprecation.__module_protocol__
    filechooser: VASSAL.tools.filechooser.__module_protocol__
    icon: VASSAL.tools.icon.__module_protocol__
    image: VASSAL.tools.image.__module_protocol__
    imageop: VASSAL.tools.imageop.__module_protocol__
    imports: VASSAL.tools.imports.__module_protocol__
    io: VASSAL.tools.io.__module_protocol__
    lang: VASSAL.tools.lang.__module_protocol__
    logging: VASSAL.tools.logging.__module_protocol__
    menu: VASSAL.tools.menu.__module_protocol__
    opcache: VASSAL.tools.opcache.__module_protocol__
    swing: VASSAL.tools.swing.__module_protocol__
    version: VASSAL.tools.version.__module_protocol__
