import java.awt.event
import java.util
import javax.swing
import typing



_ChildProxy__T = typing.TypeVar('_ChildProxy__T', bound=javax.swing.JComponent)  # <T>
class ChildProxy(typing.Generic[_ChildProxy__T]):
    def createPeer(self) -> _ChildProxy__T: ...
    def getParent(self) -> 'ParentProxy': ...
    def setParent(self, parentProxy: 'ParentProxy') -> None: ...

class MenuManager:
    def __init__(self): ...
    def addAction(self, string: str, action: javax.swing.Action) -> None: ...
    def addKey(self, string: str) -> 'MenuItemProxy': ...
    def addMarker(self, string: str) -> 'MenuMarker': ...
    def addToSection(self, string: str, childProxy: ChildProxy[typing.Any]) -> None: ...
    @staticmethod
    def getInstance() -> 'MenuManager': ...
    def getItems(self, string: str) -> java.util.List['MenuItemProxy']: ...
    def getMarker(self, string: str) -> 'MenuMarker': ...
    def getMenuBarFor(self, jFrame: javax.swing.JFrame) -> javax.swing.JMenuBar: ...
    def getMenuBarProxyFor(self, jFrame: javax.swing.JFrame) -> 'MenuBarProxy': ...
    def removeAction(self, string: str) -> None: ...
    def removeFromSection(self, string: str, childProxy: ChildProxy[typing.Any]) -> None: ...

class MenuScroller:
    @typing.overload
    def __init__(self, jMenu: javax.swing.JMenu): ...
    @typing.overload
    def __init__(self, jMenu: javax.swing.JMenu, int: int): ...
    @typing.overload
    def __init__(self, jMenu: javax.swing.JMenu, int: int, int2: int): ...
    @typing.overload
    def __init__(self, jMenu: javax.swing.JMenu, int: int, int2: int, int3: int, int4: int): ...
    @typing.overload
    def __init__(self, jPopupMenu: javax.swing.JPopupMenu): ...
    @typing.overload
    def __init__(self, jPopupMenu: javax.swing.JPopupMenu, int: int): ...
    @typing.overload
    def __init__(self, jPopupMenu: javax.swing.JPopupMenu, int: int, int2: int): ...
    @typing.overload
    def __init__(self, jPopupMenu: javax.swing.JPopupMenu, int: int, int2: int, int3: int, int4: int): ...
    def getBottomFixedCount(self) -> int: ...
    def getInterval(self) -> int: ...
    def getTopFixedCount(self) -> int: ...
    def getscrollCount(self) -> int: ...
    @typing.overload
    def keepVisible(self, int: int) -> None: ...
    @typing.overload
    def keepVisible(self, jMenuItem: javax.swing.JMenuItem) -> None: ...
    def setBottomFixedCount(self, int: int) -> None: ...
    def setInterval(self, int: int) -> None: ...
    def setScrollCount(self, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def setScrollerFor(jMenu: javax.swing.JMenu) -> 'MenuScroller': ...
    @typing.overload
    @staticmethod
    def setScrollerFor(jMenu: javax.swing.JMenu, int: int) -> 'MenuScroller': ...
    @typing.overload
    @staticmethod
    def setScrollerFor(jMenu: javax.swing.JMenu, int: int, int2: int) -> 'MenuScroller': ...
    @typing.overload
    @staticmethod
    def setScrollerFor(jMenu: javax.swing.JMenu, int: int, int2: int, int3: int, int4: int) -> 'MenuScroller': ...
    @typing.overload
    @staticmethod
    def setScrollerFor(jPopupMenu: javax.swing.JPopupMenu) -> 'MenuScroller': ...
    @typing.overload
    @staticmethod
    def setScrollerFor(jPopupMenu: javax.swing.JPopupMenu, int: int) -> 'MenuScroller': ...
    @typing.overload
    @staticmethod
    def setScrollerFor(jPopupMenu: javax.swing.JPopupMenu, int: int, int2: int) -> 'MenuScroller': ...
    @typing.overload
    @staticmethod
    def setScrollerFor(jPopupMenu: javax.swing.JPopupMenu, int: int, int2: int, int3: int, int4: int) -> 'MenuScroller': ...
    def setTopFixedCount(self, int: int) -> None: ...

class ParentProxy:
    def add(self, childProxy: ChildProxy[typing.Any]) -> None: ...
    def getChild(self, int: int) -> ChildProxy[typing.Any]: ...
    def getChildCount(self) -> int: ...
    def getChildren(self) -> typing.List[ChildProxy[typing.Any]]: ...
    def getIndex(self, childProxy: ChildProxy[typing.Any]) -> int: ...
    def insert(self, childProxy: ChildProxy[typing.Any], int: int) -> None: ...
    @typing.overload
    def remove(self, childProxy: ChildProxy[typing.Any]) -> None: ...
    @typing.overload
    def remove(self, int: int) -> None: ...

_AbstractProxy__T = typing.TypeVar('_AbstractProxy__T', bound=javax.swing.JComponent)  # <T>
class AbstractProxy(ChildProxy[_AbstractProxy__T], typing.Generic[_AbstractProxy__T]):
    def __init__(self): ...
    def createPeer(self) -> _AbstractProxy__T: ...
    def getParent(self) -> ParentProxy: ...
    def setParent(self, parentProxy: ParentProxy) -> None: ...

class MacOSXMenuManager(MenuManager):
    def __init__(self): ...
    def addAction(self, string: str, action: javax.swing.Action) -> None: ...
    def addKey(self, string: str) -> 'MenuItemProxy': ...
    def getMenuBarFor(self, jFrame: javax.swing.JFrame) -> javax.swing.JMenuBar: ...
    def getMenuBarProxyFor(self, jFrame: javax.swing.JFrame) -> 'MenuBarProxy': ...

class MenuMarker(ChildProxy[javax.swing.JComponent]):
    def __init__(self): ...
    def createPeer(self) -> javax.swing.JComponent: ...
    def getParent(self) -> ParentProxy: ...
    def setParent(self, parentProxy: ParentProxy) -> None: ...

_AbstractParent__T = typing.TypeVar('_AbstractParent__T', bound=javax.swing.JComponent)  # <T>
class AbstractParent(AbstractProxy[_AbstractParent__T], ParentProxy, typing.Generic[_AbstractParent__T]):
    def __init__(self): ...
    def add(self, childProxy: ChildProxy[typing.Any]) -> None: ...
    def getChild(self, int: int) -> ChildProxy[typing.Any]: ...
    def getChildCount(self) -> int: ...
    def getChildren(self) -> typing.List[ChildProxy[typing.Any]]: ...
    def getIndex(self, childProxy: ChildProxy[typing.Any]) -> int: ...
    def insert(self, childProxy: ChildProxy[typing.Any], int: int) -> None: ...
    @typing.overload
    def remove(self, childProxy: ChildProxy[typing.Any]) -> None: ...
    @typing.overload
    def remove(self, int: int) -> None: ...

class CheckBoxMenuItemProxy(AbstractProxy[javax.swing.JCheckBoxMenuItem], java.awt.event.ItemListener):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, action: javax.swing.Action): ...
    @typing.overload
    def __init__(self, action: javax.swing.Action, boolean: bool): ...
    def createPeer(self) -> javax.swing.JCheckBoxMenuItem: ...
    def getAction(self) -> javax.swing.Action: ...
    def isSelected(self) -> bool: ...
    def itemStateChanged(self, itemEvent: java.awt.event.ItemEvent) -> None: ...
    def setAction(self, action: javax.swing.Action) -> None: ...
    def setSelected(self, boolean: bool) -> None: ...

class MenuItemProxy(AbstractProxy[javax.swing.JMenuItem]):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, action: javax.swing.Action): ...
    def createPeer(self) -> javax.swing.JMenuItem: ...
    def getAction(self) -> javax.swing.Action: ...
    def setAction(self, action: javax.swing.Action) -> None: ...

class SeparatorProxy(AbstractProxy[javax.swing.JSeparator]):
    def __init__(self): ...
    def createPeer(self) -> javax.swing.JSeparator: ...

class MenuBarProxy(AbstractParent[javax.swing.JMenuBar]):
    def __init__(self): ...
    def createPeer(self) -> javax.swing.JMenuBar: ...

class MenuProxy(AbstractParent[javax.swing.JMenu]):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    def addSeparator(self) -> SeparatorProxy: ...
    def createPeer(self) -> javax.swing.JMenu: ...
    def getText(self) -> str: ...
    def insertSeparator(self, int: int) -> SeparatorProxy: ...
    def setMnemonic(self, char: str) -> None: ...
    def setText(self, string: str) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.tools.menu")``.

    AbstractParent: typing.Type[AbstractParent]
    AbstractProxy: typing.Type[AbstractProxy]
    CheckBoxMenuItemProxy: typing.Type[CheckBoxMenuItemProxy]
    ChildProxy: typing.Type[ChildProxy]
    MacOSXMenuManager: typing.Type[MacOSXMenuManager]
    MenuBarProxy: typing.Type[MenuBarProxy]
    MenuItemProxy: typing.Type[MenuItemProxy]
    MenuManager: typing.Type[MenuManager]
    MenuMarker: typing.Type[MenuMarker]
    MenuProxy: typing.Type[MenuProxy]
    MenuScroller: typing.Type[MenuScroller]
    ParentProxy: typing.Type[ParentProxy]
    SeparatorProxy: typing.Type[SeparatorProxy]
